/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InputItemStacks
implements IInputItemStack {
    public final List<ItemStack> input = new ArrayList<ItemStack>();
    public int amount;

    public InputItemStacks(ItemStack[] input) {
        this(input, ModUtils.getSize(input[0]));
    }

    InputItemStacks(ItemStack[] input, int amount) {
        for (ItemStack stack : input) {
            this.input.add(stack.func_77946_l());
        }
        this.amount = amount;
    }

    @Override
    public boolean matches(ItemStack subject) {
        List<ItemStack> inputs = this.input;
        Item subjectItem = subject.func_77973_b();
        int subjectMeta = subject.func_77952_i();
        return inputs.stream().anyMatch(oreStack -> {
            Item oreItem = oreStack.func_77973_b();
            int metaRequired = oreStack.func_77952_i();
            return subjectItem == oreItem && (subjectMeta == metaRequired || metaRequired == Short.MAX_VALUE);
        });
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void growAmount(int col) {
        this.amount += col;
        for (ItemStack stack : this.input) {
            stack.func_190920_e(this.getAmount());
        }
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.input;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (this.getClass() != obj.getClass()) return false;
        InputItemStacks other = (InputItemStacks)obj;
        if (!this.input.equals(other.input)) return false;
        if (other.amount != this.amount) return false;
        return true;
    }
}

