/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.recipe.IInputItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class InputOreDict
implements IInputItemStack {
    public final String input;
    public final Integer meta;
    public int amount;
    private List<ItemStack> ores;

    InputOreDict(String input) {
        this(input, 1);
    }

    public InputOreDict(String input, int amount) {
        this(input, amount, null);
    }

    InputOreDict(String input, int amount, Integer meta) {
        this.input = input;
        this.amount = amount;
        this.meta = meta;
    }

    @Override
    public boolean matches(ItemStack subject) {
        List<ItemStack> inputs = this.getOres();
        boolean useOreStackMeta = this.meta == null;
        Item subjectItem = subject.func_77973_b();
        int subjectMeta = subject.func_77952_i();
        return inputs.stream().anyMatch(oreStack -> {
            Item oreItem = oreStack.func_77973_b();
            int metaRequired = useOreStackMeta ? oreStack.func_77952_i() : this.meta.intValue();
            return subjectItem == oreItem && (subjectMeta == metaRequired || metaRequired == Short.MAX_VALUE);
        });
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void growAmount(int col) {
        this.amount += col;
        for (ItemStack stack : this.getOres()) {
            stack.func_190920_e(this.getAmount());
        }
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.getOres();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            InputOreDict other = (InputOreDict)obj;
            if (this.input.equals(other.input) && other.amount == this.amount) {
                return Objects.equals(this.meta, other.meta);
            }
        }
        return false;
    }

    private List<ItemStack> getOres() {
        if (this.ores != null) {
            return this.ores;
        }
        this.ores = new ArrayList<ItemStack>();
        NonNullList ret = OreDictionary.getOres((String)this.input);
        if (ret != OreDictionary.EMPTY_LIST) {
            for (ItemStack stack : ret) {
                stack = stack.func_77946_l();
                stack.func_190920_e(this.getAmount());
                this.ores.add(stack);
            }
        }
        return this.ores;
    }
}

