/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.crop;

import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.ICrop;
import com.denfop.blocks.state.TileEntityBlockStateContainer;
import com.denfop.blocks.state.UnlistedProperty;
import com.denfop.render.base.AbstractModel;
import com.denfop.render.base.BakedBlockModel;
import com.denfop.render.base.ModelCuboidUtil;
import com.denfop.render.crop.CropList;
import com.denfop.render.crop.CropRenderState;
import com.denfop.render.crop.CropTextures;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CropRender
extends AbstractModel {
    public static final IUnlistedProperty<CropRenderState> renderStateProperty = new UnlistedProperty<CropRenderState>("renderstate", CropRenderState.class);
    private static final ResourceLocation STICK = new ResourceLocation("industrialupgrade", "blocks/stick");
    private static final ResourceLocation UPGRADED_STICK = new ResourceLocation("industrialupgrade", "blocks/stick_upgraded");
    private static final CropList<CropTextures> textures = new CropList();
    private static final List<ResourceLocation> texturesList = new ArrayList<ResourceLocation>();
    private final LoadingCache<CropRenderState, IBakedModel> modelCache;

    public CropRender() {
        this.preloadTextures();
        this.modelCache = CacheBuilder.newBuilder().maximumSize(256L).expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(this::createModel));
    }

    private void preloadTextures() {
        if (textures.isEmpty()) {
            textures.add(new CropTextures(STICK));
            textures.add(new CropTextures(UPGRADED_STICK));
            CropNetwork.instance.getCropMap().values().forEach(crop -> {
                crop.getTextures().forEach(location -> textures.add(new CropTextures((ResourceLocation)location)));
                crop.getTopTexture().forEach(location -> textures.add(new CropTextures((ResourceLocation)location)));
            });
            textures.forEach(cropTextures -> texturesList.add(cropTextures.getLocation()));
        }
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return texturesList;
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        textures.forEach(location -> location.setSprite((TextureAtlasSprite)bakedTextureGetter.apply(location.getLocation())));
        return this;
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState rawState, EnumFacing side, long rand) {
        CropRenderState renderState = this.extractRenderState(rawState);
        try {
            return ((IBakedModel)this.modelCache.get((Object)renderState)).func_188616_a(rawState, side, rand);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private CropRenderState extractRenderState(IBlockState rawState) {
        if (rawState instanceof TileEntityBlockStateContainer.PropertiesStateInstance) {
            TileEntityBlockStateContainer.PropertiesStateInstance stateInstance = (TileEntityBlockStateContainer.PropertiesStateInstance)rawState;
            return stateInstance.hasValue(renderStateProperty) ? stateInstance.getValue(renderStateProperty) : new CropRenderState(null, false, false);
        }
        return new CropRenderState(null, false, false);
    }

    public IBakedModel createModel(CropRenderState state) {
        if (state.crop != null && state.crop.getStage() >= 0) {
            return this.createCropModel(state);
        }
        return this.createStickModel(state.isDoubleStick());
    }

    private IBakedModel createCropModel(CropRenderState state) {
        TextureAtlasSprite cropSprite;
        List[] faceQuads = new List[EnumFacing.field_176754_o.length];
        for (int i = 0; i < faceQuads.length; ++i) {
            faceQuads[i] = new ArrayList();
        }
        ArrayList<BakedQuad> generalQuads = new ArrayList<BakedQuad>();
        TextureAtlasSprite stickSprite = ((CropTextures)textures.get(0)).getSprite();
        if (!state.isNeedTwoTexture()) {
            this.addCroppedQuads(faceQuads, generalQuads, stickSprite, 0);
        }
        if ((cropSprite = state.isNeedTwoTexture() ? textures.getTextures(this.getTopTextureLocation(state.crop)) : textures.getTextures(this.getTextureLocation(state.crop))) == null) {
            cropSprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        if (cropSprite != Minecraft.func_71410_x().func_147117_R().func_174944_f() && state.isNeedTwoTexture() || !state.isNeedTwoTexture()) {
            this.addCroppedQuads(faceQuads, generalQuads, cropSprite, state.crop.getRender());
        }
        return new BakedBlockModel(this.optimizeFaceQuads(faceQuads), generalQuads.isEmpty() ? Collections.emptyList() : generalQuads, cropSprite);
    }

    private void addCroppedQuads(List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads, TextureAtlasSprite sprite, int render) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (render == 0) {
                this.addQuadForFacing(faceQuads, generalQuads, sprite, facing);
                continue;
            }
            this.addSugarCaneQuads(faceQuads, generalQuads, sprite, facing);
        }
    }

    private void addCroppedQuadsTop(List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads, TextureAtlasSprite sprite, int render) {
        if (sprite == Minecraft.func_71410_x().func_147117_R().func_174944_f()) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (render == 0) {
                this.addQuadForFacingTop(faceQuads, generalQuads, sprite, facing);
                continue;
            }
            this.addSugarCaneQuadsTop(faceQuads, generalQuads, sprite, facing);
        }
    }

    private void addQuadForFacing(List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads, TextureAtlasSprite sprite, EnumFacing facing) {
        int offsetX = facing.func_82601_c();
        int offsetZ = facing.func_82599_e();
        float x = this.calculatePosition(offsetX);
        float z = this.calculatePosition(offsetZ);
        float xS = offsetX == 0 ? 0.0f : x;
        float xE = offsetX == 0 ? 1.0f : x;
        float zS = offsetZ == 0 ? 0.0f : z;
        float zE = offsetZ == 0 ? 1.0f : z;
        ModelCuboidUtil.addFlippedCuboidWithYOffset(xS, 0.001f, zS, xE, 1.0f, zE, -1, EnumSet.of(facing), sprite, faceQuads, generalQuads, -0.0625f);
        ModelCuboidUtil.addFlippedCuboidWithYOffset(xS, 0.001f, zS, xE, 1.0f, zE, -1, EnumSet.of(facing.func_176734_d()), sprite, faceQuads, generalQuads, -0.0625f);
    }

    private void addQuadForFacingTop(List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads, TextureAtlasSprite sprite, EnumFacing facing) {
        int offsetX = facing.func_82601_c();
        int offsetZ = facing.func_82599_e();
        float x = this.calculatePosition(offsetX);
        float z = this.calculatePosition(offsetZ);
        float xS = offsetX == 0 ? 0.0f : x;
        float xE = offsetX == 0 ? 1.0f : x;
        float zS = offsetZ == 0 ? 0.0f : z;
        float zE = offsetZ == 0 ? 1.0f : z;
        ModelCuboidUtil.addFlippedCuboidWithYOffset(xS, 0.001f, zS, xE, 1.0f, zE, -1, EnumSet.of(facing), sprite, faceQuads, generalQuads, -0.0625f);
        ModelCuboidUtil.addFlippedCuboidWithYOffset(xS, 0.001f, zS, xE, 1.0f, zE, -1, EnumSet.of(facing.func_176734_d()), sprite, faceQuads, generalQuads, -0.0625f);
    }

    private void addSugarCaneQuads(List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads, TextureAtlasSprite sprite, EnumFacing facing) {
        float offsetX = facing.func_82601_c();
        float offsetZ = facing.func_82599_e();
        float xOffset = 0.5f;
        float zOffset = 0.5f;
        float size = 0.5f;
        float xS = xOffset - size * offsetZ;
        float xE = xOffset + size * offsetZ;
        float zS = zOffset + size * offsetX;
        float zE = zOffset - size * offsetX;
        ModelCuboidUtil.addFlippedCuboidWithYOffset(xS, 0.001f, zS, xE, 1.0f, zE, -1, EnumSet.of(facing), sprite, faceQuads, generalQuads, -0.0625f);
        ModelCuboidUtil.addFlippedCuboidWithYOffset(xS, 0.001f, zS, xE, 1.0f, zE, -1, EnumSet.of(facing.func_176734_d()), sprite, faceQuads, generalQuads, -0.0625f);
    }

    private void addSugarCaneQuadsTop(List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads, TextureAtlasSprite sprite, EnumFacing facing) {
        float offsetX = facing.func_82601_c();
        float offsetZ = facing.func_82599_e();
        float xOffset = 0.5f;
        float zOffset = 0.5f;
        float size = 0.5f;
        float xS = xOffset - size * offsetZ;
        float xE = xOffset + size * offsetZ;
        float zS = zOffset + size * offsetX;
        float zE = zOffset - size * offsetX;
        ModelCuboidUtil.addFlippedCuboidWithYOffset(xS, 1.0f, zS, xE, 2.0f, zE, -1, EnumSet.of(facing), sprite, faceQuads, generalQuads, 0.0f);
        ModelCuboidUtil.addFlippedCuboidWithYOffset(xS, 1.0f, zS, xE, 2.0f, zE, -1, EnumSet.of(facing.func_176734_d()), sprite, faceQuads, generalQuads, 0.0f);
    }

    private float calculatePosition(int offset) {
        return (float)Math.abs(offset) * (0.5f + (float)offset * 0.25f);
    }

    private IBakedModel createStickModel(boolean crosscrop) {
        List[] faceQuads = new List[EnumFacing.field_176754_o.length];
        for (int i = 0; i < faceQuads.length; ++i) {
            faceQuads[i] = new ArrayList();
        }
        ArrayList<BakedQuad> generalQuads = new ArrayList<BakedQuad>();
        TextureAtlasSprite stickSprite = crosscrop ? ((CropTextures)textures.get(1)).getSprite() : ((CropTextures)textures.get(0)).getSprite();
        this.addCroppedQuads(faceQuads, generalQuads, stickSprite, 0);
        return new BakedBlockModel(this.optimizeFaceQuads(faceQuads), generalQuads.isEmpty() ? Collections.emptyList() : generalQuads, stickSprite);
    }

    private List<BakedQuad>[] optimizeFaceQuads(List<BakedQuad>[] faceQuads) {
        int used = (int)Arrays.stream(faceQuads).filter(list -> !list.isEmpty()).count();
        return used == 0 ? null : faceQuads;
    }

    private ResourceLocation getTextureLocation(ICrop crop) {
        return crop.getTexture(crop.getStage());
    }

    private ResourceLocation getTopTextureLocation(ICrop crop) {
        return crop.getTextureTop(crop.getStage());
    }

    private ResourceLocation getTextureTopLocation(ICrop crop) {
        return crop.getTextureTop(crop.getStage());
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return ((CropTextures)textures.get(0)).getSprite();
    }

    @Override
    public void onReload() {
        this.modelCache.invalidateAll();
    }
}

