/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.fluidintegrator;

import com.denfop.blocks.FluidName;
import com.denfop.render.tank.DataFluid;
import com.denfop.tiles.mechanism.TileEntityPrimalFluidIntegrator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TileEntityRenderFluidIntegrator
extends TileEntitySpecialRenderer<TileEntityPrimalFluidIntegrator> {
    float rotation;
    float prevRotation;

    public void render(TileEntityPrimalFluidIntegrator tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBakedModel ibakedmodel;
        this.renderTanks(tile, x, y, z);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        ItemStack itemstack = tile.inputSlotA.get();
        if (!itemstack.func_190926_b()) {
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179091_B();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            RenderHelper.func_74519_b();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            float scale = (float)tile.fluidTank1.getFluidAmount() * 1.0f / (float)tile.fluidTank1.getCapacity();
            scale = Math.min(1.0f, scale);
            switch (tile.facing) {
                case 3: {
                    GlStateManager.func_179137_b((double)0.2, (double)(0.3 + 0.6 * (double)scale), (double)0.5);
                    break;
                }
                case 2: {
                    GlStateManager.func_179137_b((double)0.75, (double)(0.3 + 0.6 * (double)scale), (double)0.5);
                    break;
                }
                case 4: {
                    GlStateManager.func_179137_b((double)0.5, (double)(0.3 + 0.6 * (double)scale), (double)0.2);
                    break;
                }
                case 5: {
                    GlStateManager.func_179137_b((double)0.5, (double)(0.3 + 0.6 * (double)scale), (double)0.75);
                }
            }
            if ((double)scale > 0.1) {
                GL11.glRotatef((float)this.rotation, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
            ibakedmodel = Minecraft.func_71410_x().func_175599_af().func_184393_a(itemstack, tile.func_145831_w(), null);
            IBakedModel transformedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(itemstack, transformedModel);
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
        GlStateManager.func_179121_F();
        if (this.field_147501_a.field_190057_j != null && (tile.func_174877_v().equals((Object)this.field_147501_a.field_190057_j.func_178782_a()) || tile.func_174877_v().func_177984_a().equals((Object)this.field_147501_a.field_190057_j.func_178782_a()))) {
            this.func_190053_a(true);
            String text3 = String.format("%d", (int)(tile.getProgress() * 100.0)) + "%";
            TextComponentString itextcomponent2 = new TextComponentString(text3);
            this.func_190052_a(tile, itextcomponent2.func_150254_d(), x, y + 0.25, z, 12);
            this.func_190053_a(false);
        }
        GlStateManager.func_179094_E();
        ItemStack itemstack1 = tile.outputSlot.get();
        if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() > 0) {
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179091_B();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            RenderHelper.func_74519_b();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            switch (tile.facing) {
                case 3: {
                    GlStateManager.func_179137_b((double)1.0, (double)0.87, (double)0.5);
                    break;
                }
                case 2: {
                    GlStateManager.func_179137_b((double)0.0, (double)0.87, (double)0.5);
                    break;
                }
                case 4: {
                    GlStateManager.func_179137_b((double)0.5, (double)0.87, (double)0.9);
                    break;
                }
                case 5: {
                    GlStateManager.func_179137_b((double)0.5, (double)0.87, (double)-0.1);
                }
            }
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            ibakedmodel = Minecraft.func_71410_x().func_175599_af().func_184393_a(itemstack1, tile.func_145831_w(), null);
            IBakedModel transformedModel1 = ForgeHooksClient.handleCameraTransforms((IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
            for (int i = 0; i < 1; ++i) {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.0075);
                Minecraft.func_71410_x().func_175599_af().func_180454_a(itemstack1, transformedModel1);
            }
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
        GlStateManager.func_179121_F();
        this.prevRotation = this.rotation = this.prevRotation + (this.rotation - this.prevRotation) * partialTicks;
        this.rotation = (float)((double)this.rotation + 0.25);
    }

    private void renderTanks(TileEntityPrimalFluidIntegrator tile, double x, double y, double z) {
        IBakedModel model;
        IBlockState state;
        FluidStack fluidStack;
        BlockRendererDispatcher blockRenderer;
        float scale;
        float dopY;
        if (tile.fluidTank1.getFluid() != null && tile.fluidTank1.getFluid().getFluid() != null & tile.fluidTank1.getFluid().getFluid().getBlock() != null) {
            GL11.glPushMatrix();
            dopY = 0.0f;
            if (tile.fluidTank1.getFluid().getFluid().isGaseous()) {
                dopY = 0.88f - (float)tile.fluidTank1.getFluidAmount() * 1.0f / (float)tile.fluidTank1.getCapacity();
            }
            switch (tile.facing) {
                case 2: {
                    GL11.glTranslated((double)(x + 0.44), (double)(y + 0.3 + (double)dopY), (double)(z + 0.19));
                    break;
                }
                case 3: {
                    GL11.glTranslated((double)(x - 0.059), (double)(y + 0.3 + (double)dopY), (double)(z + 0.19));
                    break;
                }
                case 4: {
                    GL11.glTranslated((double)(x + 0.19), (double)(y + 0.3 + (double)dopY), (double)(z - 0.059));
                    break;
                }
                case 5: {
                    GL11.glTranslated((double)(x + 0.19), (double)(y + 0.3 + (double)dopY), (double)(z + 0.44));
                }
            }
            scale = (float)tile.fluidTank1.getFluidAmount() * 1.0f / (float)tile.fluidTank1.getCapacity();
            GlStateManager.func_179145_e();
            GlStateManager.func_179142_g();
            GlStateManager.func_179091_B();
            GlStateManager.func_179139_a((double)0.62, (double)(0.75 * (double)scale), (double)0.62);
            this.func_147499_a(TextureMap.field_110575_b);
            blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            fluidStack = tile.fluidTank1.getFluid();
            if (tile.dataFluid == null) {
                tile.dataFluid = new DataFluid(fluidStack.getFluid());
            }
            state = fluidStack.getFluid().getBlock().func_176223_P();
            if (FluidRegistry.LAVA == fluidStack.getFluid()) {
                state = FluidName.fluidlava.getInstance().getBlock().func_176223_P();
            }
            if (FluidRegistry.WATER == fluidStack.getFluid()) {
                state = FluidName.fluidwater.getInstance().getBlock().func_176223_P();
            }
            if (tile.dataFluid.getState() == null) {
                model = blockRenderer.func_184389_a(state);
                tile.dataFluid.setState(model);
            } else if (tile.dataFluid.getFluid() != fluidStack.getFluid()) {
                tile.dataFluid.setFluid(fluidStack.getFluid());
                model = blockRenderer.func_184389_a(state);
                tile.dataFluid.setState(model);
            } else {
                model = tile.dataFluid.getState();
            }
            GL11.glColor4f((float)((float)(fluidStack.getFluid().getColor(fluidStack) >> 16 & 0xFF) / 255.0f), (float)((float)(fluidStack.getFluid().getColor(fluidStack) >> 8 & 0xFF) / 255.0f), (float)((float)(fluidStack.getFluid().getColor(fluidStack) & 0xFF) / 255.0f), (float)1.0f);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.render(fluidStack, model, state, enumfacing);
            }
            this.render(fluidStack, model, state, null);
            GlStateManager.func_179140_f();
            GlStateManager.func_179119_h();
            GL11.glPopMatrix();
        }
        if (tile.fluidTank2.getFluid() != null && tile.fluidTank2.getFluid().getFluid() != null & tile.fluidTank2.getFluid().getFluid().getBlock() != null) {
            GL11.glPushMatrix();
            dopY = 0.0f;
            if (tile.fluidTank2.getFluid().getFluid().isGaseous()) {
                dopY = 0.7f - (float)tile.fluidTank2.getFluidAmount() * 0.7f / (float)tile.fluidTank2.getCapacity();
            }
            switch (tile.facing) {
                case 2: {
                    GL11.glTranslated((double)(x - 0.24), (double)(y + 0.15 + (double)dopY), (double)(z + 0.26));
                    break;
                }
                case 3: {
                    GL11.glTranslated((double)(x + 0.76), (double)(y + 0.15 + (double)dopY), (double)(z + 0.26));
                    break;
                }
                case 4: {
                    GL11.glTranslated((double)(x + 0.26), (double)(y + 0.15 + (double)dopY), (double)(z + 0.76));
                    break;
                }
                case 5: {
                    GL11.glTranslated((double)(x + 0.26), (double)(y + 0.15 + (double)dopY), (double)(z - 0.24));
                }
            }
            scale = (float)tile.fluidTank2.getFluidAmount() * 1.0f / (float)tile.fluidTank2.getCapacity();
            GlStateManager.func_179145_e();
            GlStateManager.func_179142_g();
            GlStateManager.func_179091_B();
            GlStateManager.func_179139_a((double)0.48, (double)(0.7 * (double)scale), (double)0.48);
            this.func_147499_a(TextureMap.field_110575_b);
            blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            fluidStack = tile.fluidTank2.getFluid();
            if (tile.dataFluid1 == null) {
                tile.dataFluid1 = new DataFluid(fluidStack.getFluid());
            }
            state = fluidStack.getFluid().getBlock().func_176223_P();
            if (FluidRegistry.LAVA == fluidStack.getFluid()) {
                state = FluidName.fluidlava.getInstance().getBlock().func_176223_P();
            }
            if (FluidRegistry.WATER == fluidStack.getFluid()) {
                state = FluidName.fluidwater.getInstance().getBlock().func_176223_P();
            }
            if (tile.dataFluid1.getState() == null) {
                model = blockRenderer.func_184389_a(state);
                tile.dataFluid1.setState(model);
            } else if (tile.dataFluid1.getFluid() != fluidStack.getFluid()) {
                tile.dataFluid1.setFluid(fluidStack.getFluid());
                model = blockRenderer.func_184389_a(state);
                tile.dataFluid1.setState(model);
            } else {
                model = tile.dataFluid1.getState();
            }
            GL11.glColor4f((float)((float)(fluidStack.getFluid().getColor(fluidStack) >> 16 & 0xFF) / 255.0f), (float)((float)(fluidStack.getFluid().getColor(fluidStack) >> 8 & 0xFF) / 255.0f), (float)((float)(fluidStack.getFluid().getColor(fluidStack) & 0xFF) / 255.0f), (float)1.0f);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.render(fluidStack, model, state, enumfacing);
            }
            this.render(fluidStack, model, state, null);
            GlStateManager.func_179140_f();
            GlStateManager.func_179119_h();
            GL11.glPopMatrix();
        }
    }

    public void render(FluidStack fluidStack, IBakedModel model, IBlockState state, EnumFacing enumfacing) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        List listQuads = model.func_188616_a(state, enumfacing, 0L);
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = (BakedQuad)listQuads.get(i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            bufferbuilder.func_178981_a(bakedquad.func_178209_a());
            bufferbuilder.func_178990_f((float)(fluidStack.getFluid().getColor(fluidStack) >> 16 & 0xFF) / 255.0f, (float)(fluidStack.getFluid().getColor(fluidStack) >> 8 & 0xFF) / 255.0f, (float)(fluidStack.getFluid().getColor(fluidStack) & 0xFF) / 255.0f);
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            bufferbuilder.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }
}

