/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.oilquarry;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.vein.Type;
import com.denfop.blocks.BlockHeavyOre;
import com.denfop.blocks.BlockMineral;
import com.denfop.blocks.FluidName;
import com.denfop.render.oilquarry.DataBlock;
import com.denfop.tiles.base.TileQuarryVein;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentString;
import org.lwjgl.opengl.GL11;

public class TileEntityQuarryOilRender
extends TileEntitySpecialRenderer<TileQuarryVein> {
    float rotation;
    float prevRotation;

    public static void render(IBakedModel model, IBlockState state, EnumFacing enumfacing) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        List listQuads = model.func_188616_a(state, enumfacing, 0L);
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = (BakedQuad)listQuads.get(i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            bufferbuilder.func_178981_a(bakedquad.func_178209_a());
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            bufferbuilder.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public void render(TileQuarryVein tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile.vein != null && tile.vein.get() && tile.vein.getType() != Type.EMPTY) {
            IBakedModel model;
            IBlockState state;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glTranslatef((float)0.4f, (float)1.2f, (float)0.4f);
            GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
            GL11.glRotatef((float)this.rotation, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_147499_a(TextureMap.field_110575_b);
            if (tile.dataBlock == null) {
                state = tile.vein.getType() == Type.VEIN ? (tile.vein.isOldMineral() ? IUItem.heavyore.func_176223_P().func_177226_a(BlockHeavyOre.VARIANT, (Comparable)((Object)BlockHeavyOre.Type.getFromID(tile.vein.getMeta()))) : IUItem.mineral.func_176223_P().func_177226_a(BlockMineral.VARIANT, (Comparable)((Object)BlockMineral.Type.getFromID(tile.vein.getMeta())))) : (tile.vein.getType() == Type.OIL ? IUItem.oilblock.func_176223_P() : IUItem.gasBlock.func_176223_P());
                tile.dataBlock = new DataBlock(state);
                model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
                tile.dataBlock.setState(model);
            } else {
                state = tile.blockState;
            }
            model = tile.dataBlock.getState();
            for (EnumFacing enumfacing : EnumFacing.values()) {
                TileEntityQuarryOilRender.render(model, state, enumfacing);
            }
            TileEntityQuarryOilRender.render(model, state, null);
            GL11.glPopMatrix();
            this.prevRotation = this.rotation = this.prevRotation + (this.rotation - this.prevRotation) * partialTicks;
            this.rotation = (float)((double)this.rotation + 0.25);
        }
        if (tile.vein != null && tile.vein.get()) {
            ItemStack stack = null;
            if (tile.vein.getType() == Type.VEIN) {
                stack = tile.vein.isOldMineral() ? new ItemStack((Block)IUItem.heavyore, 1, tile.vein.getMeta()) : new ItemStack((Block)IUItem.mineral, 1, tile.vein.getMeta());
            } else if (tile.vein.getType() == Type.OIL) {
                stack = new ItemStack(IUItem.oilblock);
            } else if (tile.vein.getType() == Type.GAS) {
                stack = new ItemStack(FluidName.fluidgas.getInstance().getBlock());
            }
            if (stack != null) {
                String typeString;
                String varietyString;
                int col = tile.vein.getCol();
                boolean isOil = tile.vein.getType() == Type.OIL || tile.vein.getType() == Type.GAS;
                int colmax = tile.vein.getMaxCol();
                int variety = tile.vein.getMeta() / 3;
                int type = tile.vein.getMeta() % 3;
                String string = varietyString = variety == 0 ? "iu.sweet_oil" : "iu.sour_oil";
                String string2 = type == 0 ? "iu.light_oil" : (typeString = type == 1 ? "iu.medium_oil" : "iu.heavy_oil");
                TextComponentString itextcomponent = isOil ? (tile.vein.getType() != Type.GAS ? new TextComponentString(Localization.translate(varietyString) + " " + Localization.translate(typeString) + stack.func_82833_r()) : new TextComponentString(stack.func_82833_r())) : new TextComponentString(stack.func_82833_r());
                TextComponentString itextcomponent1 = new TextComponentString(col + (isOil ? "mb" : "") + "/" + colmax + (isOil ? "mb" : ""));
                if (this.field_147501_a.field_190057_j != null && tile.func_174877_v().equals((Object)this.field_147501_a.field_190057_j.func_178782_a())) {
                    this.func_190053_a(true);
                    this.func_190052_a(tile, itextcomponent.func_150254_d(), x, y + 0.5, z, 12);
                    this.func_190052_a(tile, itextcomponent1.func_150254_d(), x, y + 0.25, z, 12);
                    this.func_190053_a(false);
                }
            }
        }
    }
}

