/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.steam;

import com.denfop.blocks.FluidName;
import com.denfop.render.tank.DataFluid;
import com.denfop.tiles.mechanism.steam.TileSteamStorage;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TileEntityRenderSteamStorage
extends TileEntitySpecialRenderer<TileSteamStorage> {
    public void render(TileSteamStorage tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        this.renderTanks(tile, x, y, z);
        GlStateManager.func_179121_F();
    }

    private void renderTanks(TileSteamStorage tile, double x, double y, double z) {
        if (tile.fluidTank.getFluid() != null && tile.fluidTank.getFluid().getFluid() != null & tile.fluidTank.getFluid().getFluid().getBlock() != null) {
            IBakedModel model;
            GL11.glPushMatrix();
            float dopY = 0.0f;
            if (tile.fluidTank.getFluid().getFluid().isGaseous()) {
                dopY = 1.0f - (float)tile.fluidTank.getFluidAmount() * 1.0f / (float)tile.fluidTank.getCapacity();
            }
            GL11.glTranslated((double)(x + 0.04), (double)(y + (double)dopY), (double)(z + 0.04));
            float scale = (float)tile.fluidTank.getFluidAmount() * 1.0f / (float)tile.fluidTank.getCapacity();
            GlStateManager.func_179145_e();
            GlStateManager.func_179142_g();
            GlStateManager.func_179091_B();
            GlStateManager.func_179139_a((double)0.95, (double)(0.95 * (double)scale), (double)0.95);
            this.func_147499_a(TextureMap.field_110575_b);
            BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            FluidStack fluidStack = tile.fluidTank.getFluid();
            if (tile.dataFluid == null) {
                tile.dataFluid = new DataFluid(fluidStack.getFluid());
            }
            IBlockState state = fluidStack.getFluid().getBlock().func_176223_P();
            if (FluidRegistry.LAVA == fluidStack.getFluid()) {
                state = FluidName.fluidlava.getInstance().getBlock().func_176223_P();
            }
            if (FluidRegistry.WATER == fluidStack.getFluid()) {
                state = FluidName.fluidwater.getInstance().getBlock().func_176223_P();
            }
            if (tile.dataFluid.getState() == null) {
                model = blockRenderer.func_184389_a(state);
                tile.dataFluid.setState(model);
            } else if (tile.dataFluid.getFluid() != fluidStack.getFluid()) {
                tile.dataFluid.setFluid(fluidStack.getFluid());
                model = blockRenderer.func_184389_a(state);
                tile.dataFluid.setState(model);
            } else {
                model = tile.dataFluid.getState();
            }
            GL11.glColor4f((float)((float)(fluidStack.getFluid().getColor(fluidStack) >> 16 & 0xFF) / 255.0f), (float)((float)(fluidStack.getFluid().getColor(fluidStack) >> 8 & 0xFF) / 255.0f), (float)((float)(fluidStack.getFluid().getColor(fluidStack) & 0xFF) / 255.0f), (float)1.0f);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.render(fluidStack, model, state, enumfacing);
            }
            this.render(fluidStack, model, state, null);
            GlStateManager.func_179140_f();
            GlStateManager.func_179119_h();
            GL11.glPopMatrix();
        }
    }

    public void render(FluidStack fluidStack, IBakedModel model, IBlockState state, EnumFacing enumfacing) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        List listQuads = model.func_188616_a(state, enumfacing, 0L);
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = (BakedQuad)listQuads.get(i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            bufferbuilder.func_178981_a(bakedquad.func_178209_a());
            bufferbuilder.func_178990_f((float)(fluidStack.getFluid().getColor(fluidStack) >> 16 & 0xFF) / 255.0f, (float)(fluidStack.getFluid().getColor(fluidStack) >> 8 & 0xFF) / 255.0f, (float)(fluidStack.getFluid().getColor(fluidStack) & 0xFF) / 255.0f);
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            bufferbuilder.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }
}

