/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.streak;

import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.render.streak.RGB;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerStreakInfo {
    private boolean render;
    private boolean renderPlayer;
    private RGB rgb;
    private boolean rainbow;

    public PlayerStreakInfo(RGB rgb, boolean rainbow, boolean render, boolean renderPlayer) {
        this.rgb = rgb;
        this.rainbow = rainbow;
        this.render = render;
        this.renderPlayer = renderPlayer;
    }

    public PlayerStreakInfo(NBTTagCompound nbtTagCompound) {
        this.rgb = new RGB(nbtTagCompound.func_74765_d("red"), nbtTagCompound.func_74765_d("green"), nbtTagCompound.func_74765_d("blue"));
        this.rainbow = nbtTagCompound.func_74767_n("rainbow");
        this.render = nbtTagCompound.func_74767_n("render");
        this.renderPlayer = nbtTagCompound.func_74767_n("renderPlayer");
    }

    public PlayerStreakInfo(CustomPacketBuffer customPacketBuffer) {
        this.rgb = new RGB((short)(customPacketBuffer.readByte() + 128), (short)(customPacketBuffer.readByte() + 128), (short)(customPacketBuffer.readByte() + 128));
        this.rainbow = customPacketBuffer.readBoolean();
        this.render = customPacketBuffer.readBoolean();
        this.renderPlayer = customPacketBuffer.readBoolean();
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("red", this.rgb.getRed());
        nbt.func_74777_a("blue", this.rgb.getBlue());
        nbt.func_74777_a("green", this.rgb.getGreen());
        nbt.func_74757_a("rainbow", this.rainbow);
        nbt.func_74757_a("render", this.render);
        nbt.func_74757_a("renderPlayer", this.render);
        return nbt;
    }

    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeByte(this.rgb.getRed() - 128);
        packetBuffer.writeByte(this.rgb.getBlue() - 128);
        packetBuffer.writeByte(this.rgb.getGreen() - 128);
        packetBuffer.writeBoolean(this.rainbow);
        packetBuffer.writeBoolean(this.render);
        packetBuffer.writeBoolean(this.renderPlayer);
        return packetBuffer;
    }

    public boolean isRainbow() {
        return this.rainbow;
    }

    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    public RGB getRgb() {
        return this.rgb;
    }

    public void setRgb(RGB rgb) {
        this.rgb = rgb;
    }

    public boolean isRender() {
        return this.render;
    }

    public void setRender(boolean render) {
        this.render = render;
    }

    public boolean isRenderPlayer() {
        return this.renderPlayer;
    }

    public void setRenderPlayer(boolean renderPlayer) {
        this.renderPlayer = renderPlayer;
    }
}

