/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.transport;

import com.denfop.blocks.state.TileEntityBlockStateContainer;
import com.denfop.render.base.AbstractModel;
import com.denfop.render.base.BakedBlockModel;
import com.denfop.render.base.ISpecialParticleModel;
import com.denfop.render.base.ModelCuboidUtil;
import com.denfop.tiles.transport.tiles.RenderState;
import com.denfop.tiles.transport.tiles.TileEntityCable;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.tiles.transport.types.ICableItem;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelCable
extends AbstractModel
implements ISpecialParticleModel {
    private final Map<ResourceLocation, TextureAtlasSprite> textures;
    private final LoadingCache<RenderState, IBakedModel> modelCache;
    private final ICableItem[] values;

    public ModelCable(ICableItem[] values) {
        this.values = values;
        this.textures = this.generateTextureLocations();
        this.modelCache = CacheBuilder.newBuilder().maximumSize(256L).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<RenderState, IBakedModel>(){

            public IBakedModel load(@Nonnull RenderState key) {
                return ModelCable.this.generateModel(key);
            }
        });
    }

    private Map<ResourceLocation, TextureAtlasSprite> generateTextureLocations() {
        HashMap<ResourceLocation, TextureAtlasSprite> ret = new HashMap<ResourceLocation, TextureAtlasSprite>();
        for (ICableItem item : this.values) {
            ret.put(item.getRecourse(), null);
        }
        return ret;
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return this.textures.keySet();
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        for (Map.Entry<ResourceLocation, TextureAtlasSprite> locationTextureAtlasSpriteEntry : this.textures.entrySet()) {
            locationTextureAtlasSpriteEntry.setValue(bakedTextureGetter.apply(locationTextureAtlasSpriteEntry.getKey()));
        }
        return this;
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState rawState, EnumFacing side, long rand) {
        if (!(rawState instanceof TileEntityBlockStateContainer.PropertiesStateInstance)) {
            return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a().func_188616_a(rawState, side, rand);
        }
        TileEntityBlockStateContainer.PropertiesStateInstance state = (TileEntityBlockStateContainer.PropertiesStateInstance)rawState;
        if (!state.hasValue(TileEntityCable.renderStateProperty)) {
            return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a().func_188616_a((IBlockState)state, side, rand);
        }
        RenderState prop = (RenderState)state.getValue(TileEntityCable.renderStateProperty);
        try {
            return ((IBakedModel)this.modelCache.get((Object)prop)).func_188616_a((IBlockState)state, side, rand);
        }
        catch (ExecutionException var8) {
            throw new RuntimeException(var8);
        }
    }

    private IBakedModel generateModel(RenderState prop) {
        int used;
        float th = prop.getType().getThickness();
        List[] faceQuads = new List[EnumFacing.field_82609_l.length];
        for (int i = 0; i < faceQuads.length; ++i) {
            faceQuads[i] = new ArrayList();
        }
        ArrayList<BakedQuad> generalQuads = new ArrayList();
        TextureAtlasSprite sprite = this.textures.get(new ResourceLocation(prop.resourceLocation.toString().replace(".png", "")));
        EnumFacing[] var7 = EnumFacing.field_82609_l;
        int i = var7.length;
        block17: for (used = 0; used < i; ++used) {
            float zE;
            float sp;
            float zS;
            EnumFacing facing = var7[used];
            boolean hasConnection = (prop.connectivity & 1 << var7.length - 1 - facing.ordinal()) != 0;
            float xS = zS = (sp = (1.0f - th) / 2.0f);
            float yS = zS;
            float xE = zE = sp + th;
            float yE = zE;
            if (hasConnection) {
                sp = (1.0f - th) / 2.0f;
                switch (facing) {
                    case DOWN: {
                        yS = 0.0f;
                        yE = sp;
                        break;
                    }
                    case UP: {
                        yS = sp + th;
                        yE = 1.0f;
                        break;
                    }
                    case NORTH: {
                        zS = 0.0f;
                        zE = sp;
                        break;
                    }
                    case SOUTH: {
                        zS = sp + th;
                        zE = 1.0f;
                        break;
                    }
                    case WEST: {
                        xS = 0.0f;
                        xE = sp;
                        break;
                    }
                    case EAST: {
                        xS = sp + th;
                        xE = 1.0f;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                ModelCuboidUtil.addCuboid(xS, yS, zS, xE, yE, zE, EnumSet.complementOf(EnumSet.of(facing.func_176734_d())), sprite, faceQuads, generalQuads);
                sp = (1.0f - th) / 2.0f;
                xE = zE = sp + th;
                yE = zE;
                if (!(th > 0.25f)) continue;
                switch (facing) {
                    case DOWN: {
                        ModelCuboidUtil.addCuboid(sp, sp - 0.31f, sp, xE, yE, zE, EnumSet.of(facing), sprite, faceQuads, generalQuads);
                        continue block17;
                    }
                    case UP: {
                        ModelCuboidUtil.addCuboid(sp, sp, sp, xE, yE + 0.31f, zE, EnumSet.of(facing), sprite, faceQuads, generalQuads);
                        continue block17;
                    }
                    case NORTH: {
                        ModelCuboidUtil.addCuboid(sp, sp, sp - 0.31f, xE, yE, zE, EnumSet.of(facing), sprite, faceQuads, generalQuads);
                        continue block17;
                    }
                    case SOUTH: {
                        ModelCuboidUtil.addCuboid(sp, sp, sp, xE, yE, zE + 0.31f, EnumSet.of(facing), sprite, faceQuads, generalQuads);
                        continue block17;
                    }
                    case WEST: {
                        ModelCuboidUtil.addCuboid(sp - 0.31f, sp, sp, xE, yE, zE, EnumSet.of(facing), sprite, faceQuads, generalQuads);
                        continue block17;
                    }
                    case EAST: {
                        ModelCuboidUtil.addCuboid(sp, sp, sp, xE + 0.31f, yE, zE, EnumSet.of(facing), sprite, faceQuads, generalQuads);
                        continue block17;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            ModelCuboidUtil.addCuboid(sp, sp, sp, xE, yE, zE, EnumSet.of(facing), sprite, faceQuads, generalQuads);
        }
        used = 0;
        for (i = 0; i < faceQuads.length; ++i) {
            if (faceQuads[i].isEmpty()) {
                faceQuads[i] = Collections.emptyList();
                continue;
            }
            ++used;
        }
        if (used == 0) {
            faceQuads = null;
        }
        if (generalQuads.isEmpty()) {
            generalQuads = Collections.emptyList();
        }
        return new BakedBlockModel(faceQuads, generalQuads, sprite);
    }

    @Override
    public void onReload() {
        this.modelCache.invalidateAll();
    }

    @Override
    public boolean needsEnhancing(IBlockState state) {
        return true;
    }

    @Override
    public TextureAtlasSprite getParticleTexture(TileEntityBlockStateContainer.PropertiesStateInstance state) {
        if (!state.hasValue(TileEntityMultiCable.renderStateProperty)) {
            return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a().func_177554_e();
        }
        RenderState prop = state.getValue(TileEntityMultiCable.renderStateProperty);
        return this.textures.get(prop.resourceLocation);
    }
}

