/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.vein.Vein;
import com.denfop.api.vein.VeinSystem;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileAnalyzer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;

public class DataOre {
    private String name;
    private List<BlockPos> listPos;
    private List<Vein> veinsList;
    private ItemStack stack;
    private List<ItemStack> recipe_stack;
    private IBlockState iBlockState;
    private int number;
    private int y;

    public DataOre(String name, int number, int y, BlockPos pos, ItemStack stack, IBlockState state) {
        this.name = name;
        this.number = number;
        this.y = y;
        this.listPos = pos != null ? new ArrayList<BlockPos>(Collections.singleton(pos)) : new ArrayList<BlockPos>();
        this.stack = stack;
        this.veinsList = new ArrayList<Vein>();
        this.iBlockState = state == null ? Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77952_i()) : state;
    }

    public DataOre(NBTTagCompound tagCompound) {
        this.name = tagCompound.func_74779_i("name");
        this.number = tagCompound.func_74762_e("number");
        this.y = tagCompound.func_74762_e("y");
        int size = tagCompound.func_74762_e("size");
        this.listPos = new ArrayList<BlockPos>();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound posTag = tagCompound.func_74775_l("blockpos_" + i);
            this.listPos.add(new BlockPos(posTag.func_74762_e("x"), posTag.func_74762_e("y"), posTag.func_74762_e("z")));
        }
        NBTTagCompound stackTag = tagCompound.func_74775_l("stackTag");
        this.stack = new ItemStack(stackTag);
        this.iBlockState = Block.func_149634_a((Item)this.stack.func_77973_b()).func_176203_a(this.stack.func_77952_i());
        this.veinsList = new ArrayList<Vein>();
        int size1 = tagCompound.func_74762_e("size1");
        for (int i = 0; i < size1; ++i) {
            NBTTagCompound veinTag = tagCompound.func_74775_l("vein_" + i);
            ChunkPos chunkPos = new ChunkPos(veinTag.func_74762_e("x"), veinTag.func_74762_e("z"));
            Vein vein = VeinSystem.system.getVein(chunkPos);
            if (vein == VeinSystem.EMPTY) continue;
            this.veinsList.add(vein);
        }
    }

    public DataOre(CustomPacketBuffer customPacketBuffer) {
        this.name = customPacketBuffer.readString();
        this.number = customPacketBuffer.readInt();
        this.y = customPacketBuffer.readInt();
        try {
            this.listPos = (List)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.iBlockState = ((Block)DecoderHandler.decode(customPacketBuffer)).func_176203_a(this.stack.func_77952_i());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.veinsList = (List)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ItemStack> getRecipe_stack(TileAnalyzer tileAnalyzer, BlockPos pos) {
        if (this.recipe_stack != null) {
            return this.recipe_stack;
        }
        List drops = this.iBlockState.func_177230_c().getDrops((IBlockAccess)tileAnalyzer.func_145831_w(), pos, this.iBlockState, tileAnalyzer.lucky);
        ArrayList<Object> list = new ArrayList<Object>();
        if (tileAnalyzer.macerator || tileAnalyzer.comb_macerator) {
            ItemStack output;
            BaseMachineRecipe rec;
            if (tileAnalyzer.macerator) {
                for (Object stack1 : drops) {
                    rec = Recipes.recipes.getRecipeOutput("macerator", false, new ItemStack[]{stack1});
                    if (rec != null) {
                        output = rec.output.items.get(0).func_77946_l();
                        output.func_190920_e(stack1.func_190916_E() * output.func_190916_E());
                        list.add(output);
                        continue;
                    }
                    list.add(stack1);
                }
            } else {
                for (Object stack1 : drops) {
                    rec = Recipes.recipes.getRecipeOutput("comb_macerator", false, new ItemStack[]{stack1});
                    if (rec != null) {
                        output = rec.output.items.get(0).func_77946_l();
                        output.func_190920_e(stack1.func_190916_E() * output.func_190916_E());
                        list.add(output);
                        continue;
                    }
                    list.add(stack1);
                }
            }
        }
        if (!list.isEmpty()) {
            drops.clear();
            drops.addAll(list);
            list.clear();
        }
        if (tileAnalyzer.polisher) {
            List<BaseMachineRecipe> recipes = Recipes.recipes.getRecipeList("laser");
            for (ItemStack stack : drops) {
                BaseMachineRecipe recipe = Recipes.recipes.getRecipeOutput("laser", false, stack);
                if (recipe != null) {
                    list.add(recipe.getOutput().items.get(0).func_77946_l());
                    continue;
                }
                boolean can = true;
                for (BaseMachineRecipe recipe1 : recipes) {
                    if (!recipe1.getOutput().items.get(0).func_77969_a(stack)) continue;
                    ItemStack stack1 = stack.func_77946_l();
                    stack1.func_190920_e(recipe1.getOutput().items.get(0).func_190916_E());
                    list.add(stack1);
                    can = false;
                    break;
                }
                if (can) continue;
                list.add(stack);
            }
        }
        if (tileAnalyzer.furnace) {
            for (Object stack1 : drops) {
                ItemStack smelt = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)stack1).func_77946_l();
                if (!smelt.func_190926_b()) {
                    smelt.func_190920_e(stack1.func_190916_E() * smelt.func_190916_E());
                    list.add(smelt);
                    continue;
                }
                list.add(stack1);
            }
        }
        if (!list.isEmpty()) {
            drops.clear();
            drops.addAll(list);
            list.clear();
        }
        this.recipe_stack = drops;
        return this.recipe_stack;
    }

    public NBTTagCompound getTagCompound() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("name", this.name);
        tagCompound.func_74768_a("number", this.number);
        tagCompound.func_74768_a("y", this.y);
        tagCompound.func_74768_a("size", this.listPos.size());
        for (int i = 0; i < this.listPos.size(); ++i) {
            NBTTagCompound posTag = new NBTTagCompound();
            BlockPos pos = this.listPos.get(i);
            posTag.func_74768_a("x", pos.func_177958_n());
            posTag.func_74768_a("y", pos.func_177956_o());
            posTag.func_74768_a("z", pos.func_177952_p());
            tagCompound.func_74782_a("blockpos_" + i, (NBTBase)posTag);
        }
        NBTTagCompound stackTag = new NBTTagCompound();
        this.stack.func_77955_b(stackTag);
        tagCompound.func_74782_a("stackTag", (NBTBase)stackTag);
        tagCompound.func_74768_a("size1", this.veinsList.size());
        for (int i = 0; i < this.veinsList.size(); ++i) {
            NBTTagCompound VeinTag = new NBTTagCompound();
            Vein vein = this.veinsList.get(i);
            VeinTag.func_74768_a("x", vein.getChunk().field_77276_a);
            VeinTag.func_74768_a("z", vein.getChunk().field_77275_b);
            tagCompound.func_74782_a("vein_" + i, (NBTBase)VeinTag);
        }
        return tagCompound;
    }

    public CustomPacketBuffer getCustomPacket() {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeString(this.name);
        customPacketBuffer.writeInt(this.number);
        customPacketBuffer.writeInt(this.y);
        try {
            EncoderHandler.encode(customPacketBuffer, this.listPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.iBlockState.func_177230_c());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.veinsList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    public IBlockState getiBlockState() {
        return this.iBlockState;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public List<BlockPos> getListPos() {
        return this.listPos;
    }

    public void addPos(BlockPos pos) {
        this.listPos.add(pos);
    }

    public void addVein(Vein vein) {
        this.veinsList.add(vein);
    }

    public void addY(int y) {
        this.y += y;
    }

    public List<Vein> getVeinsList() {
        return this.veinsList;
    }

    public void addNumber(int number) {
        this.number += number;
    }

    public int getAverage() {
        return this.y / this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataOre dataOre = (DataOre)o;
        return Objects.equals(this.name, dataOre.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public int getY() {
        return this.y;
    }

    public boolean contains(BlockPos pos1) {
        return this.listPos.contains(pos1);
    }
}

