/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.audio.EnumSound;
import com.denfop.componets.Action;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.TypeAction;
import com.denfop.componets.TypeLoad;
import com.denfop.componets.TypeUpgrade;
import com.denfop.container.ContainerBaseWitherMaker;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import org.lwjgl.input.Keyboard;

public abstract class TileBaseWitherMaker
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick {
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, 4);
    public final ComponentUpgradeSlots componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    private final ComponentUpgrade componentUpgrades;
    public MachineRecipe output = null;
    public InvSlotRecipes inputSlotA;
    private ItemStack WITHER_SKELETON_SKULL;
    private ItemStack SOUL_SAND;

    public TileBaseWitherMaker(int energyPerTick, int length, int outputSlots) {
        this(energyPerTick, length, outputSlots, 1);
    }

    public TileBaseWitherMaker(int energyPerTick, int length, int outputSlots, int aDefaultTier) {
        super(energyPerTick * length, 1, outputSlots);
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, (short)length));
        this.componentProcess = this.addComponent(new ComponentProcess(this, length, energyPerTick));
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setAction(new Action(this, 20, TypeAction.AUDIO, TypeLoad.PROGRESS, 3));
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.2));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.2));
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlotA.load();
        if (IUCore.proxy.isSimulating()) {
            this.output = this.getOutput();
            this.WITHER_SKELETON_SKULL = new ItemStack(Items.field_151144_bL, 1, 1);
            this.SOUL_SAND = new ItemStack(Blocks.field_150425_aM);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L && !this.inputSlotA.isEmpty()) {
            this.balanceSlots(this.inputSlotA.subList(0, 3), this.WITHER_SKELETON_SKULL);
            this.balanceSlots(this.inputSlotA.subList(3, 7), this.SOUL_SAND);
        }
    }

    public void balanceSlots(List<ItemStack> slots, ItemStack targetItem) {
        int total = 0;
        for (ItemStack stack : slots) {
            if (stack.func_190926_b() || !stack.func_77969_a(targetItem)) continue;
            total += stack.func_190916_E();
        }
        if (total == 0) {
            return;
        }
        int perSlot = total / slots.size();
        int remainder = total % slots.size();
        for (int i = 0; i < slots.size(); ++i) {
            if (perSlot > 0 || i < remainder) {
                int count = perSlot + (i < remainder ? 1 : 0);
                slots.set(i, new ItemStack(targetItem.func_77973_b(), count, targetItem.func_77952_i()));
                continue;
            }
            slots.set(i, ItemStack.field_190927_a);
        }
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    public ContainerBaseWitherMaker getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBaseWitherMaker(entityPlayer, this);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.WitherSpawn1.getSoundEvent();
    }
}

