/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockResource;
import com.denfop.componets.BioProcessMultiComponent;
import com.denfop.componets.ComponentBioFuelEnergy;
import com.denfop.componets.Fluids;
import com.denfop.componets.HeatComponent;
import com.denfop.container.ContainerBioMultiMachine;
import com.denfop.gui.GuiBioMultiMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.base.IBioMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.EnumTypeMachines;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class TileBioMultiMachine
extends TileEntityInventory
implements IAudioFixer,
IUpgradableBlock,
IUpdatableTileEvent,
IHasRecipe,
IBioMachine {
    public final int type;
    public final BioProcessMultiComponent multi_process;
    public final int sizeWorkingSlot;
    public final ComponentBioFuelEnergy bioFuel;
    public final Fluids.InternalFluidTank fluidTank;
    public HeatComponent heat;
    public Fluids.InternalFluidTank tank;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound;
    private Fluids fluid = null;

    public TileBioMultiMachine(int energyconsume, int OperationsPerTick, int type) {
        this(1, energyconsume, OperationsPerTick, type);
    }

    public TileBioMultiMachine(int aDefaultTier, int energyconsume, int OperationsPerTick, int type) {
        this.sizeWorkingSlot = this.getMachine().sizeWorkingSlot;
        this.bioFuel = this.addComponent(ComponentBioFuelEnergy.asBasicSink(this, 1000.0));
        this.fluid = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluid.addTank("tank", OperationsPerTick * energyconsume, InvSlot.TypeItemSlot.NONE);
        this.bioFuel.setFluidTank(this.fluidTank);
        if (this.getMachine().type == EnumTypeMachines.OreWashing) {
            this.tank = this.fluid.addTank("tank", 64000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate(FluidRegistry.WATER));
        }
        if (this.getMachine().type == EnumTypeMachines.Centrifuge) {
            this.heat = this.addComponent(HeatComponent.asBasicSink(this, 5000.0));
        }
        this.type = type;
        this.sound = true;
        this.multi_process = this.addComponent(new BioProcessMultiComponent(this, this.getMachine()));
    }

    @Override
    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    @Override
    public HeatComponent getHeat() {
        return this.heat;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.sound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void init() {
    }

    @Override
    public SoundEvent getSound() {
        return this.getMachine().type.getSound();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_length") + this.multi_process.operationLength);
        }
        tooltip.add(Localization.translate("bio_machine.info9"));
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (this.getSound() == null) {
            return;
        }
        if (this.getEnable()) {
            if (soundEvent == 0) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, EnumSound.biomass_progress.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (soundEvent == 1) {
                new PacketStopSound(this.func_145831_w(), this.field_174879_c);
                this.func_145831_w().func_184133_a(null, this.field_174879_c, EnumSound.biomass_interrupt.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            }
        }
    }

    public void onUpdate() {
    }

    public List<ItemStack> getDrop() {
        return this.getAuxDrops(0);
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    return drop;
                }
                case None: {
                    return null;
                }
                case Generator: {
                    return new ItemStack((Block)IUItem.basemachine2, 1, 78);
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: 
            }
            return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
        }
        return drop;
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        return super.getWrenchDrops(player, fortune);
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!entityPlayer.func_184586_b(hand).func_190926_b() && !this.func_145831_w().field_72995_K && FluidUtil.getFluidHandler((ItemStack)entityPlayer.func_184586_b(hand)) != null && this.fluid != null) {
            return ModUtils.interactWithFluidHandler(entityPlayer, hand, (IFluidHandler)this.fluid.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        return super.onActivated(entityPlayer, hand, side, hitX, hitY, hitZ);
    }

    public abstract EnumMultiMachine getMachine();

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.sound = nbttagcompound.func_74767_n("sound");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        if (event != 0.0) {
            this.sound = !this.sound;
            new PacketUpdateFieldTile(this, "sound", this.sound);
            if (!this.sound && this.getTypeAudio() == EnumTypeAudio.ON) {
                this.setType(EnumTypeAudio.OFF);
                new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "sound", this.sound);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public EnumTypeMachines getTypeMachine() {
        return this.getMachine().type;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    public ContainerBioMultiMachine getGuiContainer(EntityPlayer player) {
        return new ContainerBioMultiMachine(player, this, this.sizeWorkingSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiBioMultiMachine getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiBioMultiMachine(this.getGuiContainer(player));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    public int getMode() {
        return 0;
    }
}

