/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerCombinerMatter;
import com.denfop.gui.GuiCombinerMatter;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotMatter;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.IMatter;
import com.denfop.tiles.base.TileElectricLiquidTankInventory;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileMultiMatter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileCombinerMatter
extends TileElectricLiquidTankInventory
implements IUpgradableBlock,
IUpdateTick,
IMatter {
    public final InvSlotMatter inputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotRecipes amplifierSlot = new InvSlotRecipes((TileEntityInventory)this, "matterAmplifier", (IUpdateTick)this);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public final InvSlotFluid containerslot;
    protected final Redstone redstone;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public int scrap;
    public double energycost = 0.0;
    private double lastEnergy;
    private MachineRecipe recipe;
    private int amountScrap;

    public TileCombinerMatter() {
        super(0.0, 14, 12);
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.INPUT);
        this.containerslot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, FluidName.fluiduu_matter.getInstance());
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.inputSlot = new InvSlotMatter(this);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 0.0, 14).addManagedSlot(this.dischargeSlot));
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                TileCombinerMatter.this.energy.setEnabled(input == 0);
            }
        });
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.OUTPUT);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    private static int applyModifier(int base) {
        double ret = Math.round((double)(base + 14) * 1.0);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.scrap = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.scrap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.combiner_matter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    @Override
    public int func_70297_j_() {
        return 4;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.scrap = nbttagcompound.func_74762_e("scrap");
        this.lastEnergy = nbttagcompound.func_74769_h("lastEnergy");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("scrap", this.scrap);
        nbttagcompound.func_74780_a("lastEnergy", this.lastEnergy);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluidTank.getCapacity() <= 0) {
            this.fluidTank.drain(Integer.MAX_VALUE, true);
        }
        if (this.redstone.hasRedstoneInput() || this.energy.getEnergy() <= 0.0) {
            if (this.getActive()) {
                this.setActive(false);
            }
        } else {
            double bonus;
            if (this.scrap > 0 && (bonus = Math.min((double)this.scrap, this.energy.getEnergy() - this.lastEnergy)) > 0.0) {
                this.energy.forceAddEnergy(5.0 * bonus);
                this.scrap = (int)((double)this.scrap - bonus);
            }
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.scrap < 10000 && this.amountScrap > 0) {
                this.recipe = this.getRecipeOutput();
                if (this.recipe != null) {
                    this.amplifierSlot.consume();
                    this.scrap += this.amountScrap;
                    if (this.amplifierSlot.isEmpty()) {
                        this.getOutput();
                    }
                }
            }
            if (this.energy.canUseEnergy(this.energycost)) {
                this.attemptGeneration();
            }
            this.lastEnergy = this.energy.getEnergy();
            MutableObject output = new MutableObject();
            if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
            if (this.upgradeSlot.tickNoMark()) {
                this.setUpgradestat();
            }
        }
    }

    private void getOutput() {
        this.recipe = this.amplifierSlot.process();
        this.setRecipeOutput(this.recipe);
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.func_145831_w().field_72995_K) {
            Map<ChunkPos, List<IMatter>> chunkPosListMap = TileMultiMatter.worldMatterMap.get(this.field_145850_b.field_73011_w.getDimension());
            if (chunkPosListMap == null) {
                chunkPosListMap = new HashMap<ChunkPos, List<IMatter>>();
                ChunkPos chunkPos = new ChunkPos(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                LinkedList matters = new LinkedList();
                chunkPosListMap.put(chunkPos, matters);
                TileMultiMatter.worldMatterMap.put(this.field_145850_b.field_73011_w.getDimension(), chunkPosListMap);
            } else {
                ChunkPos chunkPos = new ChunkPos(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                List<IMatter> matters = chunkPosListMap.get(chunkPos);
                if (matters == null) {
                    matters = new LinkedList<IMatter>();
                    chunkPosListMap.put(chunkPos, matters);
                } else {
                    matters.remove(this);
                }
            }
        }
    }

    public void attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fillInternal(new FluidStack(FluidName.fluiduu_matter.getInstance(), Math.min(m, k)), true);
        this.energy.useEnergy(this.energycost * (double)Math.min(m, k));
    }

    public ContainerCombinerMatter getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCombinerMatter(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiCombinerMatter(new ContainerCombinerMatter(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    public float getWrenchDropRate() {
        return 0.7f;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setUpgradestat();
            this.inputSlot.update();
            this.amplifierSlot.load();
            this.getOutput();
            Map<ChunkPos, List<IMatter>> chunkPosListMap = TileMultiMatter.worldMatterMap.get(this.field_145850_b.field_73011_w.getDimension());
            if (chunkPosListMap == null) {
                chunkPosListMap = new HashMap<ChunkPos, List<IMatter>>();
                ChunkPos chunkPos = new ChunkPos(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                LinkedList<TileCombinerMatter> matters = new LinkedList<TileCombinerMatter>();
                matters.add(this);
                chunkPosListMap.put(chunkPos, matters);
                TileMultiMatter.worldMatterMap.put(this.field_145850_b.field_73011_w.getDimension(), chunkPosListMap);
            } else {
                ChunkPos chunkPos = new ChunkPos(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                List<IMatter> matters = chunkPosListMap.get(chunkPos);
                if (matters == null) {
                    matters = new LinkedList<IMatter>();
                    matters.add(this);
                    chunkPosListMap.put(chunkPos, matters);
                } else {
                    matters.add(this);
                }
            }
        }
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(TileCombinerMatter.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.canUseEnergy(amount)) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.recipe;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.recipe = output;
        this.amountScrap = this.recipe == null ? 0 : this.recipe.getRecipe().getOutput().metadata.func_74762_e("amount");
    }

    @Override
    public FluidTank getMatterTank() {
        return this.fluidTank;
    }
}

