/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IStorage;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.item.IEnergyItem;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.componets.Energy;
import com.denfop.componets.Redstone;
import com.denfop.componets.WirelessComponent;
import com.denfop.container.ContainerElectricBlock;
import com.denfop.gui.GuiElectricBlock;
import com.denfop.invslot.InvSlotCharge;
import com.denfop.invslot.InvSlotDischarge;
import com.denfop.invslot.InvSlotElectricBlock;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.proxy.CommonProxy;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.wiring.EnumElectricBlock;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileElectricBlock
extends TileEntityInventory
implements IUpdatableTileEvent,
IStorage {
    public final WirelessComponent wirelessComponent;
    public final double tier;
    public final boolean chargepad;
    public final String name;
    public final Energy energy;
    public final double maxStorage2;
    public final double l;
    public final InvSlotCharge inputslotA;
    public final InvSlotDischarge inputslotB;
    public final InvSlotElectricBlock inputslotC;
    private final Redstone redstone;
    public EnumElectricBlock electricblock;
    public double output;
    public boolean rfeu = false;
    public boolean needsInvUpdate = false;
    public boolean movementcharge = false;
    public double output_plus;
    public short temp;
    public boolean load = false;
    public boolean movementchargeitem = false;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    public boolean addedToEnergyNet = false;
    private byte redstoneMode = 0;
    private EntityPlayer player;

    public TileElectricBlock(double tier1, double output1, double maxStorage1, boolean chargepad, String name) {
        this.tier = tier1;
        this.output = EnergyNetGlobal.instance.getPowerFromTier((int)this.tier);
        this.maxStorage2 = maxStorage1 * 4.0;
        this.chargepad = chargepad;
        this.name = name;
        this.inputslotA = new InvSlotCharge(this, (int)this.tier);
        this.inputslotB = new InvSlotDischarge(this, (int)this.tier);
        this.inputslotC = new InvSlotElectricBlock(this, 3, 2);
        this.output_plus = 0.0;
        this.temp = 0;
        this.l = output1;
        this.player = null;
        this.energy = this.addComponent(new Energy((TileEntityInventory)this, maxStorage1, Arrays.stream(EnumFacing.field_82609_l).filter(f -> f != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()), EnergyNetGlobal.instance.getTierFromPower(this.output), EnergyNetGlobal.instance.getTierFromPower(this.output), false));
        this.energy.addManagedSlot(this.inputslotA);
        this.energy.addManagedSlot(this.inputslotB);
        this.redstone = this.addComponent(new Redstone(this));
        this.wirelessComponent = this.addComponent(new WirelessComponent(this));
    }

    public TileElectricBlock(EnumElectricBlock electricBlock) {
        this(electricBlock.tier, electricBlock.producing, electricBlock.maxstorage, electricBlock.chargepad, electricBlock.name1);
        this.electricblock = electricBlock;
    }

    public EnumElectricBlock getElectricBlock() {
        return this.electricblock;
    }

    @Override
    public boolean onSneakingActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        this.module_charge(player);
        return true;
    }

    @Override
    public ItemStack getItem(EntityPlayer player, RayTraceResult target) {
        return super.getPickBlock(player, target);
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        double retainedRatio = 0.8;
        double totalEnergy = this.energy.getEnergy();
        ItemStack stack = super.getPickBlock(player, target);
        if (totalEnergy > 0.0) {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            nbt.func_74780_a("energy", (double)Math.round(totalEnergy * retainedRatio));
        }
        return super.getPickBlock(player, target);
    }

    public EnumTypeAudio getType() {
        return this.typeAudio;
    }

    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    public void initiate(int soundEvent) {
        if (this.getType() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            this.func_145831_w().func_184133_a(null, this.field_174879_c, EnumSound.InterruptOne.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
        }
    }

    public SoundEvent getSound() {
        return EnumSound.pen.getSoundEvent();
    }

    public List<ItemStack> getDrop() {
        return this.getAuxDrops(0);
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> info) {
        info.add(Localization.translate("iu.item.tooltip.Output") + " " + ModUtils.getString(EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier())) + " EF/t ");
        info.add(Localization.translate("iu.item.tooltip.Capacity") + " " + ModUtils.getString(this.energy.getCapacity()) + " EF ");
        NBTTagCompound nbttagcompound = ModUtils.nbt(itemStack);
        if (this.energy == null || this.energy.getEnergy() == 0.0) {
            info.add(Localization.translate("iu.item.tooltip.Store") + " " + ModUtils.getString(nbttagcompound.func_74769_h("energy")) + " EF ");
        } else {
            info.add(Localization.translate("iu.item.tooltip.Store") + " " + ModUtils.getString(this.energy.getEnergy()) + " EF ");
        }
        info.add(Localization.translate("iu.tier") + ModUtils.getString(this.tier));
    }

    public ContainerElectricBlock getGuiContainer(EntityPlayer player) {
        return new ContainerElectricBlock(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiElectricBlock(new ContainerElectricBlock(entityPlayer, this));
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.addedToEnergyNet) {
            this.addedToEnergyNet = true;
            if (!this.chargepad) {
                this.energy.setDirections(Arrays.stream(EnumFacing.field_82609_l).filter(facing -> facing != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
            } else {
                this.energy.setDirections(Arrays.stream(EnumFacing.field_82609_l).filter(facing1 -> facing1 != EnumFacing.UP && facing1 != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
            }
        }
        this.wirelessComponent.setEnergySource((IEnergySource)this.energy.getDelegate());
    }

    @Override
    public boolean shouldEmitEnergy() {
        boolean redstone = this.redstone.hasRedstoneInput();
        if (this.redstoneMode == 5) {
            return !redstone;
        }
        if (this.redstoneMode != 6) {
            return true;
        }
        return !redstone || this.energy.getEnergy() > this.energy.getCapacity() - this.output * 20.0;
    }

    @Override
    public double getEUStored() {
        return this.energy.getEnergy();
    }

    @Override
    public double getOutput() {
        return this.output;
    }

    protected void getItems(EntityPlayer player) {
        if (!this.canEntityDestroy((Entity)player)) {
            IUCore.proxy.messagePlayer(player, Localization.translate("iu.error"), new Object[0]);
            return;
        }
        for (ItemStack current : player.field_71071_by.field_70460_b) {
            if (current == null) continue;
            this.chargeitems(current, this.output);
        }
        for (ItemStack current : player.field_71071_by.field_70462_a) {
            if (current == null) continue;
            this.chargeitems(current, this.output);
        }
        player.field_71069_bz.func_75142_b();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            World world = this.func_145831_w();
            Random rnd = world.field_73012_v;
            int n = 4;
            boolean green = false;
            boolean blue = true;
            for (int i = 0; i < 4; ++i) {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)this.field_174879_c.func_177958_n() + rnd.nextFloat()), (double)((float)(this.field_174879_c.func_177956_o() + 1) + rnd.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + rnd.nextFloat()), -1.0, 0.0, (double)blue, new int[0]);
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)this.field_174879_c.func_177958_n() + rnd.nextFloat()), (double)((float)(this.field_174879_c.func_177956_o() + 2) + rnd.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + rnd.nextFloat()), -1.0, 0.0, (double)blue, new int[0]);
            }
        }
    }

    protected void chargeitems(ItemStack itemstack, double chargefactor) {
        if (!(itemstack.func_77973_b() instanceof IEnergyItem)) {
            return;
        }
        double freeamount = ElectricItem.manager.charge(itemstack, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true);
        if (freeamount > 0.0) {
            double charge = Math.min(freeamount, chargefactor);
            charge = Math.min(charge, ((IEnergyItem)itemstack.func_77973_b()).getTransferEnergy(itemstack));
            if (this.energy.getEnergy() < charge) {
                charge = this.energy.getEnergy();
            }
            this.energy.useEnergy(ElectricItem.manager.charge(itemstack, charge, (int)this.tier, true, false));
        }
    }

    public float getChargeLevel() {
        float ret = (float)((double)((float)this.energy.getEnergy()) / this.energy.getCapacity());
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    public void module_charge(EntityPlayer entityPlayer) {
        double sent;
        if (this.movementcharge) {
            for (ItemStack armorcharged : entityPlayer.field_71071_by.field_70460_b) {
                if (armorcharged == null || !(armorcharged.func_77973_b() instanceof IEnergyItem) || !(this.energy.getEnergy() > 0.0)) continue;
                sent = ElectricItem.manager.charge(armorcharged, this.energy.getEnergy(), Integer.MAX_VALUE, true, false);
                entityPlayer.field_71069_bz.func_75142_b();
                this.energy.useEnergy(sent);
                boolean bl = this.needsInvUpdate = sent > 0.0;
                if (!(sent > 0.0)) continue;
                CommonProxy.sendPlayerMessage(entityPlayer, Localization.translate("successfully.charged") + armorcharged.func_82833_r() + Localization.translate("iu.sendenergy") + ModUtils.getString(sent) + " EF");
                entityPlayer.field_71069_bz.func_75142_b();
            }
        }
        if (this.movementchargeitem) {
            for (ItemStack charged : entityPlayer.field_71071_by.field_70462_a) {
                if (charged == null || !(charged.func_77973_b() instanceof IEnergyItem) || !(this.energy.getEnergy() > 0.0)) continue;
                sent = ElectricItem.manager.charge(charged, this.energy.getEnergy(), Integer.MAX_VALUE, true, false);
                this.energy.useEnergy(sent);
                boolean bl = this.needsInvUpdate = sent > 0.0;
                if (!(sent > 0.0)) continue;
                CommonProxy.sendPlayerMessage(entityPlayer, Localization.translate("successfully.charged") + charged.func_82833_r() + Localization.translate("iu.sendenergy") + ModUtils.getString(sent) + " EF");
                entityPlayer.field_71069_bz.func_75142_b();
            }
        }
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        if (this.chargepad) {
            return Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0));
        }
        return super.getAabbs(forCollision);
    }

    protected void updatePlayer(EntityPlayer entity) {
        this.player = entity;
    }

    @Override
    public void onEntityCollision(Entity entity) {
        super.onEntityCollision(entity);
        if (!this.func_145831_w().field_72995_K && entity instanceof EntityPlayer && this.chargepad && this.canEntityDestroy(entity)) {
            this.updatePlayer((EntityPlayer)entity);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.load) {
            this.inputslotC.wirelessmodule();
            this.load = true;
        }
        this.needsInvUpdate = false;
        this.energy.setSendingEnabled(this.shouldEmitEnergy());
        this.energy.receivingDisabled = false;
        if (this.chargepad) {
            if (this.player != null && this.energy.getEnergy() >= 1.0) {
                if (!this.getActive()) {
                    this.setActive(true);
                }
                this.getItems(this.player);
                this.module_charge(this.player);
                this.player = null;
                this.needsInvUpdate = true;
            } else if (this.getActive()) {
                this.setActive(false);
                this.needsInvUpdate = true;
            }
        }
        boolean ignore = this.inputslotC.checkignore();
        this.inputslotA.setIgnore(ignore);
    }

    public int getCapacity() {
        return (int)this.energy.getCapacity();
    }

    @Override
    public double getEUCapacity() {
        return this.energy.getCapacity();
    }

    public int addEnergy(int amount) {
        this.energy.addEnergy(amount);
        return amount;
    }

    @Override
    public int getTier() {
        return this.energy.getSinkTier();
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (!this.func_145831_w().field_72995_K) {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            this.energy.addEnergy(nbt.func_74769_h("energy"));
        }
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.addAll(this.getSelfDrops(fortune, true));
        ret.addAll(this.getAuxDrops(fortune));
        return ret;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        ItemStack drop = this.getPickBlock(null, null);
        return (drop = this.adjustDrop(drop, wrench, fortune)) == null ? Collections.emptyList() : Collections.singletonList(drop);
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench, int fortune) {
        if ((drop = super.adjustDrop(drop, wrench, fortune)).func_77969_a(this.getPickBlock(null, null)) && (wrench || this.teBlock.getDefaultDrop() == MultiTileBlock.DefaultDrop.Self)) {
            double totalEnergy;
            double retainedRatio = 0.8;
            if (fortune == 100) {
                retainedRatio = 1.0;
            }
            if ((totalEnergy = this.energy.getEnergy()) > 0.0) {
                NBTTagCompound nbt = ModUtils.nbt(drop);
                nbt.func_74780_a("energy", (double)Math.round(totalEnergy * retainedRatio));
            }
        }
        return drop;
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        drop = super.adjustDrop(drop, wrench);
        if (wrench || this.teBlock.getDefaultDrop() == MultiTileBlock.DefaultDrop.Self) {
            double retainedRatio = 0.8;
            double totalEnergy = this.energy.getEnergy();
            if (totalEnergy > 0.0) {
                NBTTagCompound nbt = ModUtils.nbt(drop);
                nbt.func_74780_a("energy", (double)Math.round(totalEnergy * retainedRatio));
            }
        }
        return drop;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.rfeu = nbttagcompound.func_74767_n("rfeu");
        this.redstoneMode = nbttagcompound.func_74771_c("redstoneMode");
    }

    @Override
    public void setFacing(EnumFacing facing) {
        super.setFacing(facing);
        if (!this.chargepad) {
            this.energy.setDirections(Arrays.asList(EnumFacing.field_82609_l).stream().filter(facing1 -> facing1 != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
        } else {
            this.energy.setDirections(Arrays.asList(EnumFacing.field_82609_l).stream().filter(facing1 -> facing1 != EnumFacing.UP && facing1 != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("rfeu", this.rfeu);
        nbttagcompound.func_74774_a("redstoneMode", this.redstoneMode);
        return nbttagcompound;
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 1: {
                return this.energy.getEnergy() >= this.energy.getCapacity() - this.output * 20.0;
            }
            case 2: {
                return this.energy.getEnergy() > this.output && this.energy.getEnergy() < this.energy.getCapacity() - this.output;
            }
            case 3: {
                return this.energy.getEnergy() < this.energy.getCapacity() - this.output;
            }
            case 4: {
                return this.energy.getEnergy() < this.output;
            }
        }
        return false;
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= 7) {
            this.redstoneMode = 0;
        }
        IUCore.proxy.messagePlayer(player, this.getStringRedstoneMode(), new Object[0]);
    }

    @Override
    public byte getRedstoneMode() {
        return this.redstoneMode;
    }

    public String getStringRedstoneMode() {
        return this.redstoneMode < 7 && this.redstoneMode >= 0 ? Localization.translate("iu.EUStorage.gui.mod.redstone" + this.redstoneMode) : "";
    }

    public String getInventoryName() {
        return Localization.translate(this.name);
    }
}

