/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerElectrolyzer;
import com.denfop.gui.GuiElectrolyzer;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotElectrolyzer;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;
import org.lwjgl.input.Keyboard;

public class TileElectrolyzer
extends TileElectricMachine
implements IManufacturerBlock,
IUpgradableBlock,
IHasRecipe {
    public final InvSlotElectrolyzer cathodeslot;
    public final InvSlotElectrolyzer anodeslot;
    public final Fluids.InternalFluidTank fluidTank2;
    public final Fluids.InternalFluidTank fluidTank1;
    public final Fluids.InternalFluidTank fluidTank3;
    public final FluidHandlerRecipe fluid_handler;
    public final InvSlotFluidByList fluidSlot1;
    public final InvSlotFluidByList fluidSlot2;
    public final InvSlotFluidByList fluidSlot3;
    public final InvSlotUpgrade upgradeSlot;
    private final Fluids fluids = this.addComponent(new Fluids(this));
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private int level;

    public TileElectrolyzer() {
        super(24000.0, 1, 2);
        this.fluidTank1 = this.fluids.addTank("fluidTank1", 12000, InvSlot.TypeItemSlot.INPUT);
        this.fluidTank2 = this.fluids.addTank("fluidTank2", 12000, InvSlot.TypeItemSlot.OUTPUT);
        this.fluidTank3 = this.fluids.addTank("fluidTank3", 12000, InvSlot.TypeItemSlot.OUTPUT);
        this.fluid_handler = new FluidHandlerRecipe("electrolyzer", this.fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(0)));
        this.fluidTank2.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.fluidTank3.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(1)));
        this.fluidSlot1 = new InvSlotFluidByList((TileEntityInventory)this, 1, this.fluid_handler.getFluids(0));
        this.fluidSlot2 = new InvSlotFluidByList((TileEntityInventory)this, 1, this.fluid_handler.getOutputFluids(0));
        this.fluidSlot3 = new InvSlotFluidByList((TileEntityInventory)this, 1, this.fluid_handler.getOutputFluids(1));
        this.fluidSlot2.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.fluidSlot3.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.cathodeslot = new InvSlotElectrolyzer(this, 1);
        this.anodeslot = new InvSlotElectrolyzer(this, 0);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        Recipes.recipes.getRecipeFluid().addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        NBTTagCompound compound = super.func_189515_b(nbttagcompound);
        compound.func_74768_a("levelMech", this.level);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.level = nbttagcompound.func_74762_e("levelMech");
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void init() {
        Recipes.recipes.getRecipeFluid().addRecipe("electrolyzer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack(FluidRegistry.WATER, 4)), Arrays.asList(new FluidStack(FluidName.fluidhyd.getInstance(), 2), new FluidStack(FluidName.fluidoxy.getInstance(), 1))));
        Recipes.recipes.getRecipeFluid().addRecipe("electrolyzer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack(FluidName.fluidfluorhyd.getInstance(), 5)), Arrays.asList(new FluidStack(FluidName.fluidhyd.getInstance(), 3), new FluidStack(FluidName.fluidfluor.getInstance(), 1))));
        Recipes.recipes.getRecipeFluid().addRecipe("electrolyzer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack(FluidName.fluidhydrogenbromide.getInstance(), 5)), Arrays.asList(new FluidStack(FluidName.fluidhyd.getInstance(), 3), new FluidStack(FluidName.fluidbromine.getInstance(), 1))));
        Recipes.recipes.getRecipeFluid().addRecipe("electrolyzer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack(FluidName.fluidwastesulfuricacid.getInstance(), 2)), Arrays.asList(new FluidStack(FluidName.fluidsulfurtrioxide.getInstance(), 1), new FluidStack(FluidRegistry.WATER, 1))));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.electrolyzer_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    public ContainerElectrolyzer getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectrolyzer(entityPlayer, this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
            this.fluid_handler.load();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiElectrolyzer(new ContainerElectrolyzer(entityPlayer, this));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + 25 + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MutableObject output1 = new MutableObject();
        boolean check = false;
        if (this.fluidTank1.getFluidAmount() + 1000 <= this.fluidTank1.getCapacity() && this.fluidSlot1.transferToTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot1.transferToTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
            check = true;
        }
        if (this.fluidTank2.getFluidAmount() - 1000 >= 0 && this.fluidSlot2.transferFromTank((IFluidTank)this.fluidTank2, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot2.transferFromTank((IFluidTank)this.fluidTank2, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
            check = true;
        }
        if (this.fluidTank3.getFluidAmount() - 1000 >= 0 && this.fluidSlot3.transferFromTank((IFluidTank)this.fluidTank3, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot3.transferFromTank((IFluidTank)this.fluidTank3, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
        }
        if (check || this.fluid_handler.output() == null && this.fluidTank1.getFluidAmount() >= 1) {
            this.fluid_handler.getOutput();
        } else if (this.fluid_handler.output() != null && !this.fluid_handler.checkFluids()) {
            this.fluid_handler.setOutput(null);
        }
        if (this.cathodeslot.isEmpty() || this.anodeslot.isEmpty()) {
            if (this.getActive()) {
                this.setActive(false);
                this.initiate(2);
            }
        } else {
            boolean drain = false;
            boolean drain1 = false;
            if (this.fluid_handler.output() != null && this.fluid_handler.canOperate() && this.fluid_handler.canFillFluid() && this.energy.canUseEnergy(25.0)) {
                FluidStack fluidStack;
                BaseFluidMachineRecipe output = this.fluid_handler.output();
                FluidStack inputFluidStack = output.input.getInputs().get(0);
                int size = this.getFluidTank(0).getFluidAmount() / inputFluidStack.amount;
                size = Math.min(this.level + 1, size);
                int cap = this.getFluidTank(1).getCapacity() - this.getFluidTank(1).getFluidAmount();
                FluidStack outputFluidStack = output.output_fluid.get(0);
                cap /= outputFluidStack.amount;
                cap = Math.min(cap, size);
                int cap1 = this.getFluidTank(2).getCapacity() - this.getFluidTank(2).getFluidAmount();
                FluidStack outputFluidStack1 = output.output_fluid.get(1);
                size = Math.min(Math.min(size, cap1 /= outputFluidStack1.amount), cap);
                if (this.getFluidTank(1).getCapacity() - this.getFluidTank(1).getFluidAmount() >= outputFluidStack.amount) {
                    fluidStack = new FluidStack(outputFluidStack.getFluid(), outputFluidStack.amount * size);
                    this.fluidTank2.fill(fluidStack, true);
                    drain = true;
                }
                if (this.getFluidTank(2).getCapacity() - this.getFluidTank(2).getFluidAmount() >= outputFluidStack1.amount) {
                    fluidStack = new FluidStack(outputFluidStack1.getFluid(), outputFluidStack1.amount * size);
                    this.fluidTank3.fill(fluidStack, true);
                    drain1 = true;
                }
                if (drain || drain1) {
                    int drains = size * inputFluidStack.amount;
                    this.getFluidTank(0).drain(drains, true);
                    if (!this.getActive()) {
                        this.setActive(true);
                        this.initiate(0);
                    }
                    this.energy.useEnergy(25.0);
                    this.setActive(true);
                    ItemStack cathode = this.cathodeslot.get();
                    ItemStack anode = this.anodeslot.get();
                    if (cathode.func_77952_i() < cathode.func_77958_k()) {
                        cathode.func_77964_b(cathode.func_77952_i() + 1);
                    }
                    if (anode.func_77952_i() < anode.func_77958_k()) {
                        anode.func_77964_b(anode.func_77952_i() + 1);
                    }
                    if (cathode.func_77952_i() == cathode.func_77958_k()) {
                        this.cathodeslot.consume(1);
                    }
                    if (anode.func_77952_i() == anode.func_77958_k()) {
                        this.anodeslot.consume(1);
                    }
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        int tier = this.upgradeSlot.getTier(1);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(24000));
    }

    public FluidTank getFluidTank(int i) {
        switch (i) {
            case 1: {
                return this.fluidTank2;
            }
            case 2: {
                return this.fluidTank3;
            }
        }
        return this.fluidTank1;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.level < 10) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77973_b().equals(IUItem.upgrade_speed_creation)) {
                return super.onActivated(player, hand, side, hitX, hitY, hitZ);
            }
            stack.func_190918_g(1);
            ++this.level;
            return true;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void removeLevel(int level) {
        this.level -= level;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidExtract, UpgradableProperty.FluidInput, UpgradableProperty.ItemInput);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.electrolyzer.getSoundEvent();
    }
}

