/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockAnvil;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.effects.ParticleItemCustom;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.register.RegisterOreDictionary;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class TileEntityAnvil
extends TileEntityInventory
implements IUpdateTick,
IHasRecipe,
IAudioFixer {
    private static final List<AxisAlignedBB> aabbs = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, 1.0, 2.0));
    private static final List<AxisAlignedBB> aabbs1 = Collections.singletonList(new AxisAlignedBB(-1.0, 0.0, 0.0, 2.0, 1.0, 1.0));
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes(this, "anvil", this){

        @Override
        public boolean accepts(ItemStack itemStack, int index) {
            if (index == 4) {
                return super.accepts(itemStack, 0);
            }
            return false;
        }
    };
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public int progress = 0;
    public MachineRecipe output;
    public int durability = 300;
    public Map<UUID, Double> data;

    public TileEntityAnvil() {
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing) && capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        if (this.facing != 4 && this.facing != 5) {
            return aabbs1;
        }
        return aabbs;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair"));
        tooltip.add(Localization.translate("primitive_rcm.info"));
        tooltip.add(Localization.translate("primitive_use.info") + IUItem.ForgeHammer.getItemStackDisplayName());
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.anvil;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockAnvil.block_anvil;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        ItemStack stack = drop.get(0);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74768_a("durability", this.durability);
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (nbt.func_74764_b("durability")) {
            this.durability = nbt.func_74762_e("durability");
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.ANVIL);
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
            new PacketUpdateFieldTile(this, "durability", this.durability);
            if (this.durability > 200) {
                this.setActive("");
            } else if (this.durability > 100) {
                this.setActive("1");
            } else if (this.durability > 0) {
                this.setActive("2");
            } else {
                this.setActive("3");
            }
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("durability")) {
            try {
                this.durability = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.put(0, ItemStack.field_190927_a);
        }
        if (name.equals("slot2")) {
            this.outputSlot.put(0, ItemStack.field_190927_a);
        }
        if (name.equals("effect")) {
            this.spawnItemParticles(this.field_145850_b, this.field_174879_c, this.inputSlotA.get(0));
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            this.durability = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.durability);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onSneakingActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.durability >= 0 && this.durability < 300 && stack.func_77973_b() == IUItem.iuingot && stack.func_77952_i() == 10) {
            this.durability += 50;
            if (this.durability > 300) {
                this.durability = 300;
            }
            stack.func_190918_g(1);
            if (this.durability > 200) {
                this.setActive("");
            } else if (this.durability > 100) {
                this.setActive("1");
            } else if (this.durability > 0) {
                this.setActive("2");
            } else {
                this.setActive("3");
            }
            new PacketUpdateFieldTile(this, "durability", this.durability);
        }
        return super.onSneakingActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnItemParticles(World world, BlockPos pos, ItemStack stack) {
        Random rand = new Random();
        for (int i = 0; i < 1; ++i) {
            double offsetX = -0.05;
            double offsetY = 0.05;
            double offsetZ = -0.05;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleItemCustom(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, offsetX, offsetY, offsetZ, stack));
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_145831_w().field_72995_K) {
            if (this.durability > 0 && (stack.func_77973_b() == IUItem.ForgeHammer || stack.func_77973_b() == IUItem.ObsidianForgeHammer) && this.output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items.get(0))) {
                this.progress += 10;
                this.getCooldownTracker().setTick(10);
                if (stack.func_77973_b() == IUItem.ObsidianForgeHammer) {
                    this.progress += 10;
                }
                new PacketUpdateFieldTile(this, "effect", true);
                this.progress += (int)(this.data.getOrDefault(player.func_110124_au(), 0.0) / 5.0);
                if (!this.func_145831_w().field_72995_K) {
                    this.initiate(0);
                }
                if (this.progress >= 100) {
                    this.progress = 0;
                    if (!this.func_145831_w().field_72995_K) {
                        PrimitiveHandler.addExperience(EnumPrimitive.ANVIL, 0.5, player.func_110124_au());
                    }
                    --this.durability;
                    if (this.durability > 200) {
                        this.setActive("");
                    } else if (this.durability > 100) {
                        this.setActive("1");
                    } else if (this.durability > 0) {
                        this.setActive("2");
                    } else {
                        this.setActive("3");
                    }
                    player.func_184611_a(hand, stack.func_77973_b().getContainerItem(stack));
                    this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                    this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                    if (this.inputSlotA.isEmpty() || this.outputSlot.get().func_190916_E() >= 64) {
                        this.output = null;
                    }
                    if (!this.field_145850_b.field_72995_K) {
                        if (!this.inputSlotA.get().func_190926_b()) {
                            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                        } else {
                            new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                        }
                        new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                        new PacketUpdateFieldTile(this, "durability", this.durability);
                    }
                    if ((double)WorldBaseGen.random.nextInt(100) < this.data.getOrDefault(player.func_110124_au(), 0.0) & this.output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items.get(0))) {
                        this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                        this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                        if (this.inputSlotA.isEmpty() || this.outputSlot.get(0).func_190916_E() >= 64) {
                            this.output = null;
                        }
                        if (!this.field_145850_b.field_72995_K) {
                            if (!this.inputSlotA.get(0).func_190926_b()) {
                                new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                            } else {
                                new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                            }
                            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                            new PacketUpdateFieldTile(this, "durability", this.durability);
                        }
                    }
                }
                return this.func_145831_w().field_72995_K;
            }
            if (!stack.func_190926_b()) {
                if (this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.accepts(stack, 4)) {
                    this.inputSlotA.put(0, stack.func_77946_l());
                    stack.func_190920_e(0);
                    if (!this.field_145850_b.field_72995_K) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    return true;
                }
                if (!this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.get(0).func_77969_a(stack)) {
                    int minCount = 64 - this.inputSlotA.get(0).func_190916_E();
                    minCount = Math.min(stack.func_190916_E(), minCount);
                    this.inputSlotA.get(0).func_190917_f(minCount);
                    stack.func_190917_f(-minCount);
                    if (!this.field_145850_b.field_72995_K) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    return true;
                }
            } else {
                if (!this.outputSlot.isEmpty()) {
                    if (!this.field_145850_b.field_72995_K) {
                        ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.outputSlot.get(), player);
                    }
                    this.outputSlot.put(0, ItemStack.field_190927_a);
                    if (!this.field_145850_b.field_72995_K) {
                        new PacketUpdateFieldTile(this, "slot2", false);
                    }
                    return true;
                }
                if (!this.inputSlotA.isEmpty()) {
                    if (!this.field_145850_b.field_72995_K) {
                        ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.inputSlotA.get(), player);
                    }
                    this.inputSlotA.put(0, ItemStack.field_190927_a);
                    this.output = null;
                    if (!this.field_145850_b.field_72995_K) {
                        new PacketUpdateFieldTile(this, "slot3", false);
                    }
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.durability = nbttagcompound.func_74762_e("durability");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("durability", this.durability);
        return nbttagcompound;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        for (String s : RegisterOreDictionary.list_string) {
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingot" + s, 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)("plate" + s)))));
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("plate" + s, 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)("casing" + s)), 2)));
        }
        for (String s : RegisterOreDictionary.list_baseore1) {
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingot" + s, 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)("plate" + s)))));
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("plate" + s, 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)("casing" + s)), 2)));
        }
        for (String s : RegisterOreDictionary.list_string1) {
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingot" + s, 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)("plate" + s)))));
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("plate" + s, 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)("casing" + s)), 2)));
        }
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotIron", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateIron"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((Item)IUItem.crafting_elements, 1, 504), 1)), new RecipeOutput(null, new ItemStack((Item)IUItem.crafting_elements, 1, 501))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("plateIron", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"casingIron"), 2)));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotGold", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateGold"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotLead", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateLead"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotTin", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateTin"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("plateTin", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"casingTin"), 2)));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("plateBronze", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"casingBronze"), 2)));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotOsmium", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateOsmium"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotTantalum", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateTantalum"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotCadmium", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateCadmium"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotSteel", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateSteel"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotBronze", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateBronze"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("ingotCopper", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"plateCopper"))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("plateCopper", 1)), new RecipeOutput(null, (List<ItemStack>)OreDictionary.getOres((String)"casingCopper"), 2)));
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return EnumTypeAudio.ON;
    }

    @Override
    public void setType(EnumTypeAudio type) {
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.molot.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (soundEvent == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 0.2f, 1.0f);
        }
    }

    @Override
    public boolean getEnable() {
        return true;
    }
}

