/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerAutomaticMechanism;
import com.denfop.container.SlotInfo;
import com.denfop.gui.GuiAutomaticMechanism;
import com.denfop.invslot.HandlerInventory;
import com.denfop.invslot.InvSlot;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.Upgrade;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityAutomaticMechanism
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final SlotInfo slot;
    public final InvSlot slotOI;
    public final Map<EnumFacing, HandlerInventory> iItemHandlerMap = new HashMap<EnumFacing, HandlerInventory>();
    public final Map<IItemHandler, Integer> slotHandler = new HashMap<IItemHandler, Integer>();
    private final IItemHandler main_handler;
    public Map<EnumFacing, Upgrade> typeUpgradeMap = new HashMap<EnumFacing, Upgrade>();
    public Map<EnumFacing, List<ItemStack>> extract = new HashMap<EnumFacing, List<ItemStack>>();
    public Map<EnumFacing, List<ItemStack>> pulling = new HashMap<EnumFacing, List<ItemStack>>();
    private int type = 0;
    private boolean put = false;

    public TileEntityAutomaticMechanism() {
        this.slot = new SlotInfo(this, 36, false){

            @Override
            public void put(int index, ItemStack stack) {
                super.put(index, stack);
                ((TileEntityAutomaticMechanism)this.base).updateList();
            }
        };
        this.slotOI = new InvSlot(this, InvSlot.TypeItemSlot.INPUT_OUTPUT, 24){

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                TileEntityAutomaticMechanism.this.put = true;
            }
        };
        for (EnumFacing facing1 : EnumFacing.field_82609_l) {
            this.typeUpgradeMap.put(facing1, Upgrade.NONE);
        }
        this.main_handler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing());
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        for (EnumFacing facing1 : EnumFacing.field_82609_l) {
            customPacketBuffer.writeInt(this.typeUpgradeMap.get(facing1).ordinal());
        }
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        for (EnumFacing facing1 : EnumFacing.field_82609_l) {
            this.typeUpgradeMap.replace(facing1, Upgrade.values()[customPacketBuffer.readInt()]);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.typeUpgradeMap.clear();
        for (EnumFacing facing1 : EnumFacing.field_82609_l) {
            this.typeUpgradeMap.put(facing1, Upgrade.values()[nbtTagCompound.func_74762_e(facing1.name().toLowerCase())]);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        for (EnumFacing facing1 : this.typeUpgradeMap.keySet()) {
            nbt.func_74768_a(facing1.name().toLowerCase(), this.typeUpgradeMap.get(facing1).ordinal());
        }
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.updateList();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
            this.iItemHandlerMap.clear();
            this.slotHandler.clear();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos pos = this.func_174877_v().func_177972_a(facing);
                TileEntity tile1 = this.func_145831_w().func_175625_s(pos);
                IItemHandler handler = ModUtils.getItemHandler(tile1, facing.func_176734_d());
                if (!(tile1 instanceof IInventory)) {
                    if (handler == null) {
                        this.iItemHandlerMap.put(facing, null);
                    } else {
                        this.iItemHandlerMap.put(facing, new HandlerInventory(handler, null));
                    }
                } else {
                    this.iItemHandlerMap.put(facing, new HandlerInventory(handler, (IInventory)tile1));
                }
                if (handler == null) continue;
                this.slotHandler.put(handler, handler.getSlots());
            }
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 3L == 0L) {
            for (Map.Entry entry : this.typeUpgradeMap.entrySet()) {
                switch ((Upgrade)((Object)entry.getValue())) {
                    case EXTRACT: {
                        this.tick((EnumFacing)entry.getKey());
                        break;
                    }
                    case PULLING: {
                        this.tickPullIn((EnumFacing)entry.getKey());
                        break;
                    }
                    case EXT_PUL: {
                        this.tick((EnumFacing)entry.getKey());
                        this.tickPullIn((EnumFacing)entry.getKey());
                    }
                }
            }
        }
    }

    private void tickPullIn(EnumFacing facing) {
        block22: {
            List itemStackList = this.pulling.getOrDefault(facing, Collections.emptyList());
            if (facing == null) break block22;
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (handler.getInventory() != null && handler.getInventory() instanceof TileEntityInventory) {
                List<InvSlot> inputs = this.getParent().getInputSlots();
                TileEntityInventory inventory = (TileEntityInventory)handler.getInventory();
                List<InvSlot> outputs = inventory.getOutputSlots();
                for (InvSlot slot : outputs) {
                    for (InvSlot invSlot : inputs) {
                        ItemStack input;
                        if (invSlot.acceptAllOrIndex()) {
                            for (int j = 0; j < slot.size(); ++j) {
                                ItemStack output = slot.get(j);
                                if (output.func_190926_b() || output.func_190916_E() == output.func_77976_d()) continue;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    for (ItemStack stack : itemStackList) {
                                        if (!ModUtils.checkItemEquality(stack, output)) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue;
                                }
                                if (!invSlot.accepts(output, 0)) continue;
                                for (int jj = 0; jj < invSlot.size() && !output.func_190926_b(); ++jj) {
                                    int maxCount;
                                    input = invSlot.get(jj);
                                    if (input.func_190926_b()) {
                                        if (!invSlot.add(output)) continue;
                                        slot.put(j, ItemStack.field_190927_a);
                                        output = ItemStack.field_190927_a;
                                        continue;
                                    }
                                    if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.func_77976_d() - input.func_190916_E(), output.func_190916_E())) <= 0) continue;
                                    input.func_190917_f(maxCount);
                                    output.func_190918_g(maxCount);
                                }
                            }
                            continue;
                        }
                        block7: for (int jj = 0; jj < slot.size(); ++jj) {
                            ItemStack output;
                            for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).func_190926_b(); ++j) {
                                int maxCount;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    input = itemStackList.iterator();
                                    while (input.hasNext()) {
                                        ItemStack stack = (ItemStack)input.next();
                                        if (!stack.func_77969_a(output)) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue block7;
                                }
                                if ((input = invSlot.get(j)).func_190926_b()) {
                                    if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                    slot.put(jj, ItemStack.field_190927_a);
                                    output = ItemStack.field_190927_a;
                                    continue;
                                }
                                if (!output.func_77969_a(input) || (maxCount = Math.min(input.func_77976_d() - input.func_190916_E(), output.func_190916_E())) <= 0) continue;
                                input.func_190917_f(maxCount);
                                output.func_190918_g(maxCount);
                            }
                        }
                    }
                }
            } else {
                int slots = 0;
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                for (int j = 0; j < slots; ++j) {
                    ItemStack took1;
                    ItemStack took = handler.getHandler().extractItem(j, 64, true);
                    if (took.func_190926_b()) continue;
                    boolean find = false;
                    if (!itemStackList.isEmpty()) {
                        for (ItemStack stack : itemStackList) {
                            if (!stack.func_77969_a(took)) continue;
                            find = true;
                            break;
                        }
                        if (!find) continue;
                    }
                    if ((took1 = ModUtils.insertItem(this.main_handler, took, true, this.main_handler.getSlots())).func_190926_b()) {
                        took = handler.getHandler().extractItem(j, took.func_190916_E(), false);
                        ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                        continue;
                    }
                    if (took1 == took) continue;
                    int count = took1.func_190916_E() - took.func_190916_E();
                    count = Math.abs(count);
                    took = handler.getHandler().extractItem(j, count, false);
                    ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                }
            }
        }
    }

    private void tick(EnumFacing facing) {
        block27: {
            List itemStackList = this.extract.getOrDefault(facing, Collections.emptyList());
            if (facing == null) break block27;
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            int slots = 0;
            if (handler.getInventory() != null && handler.getInventory() instanceof TileEntityInventory) {
                TileEntityInventory inventory = (TileEntityInventory)handler.getInventory();
                InvSlot slot = this.slotOI;
                for (InvSlot invSlot : inventory.getInputSlots()) {
                    if (invSlot.acceptAllOrIndex()) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack output = slot.get(j);
                            if (output.func_190926_b()) continue;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack : itemStackList) {
                                    if (!stack.func_77969_a(output)) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue;
                            }
                            if (!invSlot.accepts(output, 0)) continue;
                            for (int jj = 0; jj < invSlot.size() && !output.func_190926_b(); ++jj) {
                                int maxCount;
                                ItemStack input = invSlot.get(jj);
                                if (input.func_190926_b()) {
                                    if (!invSlot.add(output)) continue;
                                    slot.put(j, ItemStack.field_190927_a);
                                    output = ItemStack.field_190927_a;
                                    continue;
                                }
                                if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.func_77976_d() - input.func_190916_E(), output.func_190916_E())) <= 0) continue;
                                input.func_190917_f(maxCount);
                                output.func_190918_g(maxCount);
                            }
                        }
                        continue;
                    }
                    block6: for (int jj = 0; jj < slot.size(); ++jj) {
                        for (int j = 0; j < invSlot.size(); ++j) {
                            int maxCount;
                            ItemStack output = slot.get(jj);
                            ItemStack input = invSlot.get(j);
                            if (output.func_190926_b()) continue block6;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack : itemStackList) {
                                    if (!stack.func_77969_a(output)) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue block6;
                            }
                            if (input.func_190926_b()) {
                                if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                slot.put(jj, ItemStack.field_190927_a);
                                output = ItemStack.field_190927_a;
                                continue;
                            }
                            if (!output.func_77969_a(input) || (maxCount = Math.min(input.func_77976_d() - input.func_190916_E(), output.func_190916_E())) <= 0) continue;
                            input.func_190917_f(maxCount);
                            output.func_190918_g(maxCount);
                        }
                    }
                }
            } else {
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                if (handler.getInventory() != null) {
                    InvSlot slot = this.slotOI;
                    for (int j = 0; j < slot.size(); ++j) {
                        ItemStack stack;
                        ItemStack took = slot.get(j);
                        if (took.func_190926_b()) continue;
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack2 : itemStackList) {
                                if (!stack2.func_77969_a(took)) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        if ((stack = this.insertItem1(handler, took, true, slots)).func_190926_b()) {
                            slot.put(j, ItemStack.field_190927_a);
                            this.insertItem1(handler, took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        int col = slot.get(j).func_190916_E() - stack.func_190916_E();
                        slot.get(j).func_190918_g(col);
                        stack.func_190920_e(col);
                        this.insertItem1(handler, stack, false, slots);
                    }
                } else {
                    InvSlot slot = this.slotOI;
                    for (int j = 0; j < slot.size(); ++j) {
                        ItemStack took = slot.get(j);
                        if (took.func_190926_b()) continue;
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack : itemStackList) {
                                if (!stack.func_77969_a(took)) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        took = took.func_77946_l();
                        ItemStack stack = ModUtils.insertItem(handler.getHandler(), took, true, slots);
                        if (stack.func_190926_b()) {
                            slot.put(j, ItemStack.field_190927_a);
                            ModUtils.insertItem(handler.getHandler(), took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        int col = slot.get(j).func_190916_E() - stack.func_190916_E();
                        slot.get(j).func_190918_g(col);
                        stack.func_190920_e(col);
                        ModUtils.insertItem(handler.getHandler(), stack, false, slots);
                    }
                }
            }
        }
    }

    @Nonnull
    public ItemStack insertItem1(HandlerInventory dest, @Nonnull ItemStack stack, boolean simulate, int slot) {
        if (dest == null || stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < slot; ++i) {
            ItemStack stack2 = this.insertItem2(dest, i, stack, simulate);
            if (stack2.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (stack2 == stack) continue;
            return stack2;
        }
        return stack;
    }

    public boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.func_190926_b() || !a.func_77969_a(b) || a.func_77942_o() != b.func_77942_o()) {
            return false;
        }
        return !a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p());
    }

    @Nonnull
    public ItemStack insertItem2(HandlerInventory dest1, int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack stackInSlot;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IItemHandler dest = dest1.getHandler();
        IInventory inventory = dest1.getInventory();
        try {
            stackInSlot = inventory.func_70301_a(slot);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            stackInSlot = dest.getStackInSlot(slot);
        }
        if (!stackInSlot.func_190926_b()) {
            int max = stackInSlot.func_77976_d();
            int limit = dest.getSlotLimit(slot);
            if (stackInSlot.func_190916_E() >= Math.min(max, limit)) {
                return stack;
            }
            if (simulate && !inventory.func_94041_b(slot, stack)) {
                return stack;
            }
            if (!this.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            int m = Math.min(max, limit) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    inventory.func_70299_a(slot, copy);
                    return ItemStack.field_190927_a;
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                inventory.func_70299_a(slot, copy);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), dest.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                inventory.func_70299_a(slot, stack.func_77979_a(m));
            }
            return stack;
        }
        if (!simulate) {
            try {
                inventory.func_70299_a(slot, stack);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                dest.insertItem(slot, stack, false);
            }
        }
        return ItemStack.field_190927_a;
    }

    public ContainerAutomaticMechanism getGuiContainer(EntityPlayer var1) {
        return new ContainerAutomaticMechanism(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiAutomaticMechanism(this.getGuiContainer(var1));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.automatic_mechanism;
    }

    private void updateList() {
        this.extract.clear();
        this.pulling.clear();
        block5: for (EnumFacing facing1 : EnumFacing.field_82609_l) {
            Upgrade upgrade = this.typeUpgradeMap.get(facing1);
            if (upgrade == Upgrade.NONE) continue;
            LinkedList<Object> itemStackList = new LinkedList<Object>();
            LinkedList<ItemStack> itemStackList1 = new LinkedList<ItemStack>();
            for (int i = facing1.ordinal() * 6; i < facing1.ordinal() * 6 + 6; ++i) {
                ItemStack stack = this.slot.get(i);
                if (!stack.func_190926_b() && i >= facing1.ordinal() * 6 && i < facing1.ordinal() * 6 + 3) {
                    itemStackList.add(stack);
                    continue;
                }
                if (stack.func_190926_b()) continue;
                itemStackList1.add(stack);
            }
            switch (upgrade) {
                case EXTRACT: {
                    itemStackList.addAll(itemStackList1);
                    this.extract.put(facing1, itemStackList);
                    continue block5;
                }
                case PULLING: {
                    itemStackList.addAll(itemStackList1);
                    this.pulling.put(facing1, itemStackList);
                    continue block5;
                }
                case EXT_PUL: {
                    this.extract.put(facing1, itemStackList1);
                    this.pulling.put(facing1, itemStackList);
                }
            }
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        Upgrade typeUpgrade = this.typeUpgradeMap.get(EnumFacing.field_82609_l[(int)var2]);
        Upgrade newTypeUpgrade = Upgrade.values()[(typeUpgrade.ordinal() + 1) % 4];
        this.typeUpgradeMap.replace(EnumFacing.field_82609_l[(int)var2], newTypeUpgrade);
        this.updateList();
    }
}

