/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.brewage.EnumBeerVariety;
import com.denfop.api.brewage.EnumTimeVariety;
import com.denfop.api.brewage.EnumWaterVariety;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBarrel;
import com.denfop.componets.Fluids;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBarrel
extends TileEntityInventory {
    private final Fluids fluids;
    private final Fluids.InternalFluidTank tank;
    EnumBeerVariety beerVariety;
    EnumTimeVariety timeVariety = EnumTimeVariety.BREW;
    EnumWaterVariety waterVariety;
    byte hops;
    byte wheat;
    int time;
    private int prev;

    public TileEntityBarrel() {
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankInsert("tank", 64000, Fluids.fluidPredicate(FluidRegistry.WATER));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.barrel;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBarrel.barrel;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.barrel.info"));
        tooltip.add(Localization.translate("iu.barrel.info1"));
        tooltip.add(Localization.translate("iu.barrel.info2"));
        if (this.field_145850_b != null) {
            tooltip.add(Localization.translate("iu.beer.recipe"));
            tooltip.add(Localization.translate("iu.beer.recipe1") + " " + this.hops);
            tooltip.add(Localization.translate("iu.beer.recipe2") + " " + this.wheat);
            tooltip.add(Localization.translate("iu.beer.recipe3") + " " + this.tank.getFluidAmount() / 1000);
            tooltip.add(Localization.translate("iu.beer.recipe4") + " " + new Timer(this.time / 20).getDisplay());
            if (this.waterVariety != null && this.timeVariety != null && this.beerVariety != null) {
                tooltip.add(Localization.translate("iu.beer.recipe5") + " " + this.waterVariety.name() + " " + this.beerVariety.name() + " " + this.timeVariety.name());
            }
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity()) {
            ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
            this.prev = this.tank.getFluidAmount();
            this.waterVariety = EnumWaterVariety.getVarietyFromLevelWater(this.tank.getFluidAmount() / 1000);
            this.time = 0;
            return true;
        }
        if (!this.func_145831_w().field_72995_K && stack.func_77973_b() == Items.field_151015_O && this.hops + this.wheat < 10) {
            this.wheat = (byte)(this.wheat + 1);
            stack.func_190918_g(1);
        }
        if (!this.func_145831_w().field_72995_K && stack.func_77973_b() == IUItem.hops && this.hops + this.wheat < 10) {
            this.hops = (byte)(this.hops + 1);
            stack.func_190918_g(1);
        }
        if (!this.func_145831_w().field_72995_K && this.hops + this.wheat == 10 && this.beerVariety == null) {
            this.beerVariety = EnumBeerVariety.getBeerVarietyFromRatio(this.wheat, this.hops);
        }
        if (!this.func_145831_w().field_72995_K && stack.func_77973_b() == IUItem.booze_mug && !ModUtils.nbt(stack).func_74764_b("beer") && this.waterVariety != null && this.beerVariety != null) {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            nbt.func_74757_a("beer", true);
            nbt.func_74774_a("amount", (byte)5);
            nbt.func_74774_a("waterVariety", (byte)this.waterVariety.ordinal());
            nbt.func_74774_a("timeVariety", (byte)this.timeVariety.ordinal());
            nbt.func_74774_a("beerVariety", (byte)this.beerVariety.ordinal());
            this.hops = 0;
            this.wheat = 0;
            this.time = 0;
            this.prev = 0;
            this.tank.drain(this.tank.getFluidAmount(), true);
            this.beerVariety = null;
            this.timeVariety = EnumTimeVariety.BREW;
            this.waterVariety = null;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.prev != this.tank.getFluidAmount()) {
            this.prev = this.tank.getFluidAmount();
            this.waterVariety = EnumWaterVariety.getVarietyFromLevelWater(this.prev / 1000);
            this.time = 0;
        }
        if (this.hops + this.wheat == 10 && this.waterVariety != null) {
            ++this.time;
            if (this.time % 1200 == 0) {
                this.timeVariety = EnumTimeVariety.getVarietyFromTime((double)this.time / 72000.0);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.prev = nbtTagCompound.func_74762_e("prev");
        this.timeVariety = EnumTimeVariety.values()[nbtTagCompound.func_74771_c("timeVariety")];
        if (nbtTagCompound.func_74767_n("hasBeerVariety")) {
            this.beerVariety = EnumBeerVariety.values()[nbtTagCompound.func_74771_c("hasBeerVariety")];
        }
        if (nbtTagCompound.func_74767_n("hasWaterVariety")) {
            this.waterVariety = EnumWaterVariety.values()[nbtTagCompound.func_74771_c("waterVariety")];
        }
        this.time = nbtTagCompound.func_74762_e("time");
        this.wheat = nbtTagCompound.func_74771_c("wheat");
        this.hops = nbtTagCompound.func_74771_c("hops");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74768_a("prev", this.prev);
        nbtTagCompound.func_74774_a("timeVariety", (byte)this.timeVariety.ordinal());
        if (this.beerVariety != null) {
            nbtTagCompound.func_74757_a("hasBeerVariety", true);
            nbtTagCompound.func_74774_a("beerVariety", (byte)this.beerVariety.ordinal());
        } else {
            nbtTagCompound.func_74757_a("hasBeerVariety", false);
        }
        if (this.waterVariety != null) {
            nbtTagCompound.func_74757_a("hasWaterVariety", true);
            nbtTagCompound.func_74774_a("waterVariety", (byte)this.waterVariety.ordinal());
        } else {
            nbtTagCompound.func_74757_a("hasWaterVariety", false);
        }
        nbtTagCompound.func_74768_a("time", this.time);
        nbtTagCompound.func_74774_a("wheat", this.wheat);
        nbtTagCompound.func_74774_a("hops", this.hops);
        return nbtTagCompound;
    }
}

