/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.container.ContainerCombinerSE;
import com.denfop.gui.GuiCombinerSE;
import com.denfop.invslot.InvSlotCombinerSEG;
import com.denfop.invslot.InvSlotGenCombinerSunarrium;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCombinerSEGenerators
extends TileEntityInventory
implements IUpgradableBlock {
    public final InvSlotCombinerSEG inputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotOutput outputSlot;
    public final ComponentBaseEnergy sunenergy;
    public final InvSlotGenCombinerSunarrium input;
    public final ItemStack itemstack = new ItemStack(IUItem.sunnarium, 1, 4);
    public double coef_day;
    public double coef_night;
    public double update_night;
    public int count;
    public List<Double> lst;
    public int coef = 0;
    public double generation;
    private boolean noSunWorld;
    private boolean skyIsVisible;
    private boolean sunIsUp;

    public TileEntityCombinerSEGenerators() {
        this.inputSlot = new InvSlotCombinerSEG(this);
        this.input = new InvSlotGenCombinerSunarrium(this);
        this.outputSlot = new InvSlotOutput(this, 9);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.sunenergy = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.SOLARIUM, this, 0.0, 1));
        this.lst = new ArrayList<Double>();
        this.lst.add(0.0);
        this.lst.add(0.0);
        this.lst.add(0.0);
        this.coef_day = 0.0;
        this.coef_night = 0.0;
        this.update_night = 0.0;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.combiner_se_generators;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public int func_70297_j_() {
        return 4;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.generation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlot.update();
        this.lst = this.input.coefday();
        this.coef_day = this.lst.get(0);
        this.coef_night = this.lst.get(1);
        this.update_night = this.lst.get(2);
        this.noSunWorld = this.field_145850_b.field_73011_w.func_177495_o();
        this.updateVisibility();
    }

    public void updateVisibility() {
        this.skyIsVisible = this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_151565_r() == MapColor.field_151660_b && !this.noSunWorld;
        this.sunIsUp = this.field_145850_b.func_72935_r();
    }

    public void energy(long tick) {
        double k = 0.0;
        if (this.sunIsUp) {
            if (tick <= 1000L) {
                k = 5.0;
            }
            if (tick > 1000L && tick <= 4000L) {
                k = 10.0;
            }
            if (tick > 4000L && tick <= 8000L) {
                k = 30.0;
            }
            if (tick > 8000L && tick <= 11000L) {
                k = 10.0;
            }
            if (tick > 11000L) {
                k = 5.0;
            }
            this.generation = k * (double)this.coef * (1.0 + this.coef_day);
            this.sunenergy.addEnergy(this.generation);
        }
        if (this.update_night > 0.0 && !this.sunIsUp) {
            double tick1 = tick - 12000L;
            if (tick1 <= 1000.0) {
                k = 5.0;
            }
            if (tick1 > 1000.0 && tick1 <= 4000.0) {
                k = 10.0;
            }
            if (tick1 > 4000.0 && tick1 <= 8000.0) {
                k = 30.0;
            }
            if (tick1 > 8000.0 && tick1 <= 11000.0) {
                k = 10.0;
            }
            if (tick1 > 11000.0) {
                k = 5.0;
            }
            this.generation = k * (double)this.coef * (this.update_night - 1.0) * (1.0 + this.coef_night);
            this.sunenergy.addEnergy(this.generation);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.field_145850_b.field_73011_w.getWorldTime() % 80L == 0L) {
            this.updateVisibility();
            this.inputSlot.update();
        }
        long tick = this.func_145831_w().field_73011_w.getWorldTime() % 24000L;
        this.generation = 0.0;
        if (this.skyIsVisible) {
            this.energy(tick);
            while (this.sunenergy.getEnergy() >= 9000.0 && this.outputSlot.add(this.itemstack)) {
                this.sunenergy.addEnergy(-9000.0);
            }
        }
        this.upgradeSlot.tickNoMark();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiCombinerSE(new ContainerCombinerSE(entityPlayer, this));
    }

    public ContainerCombinerSE getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCombinerSE(entityPlayer, this);
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemExtract);
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public String getInventoryName() {
        return null;
    }
}

