/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.Config;
import com.denfop.Localization;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerSolidMatter;
import com.denfop.gui.GuiSolidMatter;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class TileEntityMatterGenerator
extends TileEntityInventory
implements IUpgradableBlock {
    public final InvSlotOutput outputSlot;
    public final ItemStack itemstack;
    public final InvSlotUpgrade upgradeSlot;
    private final Energy energy;
    private final String name;
    private double progress;

    public TileEntityMatterGenerator(ItemStack itemstack, String name) {
        this.itemstack = itemstack;
        this.outputSlot = new InvSlotOutput(this, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.progress = 0.0;
        this.name = name;
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, Config.SolidMatterStorage, 10));
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(10.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        Energy energy;
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.matter_solid_work_info") + (int)Config.SolidMatterStorage);
        }
        if (!(energy = this.energy).getSourceDirs().isEmpty()) {
            tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
        } else if (!energy.getSinkDirs().isEmpty()) {
            tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74769_h("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74780_a("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean active = false;
        if (this.energy.getEnergy() > 0.0) {
            active = true;
            this.progress = this.energy.getEnergy() / this.energy.getCapacity();
            if (this.energy.getEnergy() >= this.energy.getCapacity() && this.outputSlot.add(this.itemstack)) {
                this.energy.useEnergy(this.energy.getCapacity());
                this.progress = 0.0;
            }
        }
        this.setActive(active);
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiSolidMatter getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiSolidMatter(new ContainerSolidMatter(entityPlayer, this));
    }

    public ContainerSolidMatter getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSolidMatter(entityPlayer, this);
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(TileEntityMatterGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemInput, UpgradableProperty.ItemExtract);
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public final float getChargeLevel() {
        return Math.min((float)this.energy.getEnergy() / (float)this.energy.getCapacity(), 1.0f);
    }

    public double getProgress() {
        return this.progress;
    }

    public int getMode() {
        return 0;
    }

    public String getInventoryName() {
        return this.name;
    }
}

