/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.reactors.CreativeReactor;
import com.denfop.api.reactors.EnumReactors;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.EnumTypeSecurity;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.ITypeRector;
import com.denfop.api.reactors.LogicCreativeFluidReactor;
import com.denfop.api.reactors.LogicCreativeGasReactor;
import com.denfop.api.reactors.LogicCreativeGraphiteReactor;
import com.denfop.api.reactors.LogicCreativeHeatReactor;
import com.denfop.api.reactors.LogicCreativeReactor;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerSimulationReactors;
import com.denfop.gui.GuiSimulationReactors;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotSimulatorReactor;
import com.denfop.items.reactors.ItemComponentVent;
import com.denfop.items.resource.ItemCraftingElements;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class TileEntitySimulatorReactor
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final InvSlotSimulatorReactor invSlot = new InvSlotSimulatorReactor(this, InvSlot.TypeItemSlot.INPUT, 80){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            if (TileEntitySimulatorReactor.this.reactors == null) {
                return false;
            }
            switch (TileEntitySimulatorReactor.this.reactors.getType()) {
                case FLUID: 
                case HIGH_SOLID: {
                    if (stack.func_77973_b() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.func_77973_b();
                        return TileEntitySimulatorReactor.this.level >= iReactorItem.getLevel();
                    }
                    return false;
                }
                case GAS_COOLING_FAST: {
                    if (stack.func_77973_b() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.func_77973_b();
                        return TileEntitySimulatorReactor.this.level >= iReactorItem.getLevel() && (iReactorItem.getType() != EnumTypeComponent.HEAT_SINK || stack.func_77973_b() instanceof ItemComponentVent);
                    }
                    return false;
                }
                case GRAPHITE_FLUID: {
                    if (stack.func_77973_b() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.func_77973_b();
                        return TileEntitySimulatorReactor.this.level >= iReactorItem.getLevel() && iReactorItem.getType() != EnumTypeComponent.HEAT_EXCHANGER;
                    }
                    return false;
                }
            }
            return false;
        }

        @Override
        public void put(int index, ItemStack content) {
            super.put(index, content);
            TileEntitySimulatorReactor.this.needUpdate = true;
            switch (TileEntitySimulatorReactor.this.reactors.getType()) {
                case FLUID: {
                    TileEntitySimulatorReactor.this.logicReactor = new LogicCreativeFluidReactor(TileEntitySimulatorReactor.this.reactor);
                    break;
                }
                case GAS_COOLING_FAST: {
                    TileEntitySimulatorReactor.this.logicReactor = new LogicCreativeGasReactor(TileEntitySimulatorReactor.this.reactor);
                    break;
                }
                case GRAPHITE_FLUID: {
                    TileEntitySimulatorReactor.this.logicReactor = new LogicCreativeGraphiteReactor(TileEntitySimulatorReactor.this.reactor);
                    break;
                }
                case HIGH_SOLID: {
                    TileEntitySimulatorReactor.this.logicReactor = new LogicCreativeHeatReactor(TileEntitySimulatorReactor.this.reactor);
                }
            }
        }
    };
    public final InvSlot scheduleSlot;
    public int type = -1;
    public int level = -1;
    public EnumReactors reactors;
    public CreativeReactor reactor = new CreativeReactor(this.reactors, this.invSlot);
    public boolean work;
    public boolean explode;
    public LogicCreativeReactor logicReactor;
    public double output;
    public double rad;
    public double heat;
    public EnumTypeSecurity security;
    private boolean needUpdate = false;

    public TileEntitySimulatorReactor() {
        this.scheduleSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof ItemCraftingElements && stack.func_77952_i() == 143;
            }

            @Override
            public int getStackSizeLimit() {
                return 1;
            }
        };
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.explode = customPacketBuffer.readBoolean();
        this.rad = customPacketBuffer.readDouble();
        this.output = customPacketBuffer.readDouble();
        this.heat = customPacketBuffer.readDouble();
        this.security = EnumTypeSecurity.values()[customPacketBuffer.readInt()];
        this.type = customPacketBuffer.readInt();
        this.level = customPacketBuffer.readInt();
        try {
            this.reactor.timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        this.type = customPacketBuffer.readInt();
        this.level = customPacketBuffer.readInt();
        if (this.level != -1 && this.type != -1) {
            this.reactors = EnumReactors.values()[(this.type - 1) * 4 + (this.level - 1)];
            this.reactor.level = this.level;
            this.invSlot.clear();
            this.reactor.reset(this.reactors);
            this.size_inventory = 0;
            for (InvSlot invSlot : this.invSlots) {
                this.size_inventory += invSlot.size();
            }
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        customPacketBuffer.writeInt(this.type);
        customPacketBuffer.writeInt(this.level);
        return customPacketBuffer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.simulation_reactors;
    }

    public ContainerSimulationReactors getGuiContainer(EntityPlayer var1) {
        return new ContainerSimulationReactors(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiSimulationReactors(this.getGuiContainer(var1));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74768_a("type", this.type);
        nbtTagCompound.func_74768_a("level", this.level);
        nbtTagCompound.func_74757_a("work", this.work);
        nbtTagCompound.func_74757_a("explode", this.explode);
        if (this.reactors != null) {
            nbtTagCompound.func_74768_a("reactors", this.reactors.ordinal());
        }
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.type = nbtTagCompound.func_74762_e("type");
        this.level = nbtTagCompound.func_74762_e("level");
        this.reactors = EnumReactors.values()[nbtTagCompound.func_74762_e("reactors")];
        this.work = nbtTagCompound.func_74767_n("work");
        this.explode = nbtTagCompound.func_74767_n("explode");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeBoolean(this.explode);
        customPacketBuffer.writeDouble(this.rad);
        customPacketBuffer.writeDouble(this.output);
        customPacketBuffer.writeDouble(this.heat);
        customPacketBuffer.writeInt(this.security.ordinal());
        customPacketBuffer.writeInt(this.type);
        customPacketBuffer.writeInt(this.level);
        this.reactor.timer.writeBuffer(customPacketBuffer);
        return customPacketBuffer;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate && this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L && this.reactors != null && !this.scheduleSlot.isEmpty()) {
            this.needUpdate = false;
            ItemStack stack = this.scheduleSlot.get();
            NBTTagCompound nbt = ModUtils.nbt(stack);
            List<ItemStack> infoStack = this.logicReactor.getInfoStack();
            NBTTagList stacks = new NBTTagList();
            for (ItemStack stack1 : infoStack) {
                NBTTagCompound contentTag = new NBTTagCompound();
                stack1.func_77955_b(contentTag);
                stacks.func_74742_a((NBTBase)contentTag);
            }
            nbt.func_74768_a("type", this.type);
            nbt.func_74768_a("level", this.level);
            nbt.func_74778_a("name", this.reactors.getNameReactor().toLowerCase());
            nbt.func_74768_a("generation", (int)((double)this.logicReactor.getGeneration() * (this.reactors.getType() == ITypeRector.GAS_COOLING_FAST ? 1.175 : 1.0)));
            nbt.func_74768_a("rad", this.logicReactor.getRadGeneration());
            nbt.func_74782_a("Items", (NBTBase)stacks);
            for (int y = 0; y < this.reactors.getHeight(); ++y) {
                for (int x = 0; x < this.reactors.getWidth(); ++x) {
                    NBTTagCompound tag = new NBTTagCompound();
                    ItemStack stack1 = this.reactor.getItemAt(x, y);
                    if (stack1.func_190926_b()) {
                        tag.func_74757_a("empty", true);
                        nbt.func_74782_a(String.valueOf(y * this.reactors.getWidth() + x), (NBTBase)tag);
                        continue;
                    }
                    tag.func_74757_a("empty", false);
                    for (int i = 0; i < infoStack.size(); ++i) {
                        if (!infoStack.get(i).func_77969_a(stack1)) continue;
                        tag.func_74768_a("index", i);
                        break;
                    }
                    nbt.func_74782_a(String.valueOf(y * this.reactors.getWidth() + x), (NBTBase)tag);
                }
            }
        }
        if (this.work && !this.explode && this.reactors != null) {
            this.logicReactor.onTick();
            this.reactor.tick(this.logicReactor.getMaxHeat());
            this.explode = this.reactor.explode;
            this.output = this.reactor.getOutput();
            this.rad = this.reactor.getRad();
            this.heat = this.reactor.getHeat();
            this.security = this.reactor.getSecurity();
        } else {
            this.output = 0.0;
            this.rad = 0.0;
            this.heat = 0.0;
            if (this.security != EnumTypeSecurity.NONE) {
                this.reactor.setTime(EnumTypeSecurity.STABLE);
            }
            this.security = EnumTypeSecurity.NONE;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K && this.type != -1 && this.level != -1) {
            this.reactors = EnumReactors.values()[(this.type - 1) * 4 + (this.level - 1)];
            this.invSlot.clear();
            this.reactor.reset(this.reactors);
            this.reactor.level = this.level;
            this.work = false;
            this.explode = false;
            this.reactor.setTime(EnumTypeSecurity.STABLE);
            switch (this.reactors.getType()) {
                case FLUID: {
                    this.logicReactor = new LogicCreativeFluidReactor(this.reactor);
                    break;
                }
                case GAS_COOLING_FAST: {
                    this.logicReactor = new LogicCreativeGasReactor(this.reactor);
                    break;
                }
                case GRAPHITE_FLUID: {
                    this.logicReactor = new LogicCreativeGraphiteReactor(this.reactor);
                    break;
                }
                case HIGH_SOLID: {
                    this.logicReactor = new LogicCreativeHeatReactor(this.reactor);
                }
            }
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 < 0.0) {
            this.level = (int)(var2 *= -1.0);
        } else if (var2 >= 1.0) {
            this.type = (int)var2;
        } else if (var2 < 1.0) {
            this.work = !this.work;
            this.explode = false;
            this.reactor.explode = false;
            this.reactor.setTime(EnumTypeSecurity.STABLE);
            return;
        }
        if (this.level != -1 && this.type != -1) {
            this.reactors = EnumReactors.values()[(this.type - 1) * 4 + (this.level - 1)];
            this.invSlot.clear();
            this.reactor.reset(this.reactors);
            this.size_inventory = 0;
            for (InvSlot invSlot : this.invSlots) {
                this.size_inventory += invSlot.size();
            }
            this.work = false;
            this.explode = false;
            var1.func_71053_j();
            this.reactor.setTime(EnumTypeSecurity.STABLE);
            this.reactor.level = this.level;
            switch (this.reactors.getType()) {
                case FLUID: {
                    this.logicReactor = new LogicCreativeFluidReactor(this.reactor);
                    break;
                }
                case GAS_COOLING_FAST: {
                    this.logicReactor = new LogicCreativeGasReactor(this.reactor);
                    break;
                }
                case GRAPHITE_FLUID: {
                    this.logicReactor = new LogicCreativeGraphiteReactor(this.reactor);
                    break;
                }
                case HIGH_SOLID: {
                    this.logicReactor = new LogicCreativeHeatReactor(this.reactor);
                }
            }
        }
    }
}

