/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockStrongAnvil;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.invslot.InvSlot;
import com.denfop.items.resource.ItemRawMetals;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class TileEntityStrongAnvil
extends TileEntityInventory
implements IUpdateTick,
IHasRecipe,
IAudioFixer {
    private static final List<AxisAlignedBB> aabbs = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, 1.0, 2.0));
    private static final List<AxisAlignedBB> aabbs1 = Collections.singletonList(new AxisAlignedBB(-1.0, 0.0, 0.0, 2.0, 1.0, 1.0));
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes(this, "strong_anvil", this){

        @Override
        public boolean accepts(ItemStack itemStack, int index) {
            if (index == 4) {
                return super.accepts(itemStack, 0);
            }
            return false;
        }
    };
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public int progress = 0;
    public MachineRecipe output;
    public Map<UUID, Double> data;

    public TileEntityStrongAnvil() {
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addanvil(String input, String output) {
        ItemStack stack = ((ItemStack)OreDictionary.getOres((String)output).get(0)).func_77946_l();
        stack.func_190920_e(2);
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("strong_anvil", new BaseMachineRecipe(new Input(input1.getInput(input, 1)), new RecipeOutput(null, stack)));
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing) && capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        if (this.facing != 4 && this.facing != 5) {
            return aabbs1;
        }
        return aabbs;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("primitive_rcm.info"));
        tooltip.add(Localization.translate("primitive_use.info") + IUItem.ObsidianForgeHammer.getItemStackDisplayName());
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.strong_anvil;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockStrongAnvil.block_strong_anvil;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.STRONG_ANVIL);
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.put(0, ItemStack.field_190927_a);
        }
        if (name.equals("slot2")) {
            this.outputSlot.put(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == IUItem.ObsidianForgeHammer && this.output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items.get(0))) {
            this.progress += 10;
            this.getCooldownTracker().setTick(10);
            if (!this.func_145831_w().field_72995_K) {
                this.initiate(0);
            }
            this.progress += (int)(this.data.getOrDefault(player.func_110124_au(), 0.0) / 2.5);
            if (this.progress >= 100) {
                this.progress = 0;
                player.func_184611_a(hand, stack.func_77973_b().getContainerItem(stack));
                if (!this.func_145831_w().field_72995_K) {
                    PrimitiveHandler.addExperience(EnumPrimitive.STRONG_ANVIL, 0.5, player.func_110124_au());
                }
                ItemStack stack1 = this.output.getRecipe().output.items.get(0).func_77946_l();
                double chance = WorldBaseGen.random.nextDouble();
                if (chance < 0.65) {
                    stack1.func_190920_e(1);
                } else if (chance < 0.9750000000000001) {
                    stack1.func_190920_e(2);
                } else {
                    stack1.func_190920_e(3);
                }
                this.outputSlot.add(stack1);
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (this.inputSlotA.isEmpty() || this.outputSlot.get().func_190916_E() >= 64) {
                    this.output = null;
                }
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                }
            }
            return this.func_145831_w().field_72995_K;
        }
        if (!stack.func_190926_b()) {
            if (this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.accepts(stack, 4)) {
                this.inputSlotA.put(0, stack.func_77946_l());
                stack.func_190920_e(0);
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
            if (!this.inputSlotA.get(0).func_190926_b() && this.inputSlotA.get(0).func_77969_a(stack)) {
                int minCount = 64 - this.inputSlotA.get(0).func_190916_E();
                minCount = Math.min(stack.func_190916_E(), minCount);
                this.inputSlotA.get(0).func_190917_f(minCount);
                stack.func_190917_f(-minCount);
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
        } else {
            if (!this.outputSlot.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.outputSlot.get(), player);
                }
                this.outputSlot.put(0, ItemStack.field_190927_a);
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.field_145850_b.field_72995_K) {
                    ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.inputSlotA.get(), player);
                }
                this.inputSlotA.put(0, ItemStack.field_190927_a);
                this.output = null;
                if (!this.field_145850_b.field_72995_K) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void init() {
        for (int i = 0; i < ItemRawMetals.Types.values().length; ++i) {
            String s = ItemRawMetals.Types.values()[i].func_176610_l();
            if (s.equals("uranium")) continue;
            s = s.substring(0, 1).toUpperCase() + s.substring(1);
            TileEntityStrongAnvil.addanvil("raw" + s, "crushed" + s);
        }
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return EnumTypeAudio.ON;
    }

    @Override
    public void setType(EnumTypeAudio type) {
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.molot.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (soundEvent == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 0.2f, 1.0f);
        }
    }

    @Override
    public boolean getEnable() {
        return true;
    }
}

