/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.tesseract.Channel;
import com.denfop.api.tesseract.ITesseract;
import com.denfop.api.tesseract.TesseractSystem;
import com.denfop.api.tesseract.TypeChannel;
import com.denfop.api.tesseract.TypeMode;
import com.denfop.api.tesseract.event.EventAdderChannel;
import com.denfop.api.tesseract.event.EventLoadTesseract;
import com.denfop.api.tesseract.event.EventRemoverChannel;
import com.denfop.api.tesseract.event.EventUnLoadTesseract;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerTesseract;
import com.denfop.gui.GuiTesseract;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTesseract
extends TileEntityInventory
implements IUpdatableTileEvent,
ITesseract {
    private final Energy energy;
    private final Fluids fluids;
    private final Fluids.InternalFluidTank tank;
    private final InvSlot slot;
    public Channel channel;
    List<Channel> channelList = new ArrayList<Channel>();
    List<Channel> publicChannel = new ArrayList<Channel>();

    public TileEntityTesseract() {
        this.energy = this.addComponent(new Energy(this, 2.147483647E9, ModUtils.allFacings, ModUtils.allFacings, 14));
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTank("tank", 64000);
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT_OUTPUT, 18);
        this.getComponentPrivate().setActivate(true);
    }

    @Override
    public World getLevel() {
        return this.field_145850_b;
    }

    public ContainerTesseract getGuiContainer(EntityPlayer var1) {
        return new ContainerTesseract(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiTesseract(this.getGuiContainer(var1));
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.getChannels().size());
        customPacketBuffer.writeInt(this.publicChannel.size());
        try {
            EncoderHandler.encode(customPacketBuffer, this.getSlotItem());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Channel channel : this.getChannels()) {
            try {
                EncoderHandler.encode(customPacketBuffer, channel);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.publicChannel = TesseractSystem.instance.getPublicChannels(this.func_145831_w());
        for (Channel channel : this.publicChannel) {
            try {
                EncoderHandler.encode(customPacketBuffer, channel);
                EncoderHandler.encode(customPacketBuffer, channel.getPos());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        customPacketBuffer.writeBoolean(this.channel != null);
        try {
            EncoderHandler.encode(customPacketBuffer, this.channel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadTesseract(this, this.func_145831_w()));
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EventUnLoadTesseract(this, this.func_145831_w()));
        }
        super.onUnloaded();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        ArrayList<Channel> channels = new ArrayList<Channel>(this.getChannels());
        nbtTagCompound.func_74768_a("size", channels.size());
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = (Channel)channels.get(i);
            nbtTagCompound.func_74782_a("channel_" + i, (NBTBase)channel.writeNBT());
        }
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        int size = nbtTagCompound.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            Channel channel = new Channel(nbtTagCompound.func_74775_l("channel_" + i));
            channel.setTesseract(this);
            this.channelList.add(channel);
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.tesseract;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        int i;
        super.readContainerPacket(customPacketBuffer);
        this.channelList.clear();
        int size = customPacketBuffer.readInt();
        int size1 = customPacketBuffer.readInt();
        try {
            InvSlot invSlot = (InvSlot)DecoderHandler.decode(customPacketBuffer);
            for (int i2 = 0; i2 < invSlot.size(); ++i2) {
                this.slot.put(i2, invSlot.get(i2));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (i = 0; i < size; ++i) {
            try {
                Channel channel = (Channel)DecoderHandler.decode(customPacketBuffer);
                channel.setTesseract(this);
                this.channelList.add(channel);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.publicChannel.clear();
        for (i = 0; i < size1; ++i) {
            try {
                Channel channel = (Channel)DecoderHandler.decode(customPacketBuffer);
                BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
                ITesseract tesseract = (ITesseract)this.field_145850_b.func_175625_s(pos);
                channel.setTesseract(tesseract);
                this.publicChannel.add(channel);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        boolean hasChannel = customPacketBuffer.readBoolean();
        if (hasChannel) {
            try {
                this.channel = (Channel)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.channel != null) {
            this.channel.setTesseract(this);
        }
    }

    @Override
    public Channel getChannel(int channel) {
        return this.getChannels().get(channel);
    }

    @Override
    public List<Channel> getChannels() {
        return this.channelList;
    }

    @Override
    public String getPlayer() {
        return this.getComponentPrivate().getPlayers().get(0);
    }

    @Override
    public Energy getEnergy() {
        return this.energy;
    }

    @Override
    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    @Override
    public InvSlot getSlotItem() {
        return this.slot;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        switch ((int)var2) {
            case 1: {
                int maxValue1 = 0;
                ArrayList<Integer> integerList1 = new ArrayList<Integer>();
                for (Channel channel1 : this.getChannels()) {
                    integerList1.add(channel1.getChannel());
                }
                while (integerList1.contains(maxValue1)) {
                    ++maxValue1;
                }
                this.channel = new Channel(maxValue1, this, TypeMode.NONE, TypeChannel.NONE, false);
                this.channelList.add(this.channel);
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.func_145831_w()));
                break;
            }
            case 2: {
                int maxValue2 = 0;
                ArrayList<Integer> integerList2 = new ArrayList<Integer>();
                for (Channel channel1 : this.getChannels()) {
                    integerList2.add(channel1.getChannel());
                }
                while (integerList2.contains(maxValue2) || maxValue2 < this.channel.getChannel()) {
                    ++maxValue2;
                }
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.func_145831_w()));
                this.channelList.remove(this.channel);
                this.channel = new Channel(maxValue2, this, this.channel.getMode(), this.channel.getTypeChannel(), this.channel.isPrivate());
                this.channelList.add(this.channel);
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.func_145831_w()));
                break;
            }
            case 3: {
                int maxValue3 = this.channel.getChannel();
                ArrayList<Integer> integerList3 = new ArrayList<Integer>();
                for (Channel channel1 : this.getChannels()) {
                    integerList3.add(channel1.getChannel());
                }
                while (maxValue3 != -1 && integerList3.contains(maxValue3)) {
                    --maxValue3;
                }
                if (maxValue3 == -1) break;
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.func_145831_w()));
                this.channelList.remove(this.channel);
                this.channel = new Channel(maxValue3, this, this.channel.getMode(), this.channel.getTypeChannel(), this.channel.isPrivate());
                this.channelList.add(this.channel);
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.func_145831_w()));
                break;
            }
            case 4: {
                var2 -= 4.0;
                var2 *= 10.0;
                var2 = Math.round(var2);
                int mode4 = (int)var2 % 2;
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.func_145831_w()));
                if (mode4 == 0) {
                    switch (this.channel.getMode()) {
                        case INPUT: {
                            this.channel.setMode(TypeMode.NONE);
                            break;
                        }
                        case OUTPUT: {
                            this.channel.setMode(TypeMode.INOUT);
                            break;
                        }
                        case NONE: {
                            this.channel.setMode(TypeMode.INPUT);
                            break;
                        }
                        case INOUT: {
                            this.channel.setMode(TypeMode.OUTPUT);
                        }
                    }
                } else {
                    switch (this.channel.getMode()) {
                        case OUTPUT: {
                            this.channel.setMode(TypeMode.NONE);
                            break;
                        }
                        case INPUT: {
                            this.channel.setMode(TypeMode.INOUT);
                            break;
                        }
                        case NONE: {
                            this.channel.setMode(TypeMode.OUTPUT);
                            break;
                        }
                        case INOUT: {
                            this.channel.setMode(TypeMode.INPUT);
                        }
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.func_145831_w()));
                break;
            }
            case 5: {
                var2 -= 5.0;
                var2 *= 10.0;
                var2 = Math.round(var2);
                int mode5 = (int)var2 % 3;
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.func_145831_w()));
                switch (mode5) {
                    case 0: {
                        this.channel.setTypeChannel(this.channel.getTypeChannel() == TypeChannel.ENERGY ? TypeChannel.NONE : TypeChannel.ENERGY);
                        break;
                    }
                    case 1: {
                        this.channel.setTypeChannel(this.channel.getTypeChannel() == TypeChannel.FLUID ? TypeChannel.NONE : TypeChannel.FLUID);
                        break;
                    }
                    case 2: {
                        this.channel.setTypeChannel(this.channel.getTypeChannel() == TypeChannel.ITEM ? TypeChannel.NONE : TypeChannel.ITEM);
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.func_145831_w()));
                break;
            }
            case 6: {
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.func_145831_w()));
                this.channel.setPrivate(!this.channel.isPrivate());
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.func_145831_w()));
                break;
            }
            case 7: {
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.func_145831_w()));
                this.channel.setActive(!this.channel.isActive());
                MinecraftForge.EVENT_BUS.post((Event)new EventAdderChannel(this.channel, this.func_145831_w()));
                break;
            }
            case 8: {
                this.channel = null;
                break;
            }
            case 9: {
                MinecraftForge.EVENT_BUS.post((Event)new EventRemoverChannel(this.channel, this.func_145831_w()));
                this.channelList.remove(this.channel);
                this.channel = null;
                break;
            }
            case 10: {
                if ((var2 -= 10.0) == 0.0) {
                    this.channel = this.getChannels().get(0);
                    break;
                }
                int col = (int)(var2 * 10.0);
                var2 *= 10.0;
                var2 -= (double)col;
                for (int i = 0; i < col; ++i) {
                    var2 *= 10.0;
                }
                var2 = Math.round(var2);
                ArrayList<Channel> channels = new ArrayList<Channel>(this.getChannels());
                this.channel = (Channel)channels.get((int)(var2 %= (double)channels.size()));
            }
        }
    }

    public List<Channel> getPublicChannel() {
        return this.publicChannel;
    }
}

