/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerWirelessControllerGraphiteReactors;
import com.denfop.gui.GuiWirelessControllerGraphiteReactors;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemReactorData;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.reactors.graphite.IGraphiteController;
import com.denfop.tiles.reactors.graphite.graphite_controller.TileEntityGraphiteController;
import com.denfop.utils.ModUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileEntityWirelessGraphiteController
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final InvSlot invslot;
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public List<TileEntityGraphiteController> graphiteControllers = new LinkedList<TileEntityGraphiteController>();
    public TileMultiBlockBase tileMultiBlockBase = null;

    public TileEntityWirelessGraphiteController() {
        this.invslot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                TileEntityWirelessGraphiteController.this.updateList();
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.func_77973_b() instanceof ItemReactorData)) {
                    return false;
                }
                NBTTagCompound nbt = ModUtils.nbt(stack);
                return !nbt.func_74779_i("name").isEmpty();
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    public ContainerWirelessControllerGraphiteReactors getGuiContainer(EntityPlayer var1) {
        return new ContainerWirelessControllerGraphiteReactors(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiWirelessControllerGraphiteReactors(this.getGuiContainer(var1));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.wireless_controller_graphite_reactors;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.graphiteControllers.clear();
        this.itemStacks.clear();
        this.tileMultiBlockBase = null;
        NBTTagCompound nbt = ModUtils.nbt(this.invslot.get(0));
        BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
        if (tileEntity instanceof TileMultiBlockBase && tileEntity instanceof IGraphiteReactor) {
            this.tileMultiBlockBase = (TileMultiBlockBase)tileEntity;
            if (this.tileMultiBlockBase.isFull()) {
                List<BlockPos> pos1 = this.tileMultiBlockBase.getMultiBlockStucture().getPosFromClass(this.tileMultiBlockBase.getFacing(), this.tileMultiBlockBase.getBlockPos(), IGraphiteController.class);
                for (BlockPos pos2 : pos1) {
                    TileEntity tileEntity1 = this.func_145831_w().func_175625_s(pos2);
                    if (tileEntity1 == null) continue;
                    this.graphiteControllers.add((TileEntityGraphiteController)tileEntity1);
                    this.itemStacks.add(((TileEntityGraphiteController)tileEntity1).getPickBlock(null, null));
                }
            }
        } else {
            this.itemStacks.add(ItemStack.field_190927_a);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        if (!this.func_145831_w().field_72995_K) {
            this.updateList();
        }
    }

    public void updateList() {
        this.itemStacks.clear();
        this.graphiteControllers.clear();
        this.itemStacks.clear();
        this.tileMultiBlockBase = null;
        NBTTagCompound nbt = ModUtils.nbt(this.invslot.get(0));
        BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
        if (tileEntity instanceof TileMultiBlockBase && tileEntity instanceof IGraphiteReactor) {
            this.tileMultiBlockBase = (TileMultiBlockBase)tileEntity;
            if (this.tileMultiBlockBase.isFull()) {
                List<BlockPos> pos1 = this.tileMultiBlockBase.getMultiBlockStucture().getPosFromClass(this.tileMultiBlockBase.getFacing(), this.tileMultiBlockBase.getBlockPos(), IGraphiteController.class);
                for (BlockPos pos2 : pos1) {
                    TileEntity tileEntity1 = this.func_145831_w().func_175625_s(pos2);
                    if (tileEntity1 == null) continue;
                    this.graphiteControllers.add((TileEntityGraphiteController)tileEntity1);
                    this.itemStacks.add(((TileEntityGraphiteController)tileEntity1).getPickBlock(null, null));
                }
            }
        } else {
            this.itemStacks.add(ItemStack.field_190927_a);
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (!this.invslot.get(0).func_190926_b() && this.tileMultiBlockBase != null) {
            TileEntityGraphiteController controller;
            if ((double)this.graphiteControllers.size() < var2) {
                this.graphiteControllers.clear();
                if (this.tileMultiBlockBase.isFull()) {
                    List<BlockPos> pos1 = this.tileMultiBlockBase.getMultiBlockStucture().getPosFromClass(this.tileMultiBlockBase.getFacing(), this.tileMultiBlockBase.getBlockPos(), IGraphiteController.class);
                    for (BlockPos pos2 : pos1) {
                        TileEntity tileEntity1 = this.func_145831_w().func_175625_s(pos2);
                        if (tileEntity1 == null) continue;
                        this.graphiteControllers.add((TileEntityGraphiteController)tileEntity1);
                    }
                }
            }
            if ((controller = this.graphiteControllers.get((int)var2)) != null && controller.getMain() != null && controller.getMain().isFull() && !controller.func_145837_r()) {
                controller.onActivated(var1, var1.func_184600_cs(), EnumFacing.NORTH, 0.0f, 0.0f, 0.0f);
            }
        }
    }
}

