/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBlockLimiter;
import com.denfop.gui.GuiBlockLimiter;
import com.denfop.invslot.InvSlotLimiter;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileLimiter
extends TileEntityInventory
implements IUpdatableTileEvent,
IAudioFixer {
    private final Energy energy;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio;
    public boolean sound = true;
    public InvSlotLimiter slot;
    public double max_value;

    public TileLimiter() {
        this.energy = this.addComponent(new Energy((TileEntityInventory)this, Double.MAX_VALUE, Arrays.asList(EnumFacing.field_82609_l).stream().filter(facing -> facing != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()), 14, 0, false));
        this.energy.setLimit(true);
        this.slot = new InvSlotLimiter(this);
        this.valuesAudio = EnumTypeAudio.values();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.max_value = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.max_value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.limiter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.pen.getSoundEvent();
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            this.func_145831_w().func_184133_a(null, this.field_174879_c, EnumSound.InterruptOne.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.slot.isEmpty()) {
            this.setTier(0);
        } else {
            this.setTier(this.slot.get().func_77952_i() - 205);
        }
        this.energy.setDirections(Arrays.asList(EnumFacing.field_82609_l).stream().filter(facing -> facing != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
        this.energy.setCapacity(this.energy.limit_amount);
    }

    public void setTier(int tier) {
        this.energy.setSourceTier(tier);
        if (tier != 0) {
            this.energy.setCapacity(EnergyNetGlobal.instance.getPowerFromTier(tier));
        } else {
            this.energy.setCapacity(0.0);
            this.energy.limit_amount = 0.0;
        }
        this.max_value = tier != 0 ? EnergyNetGlobal.instance.getPowerFromTier(tier) : 0.0;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("max_value", this.max_value);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.max_value = nbtTagCompound.func_74769_h("max_value");
    }

    public Energy getEnergy() {
        return this.energy;
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        this.energy.limit_amount += i;
        this.energy.limit_amount = (int)Math.min(this.max_value, this.energy.limit_amount);
        this.energy.limit_amount = (int)Math.max(0.0, this.energy.limit_amount);
        this.energy.setDirections(Arrays.asList(EnumFacing.field_82609_l).stream().filter(facing -> facing != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
        this.energy.setCapacity(this.energy.limit_amount);
        this.initiate(2);
        this.initiate(0);
    }

    public ContainerBlockLimiter getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBlockLimiter(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiBlockLimiter(this.getGuiContainer(entityPlayer));
    }
}

