/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.Config;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMolecular;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBaseMolecular;
import com.denfop.gui.GuiMolecularTransformer;
import com.denfop.items.resource.ItemNuclearResource;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.IIsMolecular;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMolecularTransformer
extends TileElectricMachine
implements IUpdatableTileEvent,
IUpdateTick,
IHasRecipe,
IIsMolecular {
    public double[] energyShare;
    public boolean queue = false;
    public byte redstoneMode = 0;
    public InvSlotRecipes[] inputSlot;
    public MachineRecipe[] output;
    public double perenergy;
    public double differenceenergy;
    public ItemStack[] output_stack = new ItemStack[4];
    public int maxAmount = 1;
    public InvSlotOutput[] outputSlot = new InvSlotOutput[4];
    public double[] energySlots;
    public double[] maxEnergySlots;
    protected double[] guiProgress;
    protected double[] size_recipe;
    int index;
    int indexModel = 0;
    int tick = 0;
    private boolean need = false;
    @SideOnly(value=Side.CLIENT)
    private IBakedModel[] bakedModel;
    @SideOnly(value=Side.CLIENT)
    private IBakedModel[] transformedModel;

    public TileMolecularTransformer() {
        super(0.0, 14, 0);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 0.0, 14).addManagedSlot(this.dischargeSlot));
        this.inputSlot = new InvSlotRecipes[4];
        this.output = new MachineRecipe[4];
        this.energySlots = new double[4];
        this.guiProgress = new double[4];
        this.energyShare = new double[4];
        this.maxEnergySlots = new double[4];
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.bakedModel = new IBakedModel[4];
            this.transformedModel = new IBakedModel[4];
        }
        this.size_recipe = new double[4];
        for (int i = 0; i < 4; ++i) {
            this.output_stack[i] = new ItemStack(Items.field_190931_a);
            this.inputSlot[i] = new InvSlotRecipes(this, "molecular", this){

                @Override
                public boolean accepts(ItemStack itemStack, int index) {
                    return index < TileMolecularTransformer.this.maxAmount;
                }
            };
            this.inputSlot[i].setIndex(i);
            this.outputSlot[i] = new InvSlotOutput(this, 1);
        }
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addrecipe(ItemStack stack, ItemStack stack1, double energy) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", energy);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("molecular", new BaseMachineRecipe(new Input(input.getInput(stack)), new RecipeOutput(nbt, stack1)));
    }

    public static void addrecipe(String stack, ItemStack stack1, double energy) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", energy);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("molecular", new BaseMachineRecipe(new Input(input.getInput(stack)), new RecipeOutput(nbt, stack1)));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockMolecular.molecular;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blockmolecular;
    }

    public ItemStack getOutput_stack() {
        return this.output_stack[0];
    }

    @Override
    public void init() {
        TileMolecularTransformer.addrecipe(new ItemStack(Items.field_151144_bL, 1, 1), new ItemStack(Items.field_151156_bN, 1), Config.molecular1);
        TileMolecularTransformer.addrecipe(IUItem.nuclear_res.getItemStack(ItemNuclearResource.Types.plutonium), new ItemStack(IUItem.proton, 1), Config.molecular3);
        TileMolecularTransformer.addrecipe("ingotSpinel", new ItemStack(IUItem.iuingot, 1, 5), 2500000.0);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.photoniy), new ItemStack(IUItem.photoniy_ingot), Config.molecular5);
        TileMolecularTransformer.addrecipe(new ItemStack(Blocks.field_150424_aL), new ItemStack(Items.field_151016_H, 2), Config.molecular6);
        TileMolecularTransformer.addrecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150351_n, 1), Config.molecular7);
        TileMolecularTransformer.addrecipe("ingotIridium", new ItemStack(IUItem.core, 1, 0), Config.molecular17);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 0), new ItemStack(IUItem.core, 1, 1), Config.molecular18);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 1), new ItemStack(IUItem.core, 1, 2), Config.molecular19);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 2), new ItemStack(IUItem.core, 1, 3), Config.molecular20);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 3), new ItemStack(IUItem.core, 1, 4), Config.molecular21);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 4), new ItemStack(IUItem.core, 1, 5), Config.molecular22);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 5), new ItemStack(IUItem.core, 1, 6), Config.molecular23);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 6), new ItemStack(IUItem.core, 1, 7), Config.molecular24);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 7), new ItemStack(IUItem.core, 1, 8), Config.molecular25);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 8), new ItemStack(IUItem.core, 1, 9), Config.molecular26);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 9), new ItemStack(IUItem.core, 1, 10), Config.molecular38);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 10), new ItemStack(IUItem.core, 1, 11), Config.molecular39);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 11), new ItemStack(IUItem.core, 1, 12), Config.molecular40);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 12), new ItemStack(IUItem.core, 1, 13), Config.molecular41);
        TileMolecularTransformer.addrecipe(new ItemStack((Item)IUItem.crafting_elements, 8, 649), new ItemStack((Item)IUItem.crafting_elements, 1, 645), 2.0E7);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 1), new ItemStack(IUItem.lens, 1, 5), Config.molecular27);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 2), new ItemStack(IUItem.lens, 1, 6), Config.molecular28);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 3), new ItemStack(IUItem.lens, 1, 2), Config.molecular29);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 4), new ItemStack(IUItem.lens, 1, 4), Config.molecular30);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 5), new ItemStack(IUItem.lens, 1, 1), Config.molecular31);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 6), new ItemStack(IUItem.lens, 1, 3), Config.molecular32);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 7), new ItemStack(IUItem.lens, 1), Config.molecular33);
        TileMolecularTransformer.addrecipe(new ItemStack(Items.field_151042_j, 1, 0), IUItem.iridiumOre, 7500000.0);
        TileMolecularTransformer.addrecipe(IUItem.iridiumOre, new ItemStack(IUItem.photoniy), Config.molecular34);
    }

    public List<Double> getTime(int i) {
        double dif = this.energyShare[i];
        return ModUtils.Time((1.0 - this.guiProgress[i]) * this.maxEnergySlots[i] / (dif * 20.0));
    }

    public double getInput() {
        return EnergyNetGlobal.instance.getNodeStats(this.energy.getDelegate()).getEnergyIn();
    }

    public ContainerBaseMolecular getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBaseMolecular(entityPlayer, this);
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (double[])DecoderHandler.decode(customPacketBuffer);
            this.energyShare = (double[])DecoderHandler.decode(customPacketBuffer);
            this.energySlots = (double[])DecoderHandler.decode(customPacketBuffer);
            this.maxEnergySlots = (double[])DecoderHandler.decode(customPacketBuffer);
            this.queue = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.redstoneMode = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.differenceenergy = (Double)DecoderHandler.decode(customPacketBuffer);
            this.perenergy = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
            EncoderHandler.encode(packet, this.energyShare);
            EncoderHandler.encode(packet, this.energySlots);
            EncoderHandler.encode(packet, this.maxEnergySlots);
            EncoderHandler.encode(packet, this.queue);
            EncoderHandler.encode(packet, this.redstoneMode);
            EncoderHandler.encode(packet, this.differenceenergy);
            EncoderHandler.encode(packet, this.perenergy);
            EncoderHandler.encode(packet, this.output_stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_145831_w().field_72995_K && this.maxAmount == 1 && stack.func_77973_b() == IUItem.double_molecular) {
            this.maxAmount = 2;
            stack.func_190918_g(1);
            new PacketUpdateFieldTile(this, "maxAmount", this.maxAmount);
            return true;
        }
        if (!this.func_145831_w().field_72995_K && this.maxAmount == 2 && stack.func_77973_b() == IUItem.quad_molecular) {
            this.maxAmount = 4;
            stack.func_190918_g(1);
            new PacketUpdateFieldTile(this, "maxAmount", this.maxAmount);
            return true;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
            EncoderHandler.encode(packet, this.energyShare);
            EncoderHandler.encode(packet, this.energySlots);
            EncoderHandler.encode(packet, this.queue);
            EncoderHandler.encode(packet, this.maxAmount);
            EncoderHandler.encode(packet, this.redstoneMode);
            EncoderHandler.encode(packet, this.energy, false);
            EncoderHandler.encode(packet, this.output_stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.guiProgress = (double[])DecoderHandler.decode(customPacketBuffer);
            this.energyShare = (double[])DecoderHandler.decode(customPacketBuffer);
            this.energySlots = (double[])DecoderHandler.decode(customPacketBuffer);
            this.queue = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.maxAmount = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.redstoneMode = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.energy.onNetworkUpdate(customPacketBuffer);
            this.output_stack = (ItemStack[])DecoderHandler.decode(customPacketBuffer);
            for (int i = 0; i < Objects.requireNonNull(this.output_stack).length; ++i) {
                if (!this.output_stack[i].func_190926_b()) {
                    this.bakedModel[i] = Minecraft.func_71410_x().func_175599_af().func_184393_a(this.output_stack[i], this.func_145831_w(), null);
                    this.transformedModel[i] = ForgeHooksClient.handleCameraTransforms((IBakedModel)this.bakedModel[i], (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
                    continue;
                }
                this.bakedModel[i] = null;
                this.transformedModel[i] = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public String getInventoryName() {
        return "Molecular Transformer";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.maxAmount = nbttagcompound.func_74762_e("maxAmount");
        for (int i = 0; i < this.maxAmount; ++i) {
            this.energySlots[i] = nbttagcompound.func_74769_h("energySlots" + i);
        }
        this.queue = nbttagcompound.func_74767_n("queue");
        this.redstoneMode = nbttagcompound.func_74771_c("redstoneMode");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74774_a("redstoneMode", this.redstoneMode);
        nbttagcompound.func_74757_a("queue", this.queue);
        nbttagcompound.func_74768_a("maxAmount", this.maxAmount);
        for (int i = 0; i < this.maxAmount; ++i) {
            nbttagcompound.func_74780_a("energySlots" + i, this.energySlots[i]);
        }
        return nbttagcompound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMolecularTransformer(new ContainerBaseMolecular(entityPlayer, this));
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (event == 0.0) {
            this.redstoneMode = (byte)(this.redstoneMode + 1);
            if (this.redstoneMode >= 8) {
                this.redstoneMode = 0;
            }
            new PacketUpdateFieldTile(this, "redstoneMode", this.redstoneMode);
        }
        if (event == -1.0) {
            this.redstoneMode = (byte)(this.redstoneMode - 1);
            if (this.redstoneMode < 0) {
                this.redstoneMode = (byte)7;
            }
            new PacketUpdateFieldTile(this, "redstoneMode", this.redstoneMode);
        }
        if (event == 1.0) {
            boolean bl = this.queue = !this.queue;
            if (this.need) {
                this.queue = false;
            }
            this.setOverclockRates();
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void operate(int i, MachineRecipe output) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(i, processResult);
    }

    public void operate(int i, MachineRecipe output, int size) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(i, processResult, size);
    }

    public void operateOnce(int i, List<ItemStack> processResult) {
        this.inputSlot[i].consume();
        this.outputSlot[i].add(processResult);
        this.energySlots[i] = 0.0;
        if (!this.inputSlot[i].continue_process(this.output[i]) || !this.outputSlot[i].canAdd(this.output[i].getRecipe().output.items)) {
            this.getOutput(i);
        }
        this.setOverclockRates();
    }

    public void operateOnce(int index, List<ItemStack> processResult, int size) {
        for (int i = 0; i < size; ++i) {
            this.inputSlot[index].consume();
            this.outputSlot[index].add(processResult);
        }
        this.energySlots[index] = 0.0;
        if (!this.inputSlot[index].continue_process(this.output[index]) || !this.outputSlot[index].canAdd(this.output[index].getRecipe().output.items)) {
            this.getOutput(index);
        }
        this.setOverclockRates();
    }

    @Override
    public int getMode() {
        return this.redstoneMode;
    }

    @Override
    public ItemStack getItemStack() {
        return this.output_stack[0];
    }

    @Override
    public TileEntityBlock getEntityBlock() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel getBakedModel() {
        if (this.tick % 120 == 0) {
            int i;
            this.tick = 1;
            boolean found = false;
            for (i = Math.min(this.indexModel + 1, this.maxAmount); i < this.maxAmount; ++i) {
                if (this.bakedModel[i] == null) continue;
                this.indexModel = i;
                found = true;
                break;
            }
            if (!found) {
                for (i = 0; i < this.maxAmount; ++i) {
                    if (this.bakedModel[i] == null) continue;
                    this.indexModel = i;
                    break;
                }
            }
        } else {
            ++this.tick;
        }
        return this.bakedModel[this.indexModel];
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            for (int i = 0; i < this.maxAmount; ++i) {
                this.inputSlot[i].load();
            }
            this.setOverclockRates();
            new PacketUpdateFieldTile(this, "redstoneMode", this.redstoneMode);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("redstoneMode")) {
            try {
                this.redstoneMode = (Byte)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("maxAmount")) {
            try {
                this.maxAmount = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("output")) {
            try {
                this.output_stack = (ItemStack[])DecoderHandler.decode(is);
                for (int i = 0; i < Objects.requireNonNull(this.output_stack).length; ++i) {
                    if (!this.output_stack[i].func_190926_b()) {
                        this.bakedModel[i] = Minecraft.func_71410_x().func_175599_af().func_184393_a(this.output_stack[i], this.func_145831_w(), null);
                        this.transformedModel[i] = ForgeHooksClient.handleCameraTransforms((IBakedModel)this.bakedModel[i], (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
                        continue;
                    }
                    this.bakedModel[i] = null;
                    this.transformedModel[i] = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public IBakedModel getTransformedModel() {
        return this.transformedModel[this.indexModel];
    }

    public void setOverclockRates() {
        double newStorage = 0.0;
        for (int i = 0; i < this.maxAmount; ++i) {
            MachineRecipe output;
            MachineRecipe machineRecipe = output = this.getRecipeOutput(i) == null ? this.getOutput(i) : this.getRecipeOutput(i);
            if (!this.queue) {
                if (this.inputSlot[i].isEmpty() || !this.inputSlot[i].continue_proccess(this.outputSlot[i])) {
                    this.maxEnergySlots[i] = 0.0;
                    continue;
                }
                if (output != null) {
                    newStorage += output.getRecipe().output.metadata.func_74769_h("energy");
                    this.maxEnergySlots[i] = output.getRecipe().output.metadata.func_74769_h("energy");
                    this.energySlots[i] = Math.max(0.0, this.energySlots[i]);
                    this.energySlots[i] = Math.min(this.energySlots[i], this.maxEnergySlots[i]);
                    newStorage -= this.energySlots[i];
                    continue;
                }
                this.maxEnergySlots[i] = 0.0;
                this.energySlots[i] = 0.0;
                continue;
            }
            if (this.inputSlot[i].isEmpty() || !this.inputSlot[i].continue_proccess(this.outputSlot[i])) {
                this.maxEnergySlots[i] = 0.0;
                this.energySlots[i] = 0.0;
                continue;
            }
            if (output != null) {
                ItemStack output1 = this.output[i].getRecipe().output.items.get(0);
                int size = this.output[i].getRecipe().input.getInputs().get(0).getInputs().get(0).func_190916_E();
                size = (int)Math.floor((float)this.inputSlot[i].get().func_190916_E() / (float)size);
                int size1 = !this.outputSlot[i].isEmpty() ? (64 - this.outputSlot[i].get().func_190916_E()) / output1.func_190916_E() : 64 / output1.func_190916_E();
                size = Math.min(size1, size);
                size = Math.min(size, output1.func_77976_d());
                this.size_recipe[i] = size;
                newStorage += output.getRecipe().output.metadata.func_74769_h("energy") * (double)size;
                this.maxEnergySlots[i] = output.getRecipe().output.metadata.func_74769_h("energy") * (double)size;
                this.energySlots[i] = Math.max(0.0, this.energySlots[i]);
                this.energySlots[i] = Math.min(this.energySlots[i], this.maxEnergySlots[i]);
                newStorage -= this.energySlots[i];
                continue;
            }
            this.maxEnergySlots[i] = 0.0;
            this.energySlots[i] = 0.0;
        }
        this.energy.setCapacity(newStorage);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.differenceenergy = this.energy.getEnergy() - this.perenergy;
        this.perenergy = this.energy.getEnergy();
        this.energy.useEnergy(this.perenergy);
        this.energy.setCapacity(this.energy.getCapacity() - this.perenergy);
        double prev = this.perenergy;
        this.distributeEnergy(prev);
        boolean active = false;
        for (int i = 0; i < this.maxAmount; ++i) {
            MachineRecipe output = this.getRecipeOutput(i);
            if (!this.queue) {
                if (output != null && this.outputSlot[i].canAdd(output.getRecipe().output.items) && this.guiProgress[i] >= 0.0) {
                    if (!this.getActive()) {
                        if (this.field_145850_b.field_73011_w.getWorldTime() % 2L == 0L) {
                            this.initiate(0);
                        }
                        this.setActive(true);
                        this.setOverclockRates();
                    }
                    active = true;
                    this.guiProgress[i] = Math.ceil(this.energySlots[i]) / this.maxEnergySlots[i];
                    if (this.guiProgress[i] >= 1.0 && this.guiProgress[i] != Double.POSITIVE_INFINITY) {
                        this.operate(i, output);
                        this.guiProgress[i] = 0.0;
                        if (this.field_145850_b.field_73011_w.getWorldTime() % 2L == 0L) {
                            this.initiate(2);
                        }
                    }
                } else {
                    if (this.energy.getEnergy() != 0.0 && this.getActive() && this.field_145850_b.field_73011_w.getWorldTime() % 2L == 0L) {
                        this.initiate(1);
                    }
                    this.guiProgress[i] = 0.0;
                    this.setActive(false);
                }
            } else if (output != null && this.inputSlot[i].continue_proccess(this.outputSlot[i])) {
                active = true;
                ItemStack output1 = this.output[i].getRecipe().output.items.get(0);
                int size = this.output[i].getRecipe().input.getInputs().get(0).getInputs().get(0).func_190916_E();
                size = (int)Math.floor((float)this.inputSlot[i].get().func_190916_E() / (float)size);
                int size1 = !this.outputSlot[i].isEmpty() ? (64 - this.outputSlot[i].get().func_190916_E()) / output1.func_190916_E() : 64 / output1.func_190916_E();
                size = Math.min(size1, size);
                if (this.size_recipe[i] != (double)(size = Math.min(size, output1.func_77976_d()))) {
                    this.setOverclockRates();
                }
                this.guiProgress[i] = Math.ceil(this.energySlots[i]) / this.maxEnergySlots[i];
                if (this.guiProgress[i] >= 1.0 && this.guiProgress[i] != Double.POSITIVE_INFINITY) {
                    this.operate(i, output, size);
                    this.initiate(2);
                }
            } else {
                if (this.energy.getEnergy() != 0.0 && this.getActive()) {
                    this.initiate(1);
                }
                this.setActive(false);
            }
            if (!this.getActive() || output != null) continue;
            this.setActive(false);
        }
        if (!this.getActive() && active) {
            if (this.field_145850_b.field_73011_w.getWorldTime() % 2L == 0L) {
                this.initiate(0);
            }
            this.setActive(true);
            this.setOverclockRates();
        }
        for (int ii = 0; ii < this.maxAmount; ++ii) {
            if (this.outputSlot[ii].isEmpty() || this.func_145831_w().field_73011_w.getWorldTime() % 10L != 0L) continue;
            ModUtils.tick(this.outputSlot[ii], this);
        }
    }

    private void distributeEnergy(double inputEnergy) {
        int size = this.maxAmount;
        double totalNeed = 0.0;
        for (int i = 0; i < 4; ++i) {
            this.energySlots[i] = Math.max(this.energySlots[i], 0.0);
        }
        int size1 = 0;
        for (int i = 0; i < size; ++i) {
            totalNeed += Math.max(0.0, this.maxEnergySlots[i] - this.energySlots[i]);
            if (!(this.maxEnergySlots[i] > 0.0)) continue;
            ++size1;
        }
        if (totalNeed <= 0.0) {
            return;
        }
        double minEnergyPerSlot = inputEnergy * 0.1 / (double)size1;
        if (inputEnergy >= totalNeed) {
            for (int i = 0; i < size; ++i) {
                this.energySlots[i] = this.maxEnergySlots[i];
            }
        } else {
            int i;
            for (i = 0; i < size; ++i) {
                double need = this.maxEnergySlots[i] - this.energySlots[i];
                if (!(need > 0.0)) continue;
                this.energyShare[i] = Math.max(Math.min(minEnergyPerSlot, need), inputEnergy * need / totalNeed);
                int n = i;
                this.energySlots[n] = this.energySlots[n] + this.energyShare[i];
                inputEnergy -= this.energyShare[i];
            }
            for (i = 0; i < size && inputEnergy > 0.0; ++i) {
                double remainingCapacity = this.maxEnergySlots[i] - this.energySlots[i];
                if (!(remainingCapacity > 0.0)) continue;
                double additionalEnergy = Math.min(inputEnergy, remainingCapacity);
                int n = i;
                this.energySlots[n] = this.energySlots[n] + additionalEnergy;
                int n2 = i;
                this.energyShare[n2] = this.energyShare[n2] + additionalEnergy;
                inputEnergy -= additionalEnergy;
            }
        }
    }

    public MachineRecipe getOutput(int i) {
        this.output[i] = this.inputSlot[i].process();
        this.output_stack[i] = this.output[i] != null ? this.output[i].getRecipe().output.items.get(0) : new ItemStack(Items.field_190931_a);
        return this.output[i];
    }

    public double getProgress(int i) {
        return Math.min(this.guiProgress[i], 1.0);
    }

    public String getStartSoundFile() {
        return "Machines/molecular.ogg";
    }

    @Override
    public void onUpdate() {
        for (int i = 0; i < 4; ++i) {
            if (this.inputSlot[i].get().func_77973_b() instanceof ItemEnchantedBook) {
                this.need = true;
                return;
            }
            if (!(this.inputSlot[i].get().func_77973_b() instanceof ItemPotion)) continue;
            this.need = true;
            return;
        }
        this.need = false;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.getRecipeOutput(0);
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.setRecipeOutput(0, output);
    }

    @Override
    public MachineRecipe getRecipeOutput(int i) {
        return this.output[i];
    }

    @Override
    public void setRecipeOutput(int i, MachineRecipe output) {
        this.output[i] = output;
        if (this.output[i] != null) {
            this.output_stack[i] = this.output[i].getRecipe().output.items.get(0);
        } else {
            this.output_stack[i] = new ItemStack(Items.field_190931_a);
            this.energySlots[i] = 0.0;
            this.maxEnergySlots[i] = 0.0;
        }
        new PacketUpdateFieldTile(this, "output", this.output_stack);
        this.setOverclockRates();
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.molecular.getSoundEvent();
    }
}

