/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IAdvEnergyNet;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockResource;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.ProcessMultiComponent;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.container.ContainerMultiMachine;
import com.denfop.gui.GuiMultiMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotDischarge;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.items.modules.ItemModuleTypePanel;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.EnumTypeMachines;
import com.denfop.tiles.mechanism.multimechanism.IMultiMachine;
import com.denfop.tiles.panels.entity.EnumSolarPanels;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class TileMultiMachine
extends TileEntityInventory
implements IAudioFixer,
IUpgradableBlock,
IUpdatableTileEvent,
IHasRecipe,
IMultiMachine {
    public final Energy energy;
    public final InvSlotDischarge dischargeSlot;
    public final ProcessMultiComponent multi_process;
    public final int sizeWorkingSlot;
    public final InvSlot input_slot;
    private final ComponentUpgradeSlots componentUpgrades;
    public CoolComponent cold;
    public HeatComponent heat = null;
    public FluidTank tank = null;
    public ComponentBaseEnergy exp;
    public EnumSolarPanels solartype;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound;
    private Fluids fluid = null;
    private int tick;
    private TileSolarPanel panel;

    public TileMultiMachine(EnumMultiMachine enumMultiMachine) {
        this(1, enumMultiMachine.usagePerTick, enumMultiMachine.lenghtOperation);
    }

    public TileMultiMachine(int energyconsume, int OperationsPerTick) {
        this(1, energyconsume, OperationsPerTick);
    }

    public TileMultiMachine(int aDefaultTier, int energyconsume, int OperationsPerTick) {
        this.sizeWorkingSlot = this.getMachine().sizeWorkingSlot;
        this.dischargeSlot = new InvSlotDischarge(this, InvSlot.TypeItemSlot.INPUT, aDefaultTier, false);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, (double)energyconsume * (double)OperationsPerTick, (int)Math.min(14.0, Math.pow(2.0, this.sizeWorkingSlot - 1))).addManagedSlot(this.dischargeSlot));
        if (this.getMachine().type == EnumTypeMachines.OreWashing) {
            this.fluid = this.addComponent(new Fluids(this));
            this.tank = this.fluid.addTank("tank", 64000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate(FluidRegistry.WATER));
        }
        this.solartype = null;
        this.cold = this.addComponent(CoolComponent.asBasicSink(this, 100.0));
        this.sound = true;
        this.exp = null;
        if (this.getMachine().type == EnumTypeMachines.ELECTRICFURNACE) {
            this.exp = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.EXPERIENCE, this, 5000.0, 14));
        }
        if (this.getMachine().type == EnumTypeMachines.Centrifuge) {
            this.heat = this.addComponent(HeatComponent.asBasicSink(this, 5000.0));
        }
        this.multi_process = this.addComponent(new ProcessMultiComponent(this, this.getMachine()));
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.HEAT);
        this.componentUpgrades = this.addComponent(new ComponentUpgradeSlots(this, this.multi_process.getUpgradeSlot()){

            @Override
            public void setOverclockRates(InvSlotUpgrade invSlotUpgrade) {
                super.setOverclockRates(invSlotUpgrade);
                invSlotUpgrade.isUpdate = true;
                ((TileMultiMachine)this.getParent()).multi_process.setOverclockRates();
                invSlotUpgrade.isUpdate = false;
            }
        });
        this.input_slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (this.get().func_190926_b()) {
                    ((TileMultiMachine)this.base).multi_process.inputSlots.changeAccepts(ItemStack.field_190927_a);
                } else {
                    ((TileMultiMachine)this.base).multi_process.inputSlots.changeAccepts(this.get());
                }
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() == IUItem.recipe_schedule;
            }
        };
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public HeatComponent getHeat() {
        return this.heat;
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            Object o = DecoderHandler.decode(customPacketBuffer);
            if (o != null) {
                this.solartype = EnumSolarPanels.values()[(Integer)o];
            }
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, (Object)this.solartype);
            EncoderHandler.encode(packet, this.sound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void init() {
    }

    @Override
    public SoundEvent getSound() {
        return this.getMachine().type.getSound();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        NBTTagCompound nbt;
        double energy1;
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            if (!this.cold.upgrade && this.getMachine().sizeWorkingSlot != 8) {
                tooltip.add(Localization.translate("iu.multimachine.info"));
            }
            if (this.heat != null && !this.heat.auto) {
                tooltip.add(Localization.translate("iu.heatmachine.info"));
            }
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.multi_process.energyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.multi_process.operationLength);
        }
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
        if ((energy1 = (nbt = ModUtils.nbt(stack)).func_74769_h("energy")) != 0.0) {
            tooltip.add(Localization.translate("iu.item.tooltip.Store") + " " + ModUtils.getString(energy1) + "/" + ModUtils.getString(this.energy.getCapacity()) + " EF");
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (this.getSound() == null) {
            return;
        }
        if (this.getEnable()) {
            if (soundEvent == 0) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (soundEvent == 1) {
                new PacketStopSound(this.func_145831_w(), this.field_174879_c);
                this.func_145831_w().func_184133_a(null, this.field_174879_c, EnumSound.InterruptOne.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            }
        }
    }

    public void onUpdate() {
    }

    public CoolComponent getComponent() {
        return this.cold;
    }

    public List<ItemStack> getDrop() {
        return this.getAuxDrops(0);
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        double energy1 = nbt.func_74769_h("energy");
        if (energy1 != 0.0) {
            this.energy.addEnergy(energy1);
        }
        double energy4 = nbt.func_74769_h("energy2");
        if (energy1 != 0.0 && this.cold != null) {
            this.cold.addEnergy(energy4);
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        CoolComponent component3;
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    CoolComponent component32;
                    Energy component = this.energy;
                    if (component != null && component.getEnergy() != 0.0) {
                        NBTTagCompound nbt = ModUtils.nbt(drop);
                        nbt.func_74780_a("energy", component.getEnergy());
                    }
                    if ((component32 = this.cold) != null && component32.getEnergy() != 0.0) {
                        NBTTagCompound nbt = ModUtils.nbt(drop);
                        nbt.func_74780_a("energy2", component32.getEnergy());
                    }
                    return drop;
                }
                case None: {
                    return null;
                }
                case Generator: {
                    return new ItemStack((Block)IUItem.basemachine2, 1, 78);
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: 
            }
            return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
        }
        Energy component = this.getComp(Energy.class);
        if (component != null && component.getEnergy() != 0.0) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            nbt.func_74780_a("energy", component.getEnergy());
        }
        if ((component3 = this.cold) != null && component3.getEnergy() != 0.0) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            nbt.func_74780_a("energy2", component3.getEnergy());
        }
        return drop;
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        ItemStack stack_quickly = ItemStack.field_190927_a;
        ItemStack stack_modulesize = ItemStack.field_190927_a;
        ItemStack stack_modulestorage = ItemStack.field_190927_a;
        ItemStack panel = ItemStack.field_190927_a;
        ItemStack colling = ItemStack.field_190927_a;
        ItemStack module_separate = ItemStack.field_190927_a;
        ItemStack module_infinity_water = ItemStack.field_190927_a;
        if (this.multi_process.quickly) {
            stack_quickly = new ItemStack(IUItem.module_quickly);
        }
        if (this.multi_process.modulesize) {
            stack_modulesize = new ItemStack(IUItem.module_stack);
        }
        if (this.multi_process.modulestorage) {
            stack_modulestorage = new ItemStack(IUItem.module_storage);
        }
        if (this.multi_process.module_separate) {
            module_separate = new ItemStack(IUItem.module_separate);
        }
        if (this.multi_process.module_infinity_water) {
            module_infinity_water = new ItemStack(IUItem.module_infinity_water);
        }
        if (this.solartype != null) {
            panel = new ItemStack(IUItem.module6, 1, this.solartype.meta);
        }
        if (this.cold.upgrade && this.getMachine().type != EnumTypeMachines.Centrifuge) {
            colling = new ItemStack((Item)IUItem.coolupgrade, 1, this.cold.meta);
        }
        if (!(stack_modulestorage.func_190926_b() && stack_quickly.func_190926_b() && module_separate.func_190926_b() && module_infinity_water.func_190926_b() && stack_modulesize.func_190926_b() && panel.func_190926_b() && colling.func_190926_b())) {
            if (!stack_modulestorage.func_190926_b()) {
                ret.add(stack_modulestorage);
                this.multi_process.shrinkModule(1);
                this.multi_process.setModulesize(false);
            }
            if (!stack_quickly.func_190926_b()) {
                ret.add(stack_quickly);
                this.multi_process.shrinkModule(1);
                this.multi_process.setQuickly(false);
            }
            if (!module_separate.func_190926_b()) {
                ret.add(module_separate);
                this.multi_process.shrinkModule(1);
                this.multi_process.module_separate = false;
            }
            if (!module_infinity_water.func_190926_b()) {
                ret.add(module_infinity_water);
                this.multi_process.shrinkModule(1);
                this.multi_process.module_infinity_water = false;
            }
            if (!stack_modulesize.func_190926_b()) {
                ret.add(stack_modulesize);
                this.multi_process.shrinkModule(1);
                this.multi_process.setModulesize(false);
            }
            if (this.solartype != null) {
                ret.add(panel);
                this.solartype = null;
            }
            if (!colling.func_190926_b()) {
                ret.add(colling);
                this.cold.upgrade = false;
                this.cold.meta = 0;
            }
        }
        return ret;
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!entityPlayer.func_184586_b(hand).func_190926_b()) {
            if (entityPlayer.func_184586_b(hand).func_77973_b() instanceof ItemModuleTypePanel) {
                if (this.solartype != null) {
                    EnumSolarPanels type = this.solartype;
                    int meta = type.meta;
                    ItemStack stack = new ItemStack(IUItem.module6, 1, meta);
                    if (!entityPlayer.field_71071_by.func_70441_a(stack)) {
                        EntityItem item = new EntityItem(entityPlayer.func_130014_f_(), (double)((int)entityPlayer.field_70165_t), (double)((int)entityPlayer.field_70163_u - 1), (double)((int)entityPlayer.field_70161_v));
                        item.func_92058_a(stack);
                        item.func_70107_b(entityPlayer.field_70165_t, entityPlayer.field_70163_u - 1.0, entityPlayer.field_70161_v);
                        item.func_174869_p();
                        this.field_145850_b.func_72838_d((Entity)item);
                    }
                }
                this.solartype = ItemModuleTypePanel.getSolarType(entityPlayer.func_184586_b(hand).func_77952_i());
                entityPlayer.func_184586_b(hand).func_190918_g(1);
                return true;
            }
            if (this.multi_process.onActivated(entityPlayer.func_184586_b(hand))) {
                return true;
            }
            if (!this.func_145831_w().field_72995_K && FluidUtil.getFluidHandler((ItemStack)entityPlayer.func_184586_b(hand)) != null && this.fluid != null) {
                return ModUtils.interactWithFluidHandler(entityPlayer, hand, (IFluidHandler)this.fluid.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
            }
        }
        return super.onActivated(entityPlayer, hand, side, hitX, hitY, hitZ);
    }

    public abstract EnumMultiMachine getMachine();

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        int id = nbttagcompound.func_74762_e("panelid");
        if (id != -1) {
            this.solartype = IUItem.map1.get(id);
        }
        this.sound = nbttagcompound.func_74767_n("sound");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        if (this.solartype != null) {
            nbttagcompound.func_74768_a("panelid", this.solartype.meta);
        } else {
            nbttagcompound.func_74768_a("panelid", -1);
        }
        nbttagcompound.func_74757_a("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        if (event == 0.0) {
            this.multi_process.cycleMode();
        } else {
            this.sound = !this.sound;
            new PacketUpdateFieldTile(this, "sound", this.sound);
            if (!this.sound && this.getTypeAudio() == EnumTypeAudio.ON) {
                this.setType(EnumTypeAudio.OFF);
                new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "sound", this.sound);
            if (this.input_slot.isEmpty()) {
                this.multi_process.inputSlots.changeAccepts(ItemStack.field_190927_a);
            } else {
                this.multi_process.inputSlots.changeAccepts(this.input_slot.get());
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public EnumTypeMachines getTypeMachine() {
        return this.getMachine().type;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.solartype != null) {
            if (this.energy.getEnergy() < this.energy.getCapacity()) {
                if (this.panel == null) {
                    this.panel = new TileSolarPanel(this.solartype);
                    this.panel.func_145834_a(this.func_145831_w());
                    this.panel.func_174878_a(this.field_174879_c);
                    IAdvEnergyNet advEnergyNet = EnergyNetGlobal.instance;
                    this.panel.canRain = this.field_145850_b.func_180494_b(this.field_174879_c).func_76738_d() || this.field_145850_b.func_180494_b(this.field_174879_c).func_76727_i() > 0.0f;
                    this.panel.hasSky = !this.field_145850_b.field_73011_w.func_177495_o();
                    this.panel.biome = this.field_145850_b.func_180494_b(this.field_174879_c);
                    this.panel.sunCoef = advEnergyNet.getSunCoefficient(this.field_145850_b);
                    this.panel.skyIsVisible = this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_151565_r() == MapColor.field_151660_b && !this.panel.noSunWorld;
                    this.panel.wetBiome = this.panel.func_145831_w().func_180494_b(this.field_174879_c).func_76727_i() > 0.0f;
                    this.panel.rain = this.panel.wetBiome && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
                    this.panel.sunIsUp = this.func_145831_w().func_72935_r();
                }
                if (this.panel.activeState == null || this.func_145831_w().field_73011_w.getWorldTime() % 40L == 0L) {
                    this.panel.updateVisibility();
                }
                this.panel.gainFuel();
                if (this.energy.getEnergy() < this.energy.getCapacity()) {
                    this.energy.addEnergy(Math.min(this.panel.generating, this.energy.getFreeEnergy()));
                }
            }
        } else if (this.panel != null) {
            this.panel = null;
        }
        ++this.tick;
        if (!this.getActive()) {
            if (this.tick - 120 >= 0) {
                this.cold.useEnergy(0.35);
                this.tick = 0;
            }
        } else if (this.tick - 240 >= 0) {
            this.cold.useEnergy(0.35);
            this.tick = 0;
        }
    }

    public ContainerMultiMachine getGuiContainer(EntityPlayer player) {
        return new ContainerMultiMachine(player, this, this.sizeWorkingSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiMultiMachine getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiMultiMachine(new ContainerMultiMachine(player, this, this.sizeWorkingSlot));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    public int getMode() {
        return 0;
    }

    @Override
    public boolean canoperate(int size) {
        return true;
    }

    @Override
    public int getSize(int size) {
        return size;
    }

    @Override
    public void consume(int size) {
    }
}

