/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.FluidName;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.container.ContainerMultiMatter;
import com.denfop.gui.GuiMultiMatter;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.IMatter;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class TileMultiMatter
extends TileElectricMachine
implements IUpgradableBlock,
IUpdatableTileEvent,
IType,
IUpdateTick,
IMatter {
    public static Map<Integer, Map<ChunkPos, List<IMatter>>> worldMatterMap = new HashMap<Integer, Map<ChunkPos, List<IMatter>>>();
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotRecipes amplifierSlot = new InvSlotRecipes((TileEntityInventory)this, "matterAmplifier", (IUpdateTick)this);
    public final InvSlotOutput outputSlot;
    public final InvSlotFluid containerslot;
    public final FluidTank fluidTank;
    public final float energycost;
    protected final Fluids fluids;
    private final Redstone redstone;
    private final int state = 0;
    private final int prevState = 0;
    public boolean work;
    public int scrap = 0;
    public boolean redstonePowered = false;
    private int amountScrap;
    private double lastEnergy;
    private MachineRecipe recipe;

    public TileMultiMatter(float storageEnergy, int sizeTank, float maxtempEnergy) {
        super(Math.round(maxtempEnergy * 1.0f), 3, 1);
        this.energycost = storageEnergy * 1.0f;
        this.outputSlot = new InvSlotOutput(this, 1);
        this.containerslot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, FluidName.fluiduu_matter.getInstance());
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", sizeTank * 1000, Fluids.fluidPredicate(FluidName.fluiduu_matter.getInstance()), InvSlot.TypeItemSlot.OUTPUT);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                TileMultiMatter.this.energy.setEnabled(input == 0);
                TileMultiMatter.this.work = input != 0;
                TileMultiMatter.this.energy.setReceivingEnabled(TileMultiMatter.this.work);
            }
        });
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(3.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.matter_work_info") + (int)this.energycost);
        }
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.scrap = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.scrap);
            EncoderHandler.encode(packet, this.work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
            return;
        }
        this.work = !this.work;
        this.energy.setReceivingEnabled(this.work);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.scrap = nbt.func_74762_e("scrap");
        this.lastEnergy = nbt.func_74769_h("lastEnergy");
        this.work = nbt.func_74767_n("work");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("scrap", this.scrap);
        nbt.func_74780_a("lastEnergy", this.lastEnergy);
        nbt.func_74757_a("work", this.work);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.setUpgradestat();
            this.amplifierSlot.load();
            this.getOutput();
            this.energy.setReceivingEnabled(this.work);
            Map<ChunkPos, List<IMatter>> chunkPosListMap = worldMatterMap.get(this.field_145850_b.field_73011_w.getDimension());
            if (chunkPosListMap == null) {
                chunkPosListMap = new HashMap<ChunkPos, List<IMatter>>();
                ChunkPos chunkPos = new ChunkPos(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                LinkedList<TileMultiMatter> matters = new LinkedList<TileMultiMatter>();
                matters.add(this);
                chunkPosListMap.put(chunkPos, matters);
                worldMatterMap.put(this.field_145850_b.field_73011_w.getDimension(), chunkPosListMap);
            } else {
                ChunkPos chunkPos = new ChunkPos(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                List<IMatter> matters = chunkPosListMap.get(chunkPos);
                if (matters == null) {
                    matters = new LinkedList<IMatter>();
                    matters.add(this);
                    chunkPosListMap.put(chunkPos, matters);
                } else {
                    matters.add(this);
                }
            }
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.func_145831_w().field_72995_K) {
            Map<ChunkPos, List<IMatter>> chunkPosListMap = worldMatterMap.get(this.field_145850_b.field_73011_w.getDimension());
            if (chunkPosListMap == null) {
                chunkPosListMap = new HashMap<ChunkPos, List<IMatter>>();
                ChunkPos chunkPos = new ChunkPos(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                LinkedList matters = new LinkedList();
                chunkPosListMap.put(chunkPos, matters);
                worldMatterMap.put(this.field_145850_b.field_73011_w.getDimension(), chunkPosListMap);
            } else {
                ChunkPos chunkPos = new ChunkPos(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                List<IMatter> matters = chunkPosListMap.get(chunkPos);
                if (matters == null) {
                    matters = new LinkedList<IMatter>();
                    chunkPosListMap.put(chunkPos, matters);
                } else {
                    matters.remove(this);
                }
            }
        }
    }

    private void getOutput() {
        this.recipe = this.amplifierSlot.process();
        this.setRecipeOutput(this.recipe);
        this.onUpdate();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.redstonePowered = false;
        if (this.work && !(this.energy.getEnergy() <= 0.0)) {
            double bonus;
            if (this.scrap > 0 && (bonus = Math.min((double)this.scrap, this.energy.getEnergy() - this.lastEnergy)) > 0.0) {
                this.energy.forceAddEnergy(5.0 * bonus);
                this.scrap = (int)((double)this.scrap - bonus);
            }
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.scrap < 10000 && this.amountScrap > 0) {
                this.recipe = this.getRecipeOutput();
                if (this.recipe != null) {
                    this.amplifierSlot.consume();
                    this.scrap += this.amountScrap;
                    if (this.amplifierSlot.isEmpty()) {
                        this.getOutput();
                    }
                }
            }
            if (this.energy.getEnergy() >= (double)this.energycost) {
                this.attemptGeneration();
            }
            if (!this.containerslot.isEmpty()) {
                this.containerslot.processFromTank((IFluidTank)this.fluidTank, this.outputSlot);
            }
            this.lastEnergy = this.energy.getEnergy();
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public void attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / (double)this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fillInternal(new FluidStack(FluidName.fluiduu_matter.getInstance(), Math.min(m, k)), true);
        this.energy.useEnergy(this.energycost * (float)Math.min(m, k));
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy.getEnergy() * 100.0 / (double)this.energycost), 100);
        return "" + p + "%";
    }

    public ContainerMultiMatter getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMultiMatter(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMultiMatter(new ContainerMultiMatter(entityPlayer, this));
    }

    @Override
    public FluidTank getMatterTank() {
        return this.fluidTank;
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(TileMultiMatter.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.recipe;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.recipe = output;
        this.amountScrap = this.recipe == null ? 0 : this.recipe.getRecipe().getOutput().metadata.func_74762_e("amount");
    }
}

