/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerObsidianGenerator;
import com.denfop.gui.GuiObsidianGenerator;
import com.denfop.tiles.base.TileBaseObsidianGenerator;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileObsidianGenerator
extends TileBaseObsidianGenerator
implements IHasRecipe {
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;

    public TileObsidianGenerator() {
        super(1, 300, 1);
        Recipes.recipes.getRecipeFluid().addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
    }

    @Override
    public void init() {
        Recipes.recipes.getRecipeFluid().addRecipe("obsidian", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack(FluidRegistry.WATER, 1000), new FluidStack(FluidRegistry.LAVA, 1000)), new RecipeOutput(null, new ItemStack(Blocks.field_150343_Z))));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.gen_obsidian;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    @Override
    public String getInventoryName() {
        return Localization.translate("iu.blockObsGen.name");
    }

    @SideOnly(value=Side.CLIENT)
    public GuiObsidianGenerator getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiObsidianGenerator(new ContainerObsidianGenerator(entityPlayer, this));
    }

    public String getStartSoundFile() {
        return "Machines/gen_obsidiant.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.FluidInput);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.fluidTank1.getTankProperties()[0], this.fluidTank2.getTankProperties()[0]};
    }
}

