/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerRadiationPurifier;
import com.denfop.gui.GuiRadiationPurifier;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.mechanism.TileEntitySoilAnalyzer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRadiationPurifier
extends TileElectricMachine {
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    public Radiation radiation;
    public Map<BlockPos, TileEntitySoilAnalyzer> booleanMap = new HashMap<BlockPos, TileEntitySoilAnalyzer>();
    private ItemStack stack;

    public TileRadiationPurifier() {
        super(50000.0, 14, 1);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.15));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.15));
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        TileEntity tile = this.func_145831_w().func_175625_s(neighborPos);
        boolean can = tile instanceof TileEntitySoilAnalyzer;
        if (!this.booleanMap.containsKey(neighborPos) && can) {
            this.booleanMap.put(neighborPos, (TileEntitySoilAnalyzer)tile);
        } else if (!can) {
            this.booleanMap.remove(neighborPos);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            for (EnumFacing facing1 : EnumFacing.field_82609_l) {
                BlockPos pos1 = this.field_174879_c.func_177972_a(facing1);
                TileEntity tile = this.func_145831_w().func_175625_s(pos1);
                boolean can = tile instanceof TileEntitySoilAnalyzer;
                if (!this.booleanMap.containsKey(pos1) && can) {
                    this.booleanMap.put(pos1, (TileEntitySoilAnalyzer)tile);
                    continue;
                }
                if (can) continue;
                this.booleanMap.remove(pos1);
            }
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        this.radiation = RadiationSystem.rad_system.getMap().get(this.func_145831_w().func_175726_f(this.field_174879_c).func_76632_l());
        this.stack = new ItemStack((Item)IUItem.crafting_elements, 1, 443);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.radiation_purifier;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().func_72820_D() % 20L == 0L) {
            if (this.radiation != null && this.energy.canUseEnergy(100.0) && !this.booleanMap.isEmpty()) {
                boolean canWork = false;
                for (Map.Entry<BlockPos, TileEntitySoilAnalyzer> entry : this.booleanMap.entrySet()) {
                    canWork = entry.getValue().analyzed;
                    if (!canWork) continue;
                    break;
                }
                if (canWork && this.outputSlot.canAdd(this.stack)) {
                    if (this.radiation.removeRadiationWithType(1000.0)) {
                        this.energy.useEnergy(100.0);
                        this.outputSlot.add(this.stack);
                        this.setActive(true);
                    } else {
                        this.setActive(false);
                    }
                }
            } else {
                this.setActive(false);
            }
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        boolean can = customPacketBuffer.readBoolean();
        if (can) {
            try {
                this.radiation = (Radiation)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.radiation != null);
        if (this.radiation != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.radiation);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    public ContainerRadiationPurifier getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerRadiationPurifier(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiRadiationPurifier(this.getGuiContainer(entityPlayer));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.radiation.getSoundEvent();
    }
}

