/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockSintezator;
import com.denfop.componets.WirelessComponent;
import com.denfop.container.ContainerSinSolarPanel;
import com.denfop.gui.GuiSintezator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotSintezator;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.panels.entity.EnumType;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileSintezator
extends TileEntityInventory
implements IEnergySource,
IUpdatableTileEvent {
    public final InvSlotSintezator inputslot;
    public final InvSlotSintezator inputslotA;
    public final WirelessComponent wirelessComponent;
    public int machineTire1 = 0;
    public int solartype = 0;
    public double generating;
    public double genDay = 0.0;
    public double genNight = 0.0;
    public boolean sunIsUp = false;
    public boolean skyIsVisible = false;
    public short facing;
    public boolean noSunWorld;
    public int machineTire = 0;
    public boolean addedToEnergyNet;
    public double storage = 0.0;
    public double production;
    public double maxStorage = 0.0;
    public boolean rain = false;
    public double progress;
    public boolean wetBiome;
    public EnumType type;
    public TileSolarPanel.GenerationState generationState = TileSolarPanel.GenerationState.NONE;
    Map<EnumFacing, IEnergyTile> energyConductorMap = new HashMap<EnumFacing, IEnergyTile>();
    int hashCodeSource;
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    private int size = 0;
    private double pastEnergy;
    private double perenergy;
    private ChunkPos chunkPos;
    private long id;

    public TileSintezator() {
        this.facing = (short)2;
        this.inputslot = new InvSlotSintezator(this, "input", 0, 9);
        this.inputslotA = new InvSlotSintezator(this, "input1", 1, 4);
        this.type = EnumType.DEFAULT;
        this.wirelessComponent = this.addComponent(new WirelessComponent(this));
        this.wirelessComponent.setEnergySource(this);
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        this.inputslot.wirelessmodule();
    }

    @Override
    public void RemoveTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void AddTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.func_145831_w().field_72995_K) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.func_176734_d()));
        }
    }

    @Override
    public Map<EnumFacing, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.generationState = TileSolarPanel.GenerationState.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.sunIsUp = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.skyIsVisible = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.generating = (Double)DecoderHandler.decode(customPacketBuffer);
            this.genDay = (Double)DecoderHandler.decode(customPacketBuffer);
            this.genNight = (Double)DecoderHandler.decode(customPacketBuffer);
            this.storage = (Double)DecoderHandler.decode(customPacketBuffer);
            this.maxStorage = (Double)DecoderHandler.decode(customPacketBuffer);
            this.production = (Double)DecoderHandler.decode(customPacketBuffer);
            this.rain = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.machineTire = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.machineTire1 = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.type = EnumType.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.solartype = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, (Object)this.generationState);
            EncoderHandler.encode(packet, this.sunIsUp);
            EncoderHandler.encode(packet, this.skyIsVisible);
            EncoderHandler.encode(packet, this.generating);
            EncoderHandler.encode(packet, this.genDay);
            EncoderHandler.encode(packet, this.genNight);
            EncoderHandler.encode(packet, this.storage);
            EncoderHandler.encode(packet, this.maxStorage);
            EncoderHandler.encode(packet, this.production);
            EncoderHandler.encode(packet, this.rain);
            EncoderHandler.encode(packet, this.machineTire);
            EncoderHandler.encode(packet, this.machineTire1);
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, (Object)this.type);
            EncoderHandler.encode(packet, this.solartype);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSintezator.sintezator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blocksintezator;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return new ItemStack((Block)IUItem.blocksintezator);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    public void intialize() {
        this.noSunWorld = this.func_145831_w().field_73011_w.func_177495_o();
        this.updateVisibility();
    }

    public void updateVisibility() {
        this.wetBiome = this.field_145850_b.func_180494_b(this.field_174879_c).func_76727_i() > 0.0f;
        this.noSunWorld = this.field_145850_b.field_73011_w.func_177495_o();
        this.rain = this.wetBiome && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        this.sunIsUp = this.field_145850_b.func_72935_r();
        this.skyIsVisible = true;
        if (this.sunIsUp) {
            this.generationState = !this.rain ? TileSolarPanel.GenerationState.DAY : TileSolarPanel.GenerationState.RAINDAY;
        }
        if (!this.sunIsUp) {
            this.generationState = !this.rain ? TileSolarPanel.GenerationState.NIGHT : TileSolarPanel.GenerationState.RAINNIGHT;
        }
        if (this.field_145850_b.field_73011_w.getDimension() == 1) {
            this.generationState = TileSolarPanel.GenerationState.END;
        }
        if (this.field_145850_b.field_73011_w.getDimension() == -1) {
            this.generationState = TileSolarPanel.GenerationState.NETHER;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74762_e("solarType") != 0) {
            this.solartype = nbttagcompound.func_74762_e("solarType");
        }
        if (nbttagcompound.func_74769_h("storage") > 0.0) {
            this.storage = nbttagcompound.func_74769_h("storage");
        }
        if (nbttagcompound.func_74769_h("maxStorage") > 0.0) {
            this.genDay = nbttagcompound.func_74769_h("genDay");
            this.genNight = nbttagcompound.func_74769_h("genNight");
            this.maxStorage = nbttagcompound.func_74769_h("maxStorage");
            this.production = nbttagcompound.func_74769_h("production");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("solarType", this.solartype);
        if (this.storage > 0.0) {
            nbttagcompound.func_74780_a("storage", this.storage);
        }
        if (this.maxStorage > 0.0) {
            nbttagcompound.func_74780_a("genDay", this.genDay);
            nbttagcompound.func_74780_a("genNight", this.genNight);
            nbttagcompound.func_74780_a("production", this.production);
            nbttagcompound.func_74780_a("maxStorage", this.maxStorage);
        }
        return nbttagcompound;
    }

    public double gaugeEnergyScaled(float i) {
        return this.progress * (double)i;
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating() && !this.addedToEnergyNet) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.func_145831_w(), this));
            this.addedToEnergyNet = true;
            new PacketUpdateFieldTile(this, "slot", this.inputslot);
        }
        this.updateVisibility();
        this.intialize();
        this.inputslot.update();
        this.inputslotA.update();
    }

    @Override
    public void onUnloaded() {
        if (IUCore.proxy.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.func_145831_w(), this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public double getPerEnergy() {
        return this.perenergy;
    }

    @Override
    public double getPastEnergy() {
        return this.pastEnergy;
    }

    @Override
    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    @Override
    public void addPerEnergy(double setEnergy) {
        this.perenergy += setEnergy;
    }

    @Override
    public boolean isSource() {
        return true;
    }

    @Override
    public double canExtractEnergy() {
        return Math.min(this.storage, this.production);
    }

    @Override
    public void extractEnergy(double amount) {
        this.storage -= amount;
    }

    @Override
    public int getSourceTier() {
        return this.machineTire;
    }

    public void updateTileEntityField() {
        if (this.field_145850_b != null) {
            new PacketUpdateFieldTile(this, "type", (Object)this.type);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("type")) {
            try {
                this.type = EnumType.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot")) {
            try {
                InvSlot slot = (InvSlot)DecoderHandler.decode(is);
                for (int i = 0; i < slot.size(); ++i) {
                    this.inputslot.put(i, slot.get(i));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
    }

    public ContainerSinSolarPanel getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSinSolarPanel(entityPlayer, this);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.gainFuel();
        if (this.generating > 0.0) {
            this.storage = this.storage + this.generating <= this.maxStorage ? (this.storage += this.generating) : this.maxStorage;
        }
        this.progress = Math.min(1.0, this.storage / this.maxStorage);
        if (this.storage < 0.0) {
            this.storage = 0.0;
        }
        if (this.maxStorage <= 0.0) {
            this.storage = 0.0;
        }
        if (this.func_145831_w().func_72820_D() % 20L == 0L) {
            int size1 = 0;
            for (ItemStack stack : this.inputslot) {
                if (stack.func_190926_b()) continue;
                size1 += stack.func_190916_E();
            }
            if (this.size != size1) {
                this.inputslot.update();
                this.size = size1;
            }
        }
    }

    public void gainFuel() {
        if (this.func_145831_w().field_73011_w.getWorldTime() % 80L == 0L) {
            new PacketUpdateFieldTile(this, "slot", this.inputslot);
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 40L == 0L) {
            this.updateVisibility();
            int type = this.solartype;
            this.solartype = this.inputslotA.solartype();
            if (type != this.solartype) {
                this.updateTileEntityField();
            }
            if (this.solartype == 0) {
                this.setActive("");
            } else {
                this.setActive(EnumType.getFromID(this.solartype).getNameType());
            }
        }
        switch (this.generationState) {
            case DAY: {
                this.generating = this.type.coefficient_day * this.genDay;
                break;
            }
            case NIGHT: {
                this.generating = this.type.coefficient_night * this.genNight;
                break;
            }
            case RAINDAY: {
                this.generating = this.type.coefficient_rain * this.type.coefficient_day * this.genDay;
                break;
            }
            case RAINNIGHT: {
                this.generating = this.type.coefficient_rain * this.type.coefficient_night * this.genNight;
                break;
            }
            case NETHER: {
                this.generating = this.type.coefficient_nether * this.genDay;
                break;
            }
            case END: {
                this.generating = this.type.coefficient_end * this.genDay;
                break;
            }
            case NONE: {
                this.generating = 0.0;
            }
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, (Object)this.type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.type = EnumType.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiSintezator(new ContainerSinSolarPanel(entityPlayer, this));
    }

    public void setType(EnumType type) {
        this.type = type;
    }

    public int setSolarType(EnumType type) {
        if (type == null) {
            this.setType(EnumType.DEFAULT);
            return 0;
        }
        this.setType(type);
        switch (type) {
            case AIR: {
                if (this.field_174879_c.func_177956_o() < 130) break;
                return 1;
            }
            case EARTH: {
                if (this.field_174879_c.func_177956_o() > 40) break;
                return 2;
            }
            case NETHER: {
                if (this.func_145831_w().field_73011_w.getDimension() != -1) break;
                return 3;
            }
            case END: {
                if (this.func_145831_w().field_73011_w.getDimension() != 1) break;
                return 4;
            }
            case NIGHT: {
                if (this.sunIsUp) break;
                return 5;
            }
            case DAY: {
                if (!this.sunIsUp) break;
                return 6;
            }
            case RAIN: {
                if (!this.func_145831_w().func_72896_J() && !this.func_145831_w().func_72911_I()) break;
                return 7;
            }
        }
        this.setType(EnumType.DEFAULT);
        return 0;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor var1, EnumFacing var2) {
        return true;
    }
}

