/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.bee;

import com.denfop.IUItem;
import com.denfop.api.bee.IBee;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.items.energy.ItemNet;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityHive
extends TileEntityBlock {
    private final IBee bee;

    public TileEntityHive(IBee bee) {
        this.bee = bee;
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            return player.func_184614_ca().func_77973_b() instanceof ItemNet;
        }
        return false;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        ItemStack stack = new ItemStack((Item)IUItem.jarBees);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74768_a("bee_id", this.bee.getId());
        nbt.func_74768_a("swarm", WorldBaseGen.random.nextInt(this.bee.getMaxSwarm() / 2) + 15);
        return Collections.singletonList(stack);
    }

    @Override
    public List<ItemStack> getAuxDrops(int fortune) {
        return super.getAuxDrops(fortune);
    }

    @Override
    public void onClicked(EntityPlayer player) {
        player.func_70097_a(IUDamageSource.bee, 5.0f);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return null;
    }

    @Override
    public BlockTileEntity getBlock() {
        return null;
    }
}

