/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.chemicalplant;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockChemicalPlant;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerChemicalController;
import com.denfop.gui.GuiChemicalController;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.chemicalplant.IController;
import com.denfop.tiles.chemicalplant.IExchanger;
import com.denfop.tiles.chemicalplant.IGenerator;
import com.denfop.tiles.chemicalplant.ISeparate;
import com.denfop.tiles.chemicalplant.IWaste;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityChemicalPlantController
extends TileMultiBlockBase
implements IController {
    public boolean work = false;
    List<IGenerator> generatorList = new ArrayList<IGenerator>();
    IWaste waste;
    List<ISeparate> separateList = new ArrayList<ISeparate>();
    List<IExchanger> exchangerList = new ArrayList<IExchanger>();

    public TileEntityChemicalPlantController() {
        super(InitMultiBlockSystem.ChemicalPlantMultiBlock);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockChemicalPlant.chemical_plant_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.chemicalPlant;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("work", this.work);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.isFull()) {
            Fluids.InternalFluidTank fluidTankWaste = this.waste.getFluidTank();
            int canAdd = fluidTankWaste.getCapacity() - fluidTankWaste.getFluidAmount();
            if (canAdd == 0) {
                return;
            }
            int defaultAdd = canAdd;
            for (ISeparate separate : this.separateList) {
                if (defaultAdd == 0) {
                    return;
                }
                Fluids.InternalFluidTank fluidTank = separate.getFluidTank();
                if (fluidTank.getFluidAmount() == 0) continue;
                canAdd = Math.min(Math.min(defaultAdd, fluidTank.getFluidAmount() / 10), 10);
                if (canAdd == 0) {
                    return;
                }
                double energy = 0.0;
                for (IGenerator generator : this.generatorList) {
                    energy += generator.getEnergy().getEnergy();
                }
                canAdd = (int)Math.min(energy / 5.0, (double)canAdd);
                block2: for (IExchanger exchanger : this.exchangerList) {
                    if (canAdd == 0) {
                        return;
                    }
                    Fluids.InternalFluidTank fluidTank1 = exchanger.getFluidTank();
                    int canAdd1 = (int)Math.min((double)canAdd, (double)fluidTank1.getFluidAmount() / 2.0);
                    defaultAdd -= canAdd1;
                    canAdd -= canAdd1;
                    fluidTankWaste.fill(new FluidStack(FluidName.fluidcryogen.getInstance(), canAdd1), true);
                    fluidTank1.drain(canAdd1 * 2, true);
                    fluidTank.drain(canAdd1 * 10, true);
                    double energy1 = canAdd1 * 5;
                    for (IGenerator generator : this.generatorList) {
                        if (generator.getEnergy().getEnergy() > energy1) {
                            generator.getEnergy().useEnergy(energy1);
                            continue block2;
                        }
                        energy1 -= generator.getEnergy().getEnergy();
                        generator.getEnergy().useEnergy(generator.getEnergy().getEnergy());
                    }
                }
            }
        }
    }

    public ContainerChemicalController getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerChemicalController(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiChemicalController(this.getGuiContainer(var1));
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.generatorList.clear();
            this.exchangerList.clear();
            this.separateList.clear();
            this.waste = null;
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IWaste.class);
        this.waste = (IWaste)this.func_145831_w().func_175625_s(pos1.get(0));
        List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IGenerator.class);
        for (BlockPos pos3 : pos2) {
            this.generatorList.add((IGenerator)this.func_145831_w().func_175625_s(pos3));
        }
        pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISeparate.class);
        for (BlockPos pos3 : pos2) {
            this.separateList.add((ISeparate)this.func_145831_w().func_175625_s(pos3));
        }
        pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IExchanger.class);
        for (BlockPos pos3 : pos2) {
            this.exchangerList.add((IExchanger)this.func_145831_w().func_175625_s(pos3));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.work = nbttagcompound.func_74767_n("work");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
    }

    @Override
    public void usingBeforeGUI() {
    }
}

