/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.crop;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.agriculture.CropInit;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.EnumSoil;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.agriculture.genetics.EnumGenetic;
import com.denfop.api.agriculture.genetics.GeneticTraits;
import com.denfop.api.agriculture.genetics.GeneticsManager;
import com.denfop.api.agriculture.genetics.Genome;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockCrop;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.state.TileEntityBlockStateContainer;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.proxy.ClientProxy;
import com.denfop.render.base.BakedBlockModel;
import com.denfop.render.crop.CropRender;
import com.denfop.render.crop.CropRenderState;
import com.denfop.render.crop.TileEntityDoubleCropRender;
import com.denfop.render.oilquarry.DataBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.bee.TileEntityApiary;
import com.denfop.tiles.crop.ICropTile;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class TileEntityCrop
extends TileEntityBlock
implements ICropTile {
    @SideOnly(value=Side.CLIENT)
    public DataBlock upDataBlock;
    public Block downBlock = null;
    public boolean hasDouble = false;
    Map<BlockPos, TileEntityCrop> cropMap = new HashMap<BlockPos, TileEntityCrop>();
    boolean added = false;
    private ICrop crop = null;
    private long BeeId = 0L;
    private Genome genome = null;
    private ItemStack cropItem = ItemStack.field_190927_a;
    private CropRenderState cropRenderState;
    private Radiation radLevel;
    private ChunkPos chunkPos;
    private Chunk chunk;
    private Biome biome;
    private int tickPest = 0;
    private IBlockState downState;
    private ChunkLevel chunkLevel;
    private int pestUse;
    private AxisAlignedBB axisAlignedBB;
    private List<ChunkPos> chunkPositions = new ArrayList<ChunkPos>();
    private Map<ChunkPos, List<TileEntityApiary>> chunkPosListMap = new HashMap<ChunkPos, List<TileEntityApiary>>();
    @SideOnly(value=Side.CLIENT)
    private Function render;
    private boolean humus;
    private boolean canGrow;

    public ItemStack getCropItem() {
        return this.cropItem;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockCrop.crop;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.crop;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasDouble = nbt.func_74767_n("hasDouble");
        this.pestUse = nbt.func_74771_c("pestUse");
        this.tickPest = nbt.func_74765_d("tickPest");
        if (nbt.func_74764_b("crop_id")) {
            int id = nbt.func_74762_e("crop_id");
            this.crop = CropNetwork.instance.getCrop(id).copy();
            this.crop.setTick(nbt.func_74762_e("tick"));
            this.crop.setGeneration(nbt.func_74762_e("generation"));
            this.cropItem = new ItemStack(nbt.func_74775_l("stack_crop"));
            this.genome = new Genome(this.cropItem);
            this.genome.loadCrop(this.crop);
        }
    }

    public int getPestUse() {
        return this.pestUse;
    }

    public void addPestUse() {
        ++this.pestUse;
    }

    public Block getDownBlock() {
        return this.downBlock;
    }

    public IBlockState getDownState() {
        return this.downState;
    }

    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("hasDouble", this.hasDouble);
        nbt.func_74774_a("pestUse", (byte)this.pestUse);
        nbt.func_74777_a("tickPest", (short)this.tickPest);
        if (this.crop != null) {
            nbt.func_74768_a("tick", this.crop.getTick());
            nbt.func_74768_a("generation", this.crop.getGeneration());
            nbt.func_74768_a("crop_id", this.crop.getId());
            nbt.func_74782_a("stack_crop", (NBTBase)this.cropItem.serializeNBT());
        }
        return nbt;
    }

    public void event() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175718_b(2005, this.field_174879_c, 0);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("hasDouble")) {
            try {
                this.hasDouble = (Boolean)DecoderHandler.decode(is);
                this.updateRenderState();
                this.rerender();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("tick")) {
            try {
                int stage = this.crop.getStage();
                this.crop.setTick((Integer)DecoderHandler.decode(is));
                this.updateRenderState();
                if (stage != this.crop.getStage() && !this.crop.getTopTexture().isEmpty()) {
                    Object blockState1;
                    this.cropRenderState.setNeedTwoTexture(true);
                    if (this.upDataBlock == null) {
                        blockState1 = this.block.func_176223_P().func_177226_a((IProperty)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active)).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing());
                        blockState1 = this.getExtendedState((TileEntityBlockStateContainer.PropertiesStateInstance)((Object)blockState1));
                        this.upDataBlock = new DataBlock((IBlockState)blockState1);
                        ClientProxy cfr_ignored_0 = (ClientProxy)IUCore.proxy;
                        IBakedModel model = ClientProxy.cropRender.createModel(this.cropRenderState);
                        this.upDataBlock.setState(model);
                    } else {
                        blockState1 = this.block.func_176223_P().func_177226_a((IProperty)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active)).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing());
                        blockState1 = this.getExtendedState((TileEntityBlockStateContainer.PropertiesStateInstance)((Object)blockState1));
                        this.upDataBlock.setBlockState((IBlockState)blockState1);
                        ClientProxy cfr_ignored_1 = (ClientProxy)IUCore.proxy;
                        IBakedModel model = ClientProxy.cropRender.createModel(this.cropRenderState);
                        this.upDataBlock.setState(model);
                    }
                    this.cropRenderState.setNeedTwoTexture(false);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("cropItem")) {
            try {
                this.cropItem = (ItemStack)DecoderHandler.decode(is);
                if (!this.cropItem.func_190926_b()) {
                    this.crop = ((ICropItem)this.cropItem.func_77973_b()).getCrop(this.cropItem.func_77952_i(), this.cropItem).copy();
                    this.genome = new Genome(this.cropItem);
                    this.genome.loadCrop(this.crop);
                } else {
                    this.crop = null;
                }
                this.updateRenderState();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("texture") && this.crop != null && !this.crop.getTopTexture().isEmpty()) {
            IBakedModel model;
            Object blockState1;
            this.cropRenderState.setNeedTwoTexture(true);
            if (this.upDataBlock == null) {
                blockState1 = this.block.func_176223_P().func_177226_a((IProperty)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active)).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing());
                blockState1 = this.getExtendedState((TileEntityBlockStateContainer.PropertiesStateInstance)((Object)blockState1));
                this.upDataBlock = new DataBlock((IBlockState)blockState1);
                ClientProxy cfr_ignored_2 = (ClientProxy)IUCore.proxy;
                model = ClientProxy.cropRender.createModel(this.cropRenderState);
                this.upDataBlock.setState(model);
            } else {
                blockState1 = this.block.func_176223_P().func_177226_a((IProperty)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active)).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing());
                blockState1 = this.getExtendedState((TileEntityBlockStateContainer.PropertiesStateInstance)((Object)blockState1));
                this.upDataBlock.setBlockState((IBlockState)blockState1);
                ClientProxy cfr_ignored_3 = (ClientProxy)IUCore.proxy;
                model = ClientProxy.cropRender.createModel(this.cropRenderState);
                this.upDataBlock.setState(model);
            }
            this.cropRenderState.setNeedTwoTexture(false);
        }
        if (name.equals("crop")) {
            try {
                if (this.crop != null) {
                    this.crop.readPacket((CustomPacketBuffer)((Object)DecoderHandler.decode(is)));
                    this.updateRenderState();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("cropItem1")) {
            this.cropItem = ItemStack.field_190927_a;
            this.crop = null;
            this.updateRenderState();
        }
    }

    public int getTickPest() {
        return this.tickPest;
    }

    public void setTickPest() {
        this.tickPest = 7000;
    }

    @Override
    public boolean canPlace(TileEntityBlock te, BlockPos pos, World world) {
        EnumSoil[] soil = EnumSoil.values();
        this.downState = world.func_180495_p(pos.func_177977_b());
        this.downBlock = this.downState.func_177230_c();
        for (EnumSoil soil1 : soil) {
            if (soil1 == EnumSoil.REDSTONE && (soil1.getState() == this.downState && !soil1.isIgnore() || soil1.getBlock() == this.downBlock && soil1.isIgnore() || this.downBlock == IUItem.humus || this.downBlock == Blocks.field_150439_ay)) {
                return true;
            }
            if (!(soil1.getState() == this.downState && !soil1.isIgnore() || soil1.getBlock() == this.downBlock && soil1.isIgnore()) && this.downBlock != IUItem.humus) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public void onNetworkUpdate(String field) {
        this.updateRenderState();
        this.rerender();
        super.onNetworkUpdate(field);
    }

    @Override
    public EnumPlantType getPlantType() {
        return EnumPlantType.Crop;
    }

    public Genome getGenome() {
        return this.genome;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.func_145831_w().field_72995_K && this.added) {
            CropNetwork.instance.removeCropFromWorld(this);
            this.added = false;
        }
        if (this.func_145831_w().field_72995_K) {
            GlobalRenderManager.removeRender(this.func_145831_w(), this.field_174879_c);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.chunkPos = new ChunkPos(this.field_174879_c);
            Radiation radiation1 = RadiationSystem.rad_system.getMap().get(this.chunkPos);
            if (radiation1 == null) {
                radiation1 = new Radiation(this.chunkPos);
                RadiationSystem.rad_system.addRadiation(radiation1);
            }
            this.radLevel = radiation1;
            ChunkLevel chunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(this.chunkPos);
            if (chunkLevel == null) {
                chunkLevel = new ChunkLevel(this.chunkPos, LevelPollution.VERY_LOW, 0.0);
                PollutionManager.pollutionManager.addChunkLevelSoil(chunkLevel);
            }
            this.chunkLevel = chunkLevel;
            this.chunk = this.func_145831_w().func_175726_f(this.field_174879_c);
            this.biome = this.func_145831_w().func_180494_b(this.field_174879_c);
            this.cropMap.clear();
            for (EnumFacing facing1 : ModUtils.horizontalFacings) {
                BlockPos pos1 = this.field_174879_c.func_177972_a(facing1);
                TileEntity tile = this.func_145831_w().func_175625_s(pos1);
                if (!(tile instanceof TileEntityCrop)) continue;
                this.cropMap.put(pos1, (TileEntityCrop)tile);
            }
            if (!this.added) {
                this.added = true;
                CropNetwork.instance.addNewCropToWorld(this);
            }
            this.axisAlignedBB = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 4), (double)(this.field_174879_c.func_177956_o() - 2), (double)(this.field_174879_c.func_177952_p() - 4), (double)(this.field_174879_c.func_177958_n() + 4), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 4));
            int minX = (int)Math.floor(this.axisAlignedBB.field_72340_a) >> 4;
            int maxX = (int)Math.floor(this.axisAlignedBB.field_72336_d) >> 4;
            int minZ = (int)Math.floor(this.axisAlignedBB.field_72339_c) >> 4;
            int maxZ = (int)Math.floor(this.axisAlignedBB.field_72334_f) >> 4;
            this.chunkPositions.clear();
            this.chunkPosListMap.clear();
            for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.chunkPositions.add(new ChunkPos(chunkX, chunkZ));
                }
            }
            for (ChunkPos chunkPos : this.chunkPositions) {
                this.chunkPosListMap.put(chunkPos, BeeNetwork.instance.getApiaryFromChunk(this.field_145850_b, chunkPos));
            }
            this.sendUpdatePacket("texture", 0);
            this.sendUpdatePacket("hasDouble", this.hasDouble);
        }
        if (this.func_145831_w().field_72995_K) {
            this.render = this.createFunction();
            GlobalRenderManager.addRender(this.func_145831_w(), this.field_174879_c, this.render);
            this.updateRenderState();
        }
        if (this.downState == null) {
            this.downState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
            this.downBlock = this.downState.func_177230_c();
        }
        this.humus = this.downBlock == IUItem.humus;
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), this.downState);
    }

    @SideOnly(value=Side.CLIENT)
    public Function createFunction() {
        Function<Object, Object> function = o -> {
            if (this.upDataBlock != null && this.crop != null && this.crop.getRender() == 3) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)this.func_174877_v().func_177958_n(), (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p());
                RenderHelper.func_74519_b();
                GlStateManager.func_179132_a((boolean)true);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                TileEntityDoubleCropRender.render((BakedBlockModel)this.upDataBlock.getState(), this.upDataBlock.getBlockState(), null);
                GL11.glPopMatrix();
            }
            return 0;
        };
        return function;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        customPacketBuffer.writeBoolean(this.hasDouble);
        customPacketBuffer.writeBoolean(this.crop != null);
        if (this.crop != null) {
            customPacketBuffer.func_150788_a(this.cropItem);
            customPacketBuffer.writeInt(this.crop.getId());
            customPacketBuffer.writeBytes((ByteBuf)this.crop.writePacket());
        }
        return customPacketBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        this.hasDouble = customPacketBuffer.readBoolean();
        boolean hasCrop = customPacketBuffer.readBoolean();
        if (hasCrop) {
            try {
                this.cropItem = customPacketBuffer.func_150791_c();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int id = customPacketBuffer.readInt();
            this.crop = CropNetwork.instance.getCrop(id).copy();
            this.crop.readPacket(customPacketBuffer);
            this.updateRenderState();
            this.rerender();
        }
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.func_177958_n() > this.axisAlignedBB.field_72340_a && (double)vec.func_177958_n() < this.axisAlignedBB.field_72336_d) {
            if ((double)vec.func_177956_o() > this.axisAlignedBB.field_72338_b && (double)vec.func_177956_o() < this.axisAlignedBB.field_72337_e) {
                return (double)vec.func_177952_p() > this.axisAlignedBB.field_72339_c && (double)vec.func_177952_p() < this.axisAlignedBB.field_72334_f;
            }
            return false;
        }
        return false;
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.field_174879_c.func_177977_b().equals((Object)neighborPos)) {
            if (this.crop != null && !this.cropItem.func_190926_b() && this.crop.getId() != 3) {
                ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.cropItem, 1);
                this.cropItem = ItemStack.field_190927_a;
                this.crop = null;
                new PacketUpdateFieldTile(this, "cropItem1", "");
            }
            this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), this.field_145850_b.field_72995_K ? 11 : 3);
            ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, new ItemStack((Block)IUItem.crop), this.hasDouble ? 2 : 1);
        }
        for (EnumFacing facing1 : ModUtils.horizontalFacings) {
            if (!this.field_174879_c.func_177972_a(facing1).equals((Object)neighborPos)) continue;
            if (this.cropMap.containsKey(neighborPos)) {
                this.cropMap.remove(neighborPos);
                continue;
            }
            TileEntity tile = this.func_145831_w().func_175625_s(neighborPos);
            if (!(tile instanceof TileEntityCrop)) continue;
            this.cropMap.put(neighborPos, (TileEntityCrop)tile);
        }
    }

    public List<ItemStack> harvest(boolean dropInWorld) {
        this.crop.setGeneration(this.crop.getGeneration() + 1);
        this.crop.setTick(0);
        new PacketUpdateFieldTile(this, "tick", 0);
        if (dropInWorld) {
            for (ItemStack stack1 : this.crop.getDrops()) {
                ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, stack1, this.crop.getYield());
            }
            if (WorldBaseGen.random.nextInt(100) < 25) {
                ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.cropItem, WorldBaseGen.random.nextInt(this.crop.getSizeSeed() + 1));
            }
        }
        if (this.crop.getId() != 3) {
            this.canAdaptationCrop();
        }
        return this.crop.getDrops();
    }

    public AxisAlignedBB getAxisAlignedBB() {
        return this.axisAlignedBB;
    }

    public List<ChunkPos> getChunkPositions() {
        return this.chunkPositions;
    }

    public Map<ChunkPos, List<TileEntityApiary>> getChunkPosListMap() {
        return this.chunkPosListMap;
    }

    private void canAdaptationCrop() {
        if (WorldBaseGen.random.nextInt(100) != 0) {
            return;
        }
        Genome genome = this.genome;
        int geneticAdaptive = genome.hasGenome(EnumGenetic.GENOME_ADAPTIVE) ? genome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class) : 5;
        int geneticResistance = genome.hasGenome(EnumGenetic.GENOME_RESISTANCE) ? genome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class) : 5;
        block21: for (EnumGenetic enumGenetic : EnumGenetic.values()) {
            GeneticTraits geneticTraits;
            boolean canUpgrade;
            List<GeneticTraits> genetic = GeneticsManager.enumGeneticListMap.get((Object)enumGenetic);
            if (WorldBaseGen.random.nextInt(100) > geneticAdaptive || WorldBaseGen.random.nextInt(100) <= geneticResistance) continue;
            boolean hasGenome = genome.hasGenome(enumGenetic);
            if (!hasGenome && WorldBaseGen.random.nextInt(100) == 0) {
                GeneticTraits geneticTraits2 = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                genome.addGenome(geneticTraits2, this.cropItem);
                continue;
            }
            boolean needRemove = WorldBaseGen.random.nextInt(geneticResistance) > WorldBaseGen.random.nextInt(geneticAdaptive);
            boolean bl = canUpgrade = WorldBaseGen.random.nextInt(geneticAdaptive) > WorldBaseGen.random.nextInt(geneticResistance);
            if ((needRemove || !canUpgrade) && hasGenome) {
                geneticTraits = genome.removeGenome(enumGenetic, this.cropItem);
                GeneticsManager.instance.deleteGenomeCrop(this.crop, geneticTraits);
                continue;
            }
            if (!canUpgrade) continue;
            switch (enumGenetic) {
                case SUN: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.cropItem);
                    this.crop.setSun(true);
                    break block21;
                }
                case BIOME: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        List<Biome> biomeList = Genome.geneticBiomes.get((Object)geneticTraits);
                        if (this.crop.canGrowInBiome(biomeList.get(0))) break block21;
                        biomeList.forEach(this.crop::addBiome);
                        genome.addGenome(geneticTraits, this.cropItem);
                        break block21;
                    }
                    geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                    GeneticTraits geneticTraits1 = genome.removeGenome(enumGenetic, this.cropItem);
                    GeneticsManager.instance.deleteGenomeCrop(this.crop, geneticTraits1);
                    List<Biome> biomeList = Genome.geneticBiomes.get((Object)geneticTraits);
                    biomeList.forEach(this.crop::addBiome);
                    genome.addGenome(geneticTraits, this.cropItem);
                    break block21;
                }
                case AIR: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setAirRequirements(geneticTraits.getValue(LevelPollution.class));
                        break block21;
                    }
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        GeneticTraits traits = genome.getGenome(enumGenetic);
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setAirRequirements(traits.getPrev().getValue(LevelPollution.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setAirRequirements(LevelPollution.LOW);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setAirRequirements(traits1.getValue(LevelPollution.class));
                    break block21;
                }
                case SOIL: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        LevelPollution levelPollution = geneticTraits.getValue(LevelPollution.class);
                        if (levelPollution.ordinal() < this.chunkLevel.getLevelPollution().ordinal()) break block21;
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setAirRequirements(levelPollution);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    LevelPollution levelPollution = traits.getValue(LevelPollution.class);
                    boolean bl2 = needDecrease = WorldBaseGen.random.nextBoolean() && this.chunkLevel.getLevelPollution().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setSoilRequirements(traits.getPrev().getValue(LevelPollution.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setSoilRequirements(LevelPollution.LOW);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setSoilRequirements(traits1.getValue(LevelPollution.class));
                    break block21;
                }
                case WATER: {
                    if (!hasGenome) {
                        genome.addGenome(genetic.get(0), this.cropItem);
                        this.crop.setWaterRequirement(0);
                        break block21;
                    }
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (!needDecrease) break block21;
                    genome.removeGenome(genetic.get(0), this.cropItem);
                    this.crop.setWaterRequirement(this.crop.getDefaultWaterRequirement());
                    break block21;
                }
                case PEST: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setPestResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setPestResistance(this.crop.getPestResistance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setPestResistance(this.crop.getPestResistance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setPestResistance(this.crop.getPestResistance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case WEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.addChanceWeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.addChanceWeed(-level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.addChanceWeed(-level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.addChanceWeed(-level + traits1.getValue(Integer.class));
                    break block21;
                }
                case LIGHT: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setLight(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setLight(traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setLight(this.crop.getDefaultLightLevel());
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setLight(traits1.getValue(Integer.class));
                    break block21;
                }
                case RADIATION: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        EnumLevelRadiation levelPollution = geneticTraits.getValue(EnumLevelRadiation.class);
                        if (levelPollution.ordinal() < this.radLevel.getLevel().ordinal()) break block21;
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setRadiationRequirements(levelPollution);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    EnumLevelRadiation levelPollution = traits.getValue(EnumLevelRadiation.class);
                    boolean bl3 = needDecrease = WorldBaseGen.random.nextBoolean() && this.radLevel.getLevel().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setRadiationRequirements(traits.getPrev().getValue(EnumLevelRadiation.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setRadiationRequirements(EnumLevelRadiation.LOW);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setRadiationRequirements(traits1.getValue(EnumLevelRadiation.class));
                    break block21;
                }
                case SEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.addSizeSeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.addSizeSeed(-level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.addSizeSeed(-level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.addSizeSeed(-level + traits1.getValue(Integer.class));
                    break block21;
                }
                case YIELD: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setYield(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setYield(this.crop.getYield() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setYield(this.crop.getYield() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setYield(this.crop.getYield() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case BEE: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.cropItem);
                    this.crop.setBeeCombine(true);
                    break block21;
                }
                case NIGHT_GROW: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.cropItem);
                    this.crop.setNight(true);
                    break block21;
                }
                case SOIL_BLOCK: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.cropItem);
                    this.crop.setIgnoreSoil(true);
                    break block21;
                }
                case CHANCE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setChance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setChance(this.crop.getChance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setChance(this.crop.getChance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setChance(this.crop.getChance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case GROW_SPEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        double level = geneticTraits.getValue(Double.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setGrowthSpeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    double level = traits.getValue(Double.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setGrowthSpeed(traits.getPrev().getValue(Double.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setGrowthSpeed(1.0);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setGrowthSpeed(traits1.getValue(Double.class));
                    break block21;
                }
                case WEATHER: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setWeatherResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setWeatherResistance(traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setWeatherResistance(this.crop.getDefaultWeatherResistance());
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setWeatherResistance(traits1.getValue(Integer.class));
                    break block21;
                }
                case GENOME_ADAPTIVE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setGenomeAdaptive(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setGenomeAdaptive(this.crop.getGenomeAdaptive() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setGenomeAdaptive(this.crop.getGenomeAdaptive() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setGenomeAdaptive(this.crop.getGenomeAdaptive() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case GENOME_RESISTANCE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, this.cropItem);
                        this.crop.setGenomeResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.cropItem);
                            genome.addGenome(traits.getPrev(), this.cropItem);
                            this.crop.setGenomeResistance(this.crop.getGenomeResistance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, this.cropItem);
                        this.crop.setGenomeResistance(this.crop.getGenomeResistance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, this.cropItem);
                    genome.addGenome(traits1, this.cropItem);
                    this.crop.setGenomeResistance(this.crop.getGenomeResistance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                default: {
                    continue block21;
                }
            }
        }
    }

    public long getBeeId() {
        return this.BeeId;
    }

    public void setBeeId(long beeId) {
        this.BeeId = beeId;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>(super.getSelfDrops(fortune, wrench));
        if (this.hasDouble) {
            list.add(this.getPickBlock(null, null));
        }
        if (this.crop != null && this.crop.getId() != 3) {
            list.add(this.cropItem);
        }
        return list;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.crop != null) {
            this.BeeId = 0L;
            boolean work = false;
            if (this.func_145831_w().func_72820_D() % 20L == 0L) {
                if (this.chunk == null) {
                    this.chunkPos = new ChunkPos(this.field_174879_c);
                    Radiation radiation1 = RadiationSystem.rad_system.getMap().get(this.chunkPos);
                    if (radiation1 == null) {
                        radiation1 = new Radiation(this.chunkPos);
                        RadiationSystem.rad_system.addRadiation(radiation1);
                    }
                    this.radLevel = radiation1;
                    ChunkLevel chunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(this.chunkPos);
                    if (chunkLevel == null) {
                        chunkLevel = new ChunkLevel(this.chunkPos, LevelPollution.VERY_LOW, 0.0);
                        PollutionManager.pollutionManager.addChunkLevelSoil(chunkLevel);
                    }
                    this.chunkLevel = chunkLevel;
                    this.chunk = this.func_145831_w().func_175726_f(this.field_174879_c);
                    this.biome = this.func_145831_w().func_180494_b(this.field_174879_c);
                }
                if (this.func_145831_w().func_72820_D() % 60L == 0L) {
                    this.canGrow = CropNetwork.instance.canGrow(this.field_145850_b, this.field_174879_c, this.chunkPos, this.crop, this.radLevel, this.chunk, this.biome, this.chunkLevel);
                }
                if (this.canGrow && (this.func_145831_w().func_72820_D() % 400L != 0L || this.canGrow())) {
                    if (this.crop.getTick() < this.crop.getMaxTick() && this.func_145831_w().func_72820_D() % 400L == 0L && this.crop.getId() != 3) {
                        int chanceWeed = 100 - this.crop.getChanceWeed() - 5 * (this.crop.getSizeSeed() - 1);
                        work = true;
                        if (chanceWeed > 0 && this.func_145831_w().func_72820_D() % 400L == 0L && this.tickPest == 0 && WorldBaseGen.random.nextInt(100) < chanceWeed && WorldBaseGen.random.nextInt(100) == 0) {
                            this.crop = CropInit.weed_seed.copy();
                            this.pestUse = 0;
                            this.cropItem = CropInit.weed_seed.getStack();
                            this.genome = new Genome(this.cropItem);
                            new PacketUpdateFieldTile(this, "cropItem", this.cropItem);
                            new PacketUpdateFieldTile(this, "crop", this.crop);
                        }
                    }
                    if (this.radLevel.getLevel().ordinal() > EnumLevelRadiation.HIGH.ordinal() && this.crop.getId() != 3) {
                        this.canAdaptationCrop();
                    }
                    this.tickPest = this.tickPest >= 20 ? (this.tickPest -= 20) : 0;
                    if (this.crop.getTick() < this.crop.getMaxTick()) {
                        boolean needUpdate;
                        int stage = this.crop.getStage();
                        this.crop.addTick((int)(20.0 * this.crop.getGrowthSpeed() * (this.humus ? 1.25 : 1.0)));
                        boolean bl = needUpdate = stage != this.crop.getStage();
                        if (needUpdate) {
                            new PacketUpdateFieldTile(this, "tick", this.crop.getTick());
                        }
                    }
                }
            }
        }
        if (this.func_145831_w().func_72820_D() % 200L == 0L && this.pestUse > 0) {
            --this.pestUse;
        }
        if (this.func_145831_w().func_72820_D() % 400L == 0L && this.tickPest == 0 && this.crop == null && !this.hasDouble && WorldBaseGen.random.nextInt(200) == 0) {
            this.crop = CropInit.weed_seed.copy();
            this.pestUse = 0;
            this.cropItem = CropInit.weed_seed.getStack();
            this.genome = new Genome(this.cropItem);
            new PacketUpdateFieldTile(this, "cropItem", this.cropItem);
            new PacketUpdateFieldTile(this, "crop", this.crop);
        }
        if (this.hasDouble && this.func_145831_w().func_72820_D() % 40L == 0L && !this.cropMap.isEmpty() && WorldBaseGen.random.nextInt(50) == 0) {
            int k;
            int i;
            List crops = this.cropMap.values().stream().filter(cropTile -> cropTile.crop != null && cropTile.crop.getTick() == cropTile.crop.getMaxTick()).collect(Collectors.toList());
            if (crops.size() < 2) {
                if (this.func_145831_w().func_72820_D() % 400L == 0L && this.tickPest == 0 && this.crop == null && WorldBaseGen.random.nextInt(200) == 0) {
                    this.hasDouble = false;
                    new PacketUpdateFieldTile(this, "hasDouble", this.hasDouble);
                    this.crop = CropInit.weed_seed.copy();
                    this.pestUse = 0;
                    this.cropItem = CropInit.weed_seed.getStack();
                    new PacketUpdateFieldTile(this, "cropItem", this.cropItem);
                    new PacketUpdateFieldTile(this, "crop", this.crop);
                }
                return;
            }
            boolean can = false;
            Map<ICrop, TileEntityCrop> cropMap1 = crops.stream().collect(Collectors.toMap(cropTile -> cropTile.crop, cropTile -> cropTile, (existing, replacement) -> existing));
            ArrayList<List<ICrop>> combinations = new ArrayList<List<ICrop>>();
            for (i = 0; i < crops.size() - 1; ++i) {
                for (int j = i + 1; j < crops.size(); ++j) {
                    combinations.add(Arrays.asList(((TileEntityCrop)crops.get((int)i)).crop, ((TileEntityCrop)crops.get((int)j)).crop));
                }
            }
            for (i = 0; i < crops.size() - 2; ++i) {
                for (int j = i + 1; j < crops.size() - 1; ++j) {
                    for (k = j + 1; k < crops.size(); ++k) {
                        combinations.add(Arrays.asList(((TileEntityCrop)crops.get((int)i)).crop, ((TileEntityCrop)crops.get((int)j)).crop, ((TileEntityCrop)crops.get((int)k)).crop));
                    }
                }
            }
            for (i = 0; i < crops.size() - 3; ++i) {
                for (int j = i + 1; j < crops.size() - 2; ++j) {
                    for (k = j + 1; k < crops.size() - 1; ++k) {
                        for (int l = k + 1; l < crops.size(); ++l) {
                            combinations.add(Arrays.asList(((TileEntityCrop)crops.get((int)i)).crop, ((TileEntityCrop)crops.get((int)j)).crop, ((TileEntityCrop)crops.get((int)k)).crop, ((TileEntityCrop)crops.get((int)l)).crop));
                        }
                    }
                }
            }
            for (List list : combinations) {
                ICrop newCrop;
                boolean isEquals = true;
                for (ICrop crop1 : list) {
                    isEquals = ((ICrop)list.get(0)).getId() == crop1.getId();
                }
                int chance = 0;
                for (ICrop crop1 : list) {
                    int additionChance = 0;
                    if (crop1.isBeeCombine()) {
                        TileEntityCrop crop2 = cropMap1.get(crop1);
                        block12: for (List<TileEntityApiary> apiaries : crop2.getChunkPosListMap().values()) {
                            for (TileEntityApiary apiary : apiaries) {
                                if (!this.contains(apiary.func_174877_v()) || apiary.getQueen() == null || !((double)apiary.ill * 1.0 / (double)apiary.bees < 0.2)) continue;
                                additionChance += apiary.getQueen().getChance();
                                break block12;
                            }
                        }
                    }
                    chance = Math.max(chance, crop1.getChance() + additionChance);
                }
                if (WorldBaseGen.random.nextInt(100) > chance && WorldBaseGen.random.nextInt(100) != 0 || (isEquals ? !CropNetwork.instance.canPlantCrop((newCrop = CropNetwork.instance.getCrop(((ICrop)list.get(0)).getId()).copy()).getStackForDrop(), this.field_145850_b, this.field_174879_c, this.downState, this.biome) : (newCrop = CropNetwork.instance.canCropCombine(list)) == null || !CropNetwork.instance.canPlantCrop(newCrop.getStackForDrop(), this.field_145850_b, this.field_174879_c, this.downState, this.biome))) continue;
                int size = list.size();
                Genome combinedGenome = new Genome(newCrop.getStackForDrop().func_77946_l());
                for (int i2 = 0; i2 < size; ++i2) {
                    if (i2 - 1 == 0 && i2 + 1 == size) continue;
                    int nextIndex = (i2 + 1) % size;
                    Genome currentGenome = cropMap1.get(list.get(i2)).getGenome();
                    Genome nextGenome = cropMap1.get(list.get(nextIndex)).getGenome();
                    int adaptive = currentGenome.hasGenome(EnumGenetic.GENOME_ADAPTIVE) ? currentGenome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class) : 5;
                    int resistance = nextGenome.hasGenome(EnumGenetic.GENOME_RESISTANCE) ? nextGenome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class) : 5;
                    this.addGenome(new ArrayList<GeneticTraits>(currentGenome.getGeneticTraitsMap().values()), combinedGenome, adaptive, resistance);
                }
                this.hasDouble = false;
                new PacketUpdateFieldTile(this, "hasDouble", this.hasDouble);
                this.cropItem = combinedGenome.getStack();
                newCrop.setStack(this.cropItem);
                this.crop = newCrop;
                this.genome = combinedGenome;
                this.genome.loadCrop(this.crop);
                new PacketUpdateFieldTile(this, "cropItem", this.cropItem);
                new PacketUpdateFieldTile(this, "crop", this.crop);
                can = true;
                break;
            }
            if (!can && this.func_145831_w().func_72820_D() % 400L == 0L && this.tickPest == 0 && this.crop == null && WorldBaseGen.random.nextInt(200) == 0) {
                this.hasDouble = false;
                new PacketUpdateFieldTile(this, "hasDouble", this.hasDouble);
                this.crop = CropInit.weed_seed.copy();
                this.pestUse = 0;
                this.cropItem = CropInit.weed_seed.getStack();
                new PacketUpdateFieldTile(this, "cropItem", this.cropItem);
                new PacketUpdateFieldTile(this, "crop", this.crop);
            }
        }
    }

    public void addGenome(List<GeneticTraits> genericTraits, Genome genome2, int geneticAdaptive, int geneticResistance) {
        for (GeneticTraits geneticTraits : genericTraits) {
            if (WorldBaseGen.random.nextInt(100) > geneticAdaptive || WorldBaseGen.random.nextInt(100) <= geneticResistance || genome2.hasGenome(geneticTraits.getGenetic())) continue;
            genome2.addGenome(geneticTraits, this.cropItem);
        }
    }

    private boolean canGrow() {
        if (!this.cropMap.isEmpty()) {
            List crops = ((Stream)this.cropMap.values().stream().parallel()).filter(tileEntityCrop -> tileEntityCrop.crop != null && tileEntityCrop.crop.getId() != 3).collect(Collectors.toList());
            for (TileEntityCrop crop1 : crops) {
                if (!this.crop.compatibilityWithCrop(crop1.getCrop())) continue;
                this.conflictCrop(crop1.getCrop(), crop1.getGenome());
            }
        }
        return true;
    }

    private void conflictCrop(ICrop crop, Genome genome) {
        if (!WorldBaseGen.random.nextBoolean()) {
            return;
        }
        int party = WorldBaseGen.random.nextInt(2);
        int adaptive1 = this.getGenomeLevel(genome, EnumGenetic.GENOME_ADAPTIVE);
        int adaptive2 = this.getGenomeLevel(this.genome, EnumGenetic.GENOME_ADAPTIVE);
        int resistance1 = this.getGenomeLevel(genome, EnumGenetic.GENOME_RESISTANCE);
        int resistance2 = this.getGenomeLevel(this.genome, EnumGenetic.GENOME_RESISTANCE);
        ArrayList<GeneticTraits> traitsList = party == 0 ? new ArrayList<GeneticTraits>(genome.getGeneticTraitsMap().values()) : new ArrayList<GeneticTraits>(this.genome.getGeneticTraitsMap().values());
        Genome sourceGenome = party == 0 ? genome : this.genome;
        Genome targetGenome = party == 0 ? this.genome : genome;
        ICrop sourceCrop = party == 0 ? crop : this.crop;
        ICrop targetCrop = party == 0 ? this.crop : crop;
        int sourceResistance = party == 0 ? resistance1 : resistance2;
        int targetResistance = party == 0 ? resistance2 : resistance1;
        int sourceAdaptive = party == 0 ? adaptive2 : adaptive1;
        int targetAdaptive = party == 0 ? adaptive1 : adaptive2;
        int max = 0;
        for (GeneticTraits trait : traitsList) {
            if (max == 2) break;
            if (WorldBaseGen.random.nextInt(sourceResistance) >= WorldBaseGen.random.nextInt(sourceAdaptive) || !sourceGenome.hasGenome(trait.getGenetic()) || targetGenome.hasGenome(trait.getGenetic())) continue;
            sourceGenome.removeGenome(trait.getGenetic(), sourceGenome.getStack());
            GeneticsManager.instance.deleteGenomeCrop(sourceCrop, trait);
            ++max;
            if (WorldBaseGen.random.nextInt(targetResistance) >= WorldBaseGen.random.nextInt(targetAdaptive)) continue;
            targetGenome.addGenome(trait, targetGenome.getStack());
            GeneticsManager.instance.addGenomeCrop(targetCrop, trait);
        }
    }

    private int getGenomeLevel(Genome genome, EnumGenetic genetic) {
        return genome.hasGenome(genetic) ? genome.getLevelGenome(genetic, Integer.class) : 5;
    }

    @Override
    public void updateEntityClient() {
        super.updateEntityClient();
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.func_145831_w().field_72995_K || this.rightClick(player, hand);
    }

    @Override
    public boolean onSneakingActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.cropItem.func_190926_b() && this.crop != null && !this.func_145831_w().field_72995_K && this.crop.getId() != 3) {
            if (this.crop != null && this.crop.getTick() == this.crop.getMaxTick() && this.crop.getId() != 3) {
                this.harvest(true);
            }
            ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.cropItem, 1);
            this.cropItem = ItemStack.field_190927_a;
            this.crop = null;
            this.genome = null;
            new PacketUpdateFieldTile(this, "cropItem1", "");
        }
        return super.onSneakingActivated(player, hand, side, hitX, hitY, hitZ);
    }

    private boolean rightClick(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.hasDouble && this.crop == null) {
            this.handleDoubleCropRemoval(player);
            return true;
        }
        if (stack.func_77969_a(this.getPickBlock(player, null)) && !this.hasDouble && this.crop == null) {
            stack.func_190918_g(1);
            this.hasDouble = true;
            this.sendUpdatePacket("hasDouble", this.hasDouble);
            return true;
        }
        if (stack.func_77973_b() instanceof ItemHoe && !this.hasDouble && this.crop != null && this.crop.getId() == 3) {
            this.resetCrop();
            this.sendUpdatePacket("cropItem1", "");
            return true;
        }
        if (stack.func_77973_b() == IUItem.fertilizer && !this.hasDouble && this.crop != null && this.crop.getTick() < this.crop.getMaxTick() && this.crop.getId() != 3) {
            this.fertilizeCrop(stack);
            return true;
        }
        if (stack.func_77973_b() instanceof ICropItem && !this.hasDouble && this.crop == null && CropNetwork.instance.canPlantCrop(stack, this.field_145850_b, this.field_174879_c, this.downState, this.biome)) {
            this.plantNewCrop(stack);
            return true;
        }
        if (this.crop != null && this.crop.getTick() == this.crop.getMaxTick() && this.crop.getId() != 3) {
            this.harvest(true);
            return true;
        }
        return false;
    }

    private void handleDoubleCropRemoval(EntityPlayer player) {
        ItemStack stack1 = this.getPickBlock(player, null);
        this.hasDouble = false;
        ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, stack1);
        this.sendUpdatePacket("hasDouble", this.hasDouble);
    }

    public void resetCrop() {
        this.crop = null;
        this.cropItem = ItemStack.field_190927_a;
        this.genome = null;
    }

    public void fertilizeCrop(ItemStack stack) {
        stack.func_190918_g(1);
        int stage = this.crop.getStage();
        this.crop.addTick((int)((double)this.crop.getMaxTick() * 0.2));
        ++this.pestUse;
        this.event();
        if (this.pestUse > 40) {
            this.handlePestResistance();
        } else {
            this.checkAndUpdateCropStage(stage);
        }
    }

    private void handlePestResistance() {
        boolean pestResistance;
        int resistance = this.crop.getPestResistance();
        boolean bl = pestResistance = WorldBaseGen.random.nextInt(100) < 100 - resistance;
        if (!pestResistance) {
            this.crop = CropInit.weed_seed.copy();
            this.pestUse = 0;
            this.cropItem = CropInit.weed_seed.getStack();
            this.genome = new Genome(this.cropItem);
            this.sendUpdatePacket("cropItem", this.cropItem);
            this.sendUpdatePacket("crop", this.crop);
        } else {
            this.checkAndUpdateCropStage(this.crop.getStage());
        }
    }

    private void checkAndUpdateCropStage(int previousStage) {
        boolean needUpdate;
        boolean bl = needUpdate = previousStage != this.crop.getStage();
        if (needUpdate) {
            this.sendUpdatePacket("tick", this.crop.getTick());
        }
    }

    public void plantNewCrop(ItemStack stack) {
        this.cropItem = stack.func_77946_l();
        this.cropItem.func_190920_e(1);
        stack.func_190918_g(1);
        this.genome = new Genome(this.cropItem);
        this.crop = CropNetwork.instance.getCropFromStack(this.cropItem).copy();
        this.genome.loadCrop(this.crop);
        this.sendUpdatePacket("cropItem", this.cropItem);
        this.sendUpdatePacket("crop", this.crop);
    }

    public void sendUpdatePacket(String fieldName, Object value) {
        new PacketUpdateFieldTile(this, fieldName, value);
    }

    @Override
    public SoundType getBlockSound(Entity entity) {
        return SoundType.field_185850_c;
    }

    @Override
    public AxisAlignedBB getPhysicsBoundingBox() {
        return new AxisAlignedBB((double)0.2f, -0.0625, (double)0.2f, (double)0.8f, (double)0.85f, (double)0.8f);
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>();
        if (forCollision) {
            ret.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        } else {
            ret.add(new AxisAlignedBB((double)0.2f, -0.0625, (double)0.2f, (double)0.8f, (double)0.85f, (double)0.8f));
        }
        return ret;
    }

    public boolean isHasDouble() {
        return this.hasDouble;
    }

    @Override
    public ICrop getCrop() {
        return this.crop;
    }

    @Override
    public TileEntityBlockStateContainer.PropertiesStateInstance getExtendedState(TileEntityBlockStateContainer.PropertiesStateInstance state) {
        state = super.getExtendedState(state);
        CropRenderState renderState = this.cropRenderState;
        if (renderState != null) {
            state = state.withProperties(CropRender.renderStateProperty, renderState);
        }
        return state;
    }

    private void updateRenderState() {
        this.cropRenderState = new CropRenderState(this.crop, this.hasDouble, false);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }
}

