/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.crop;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.agriculture.CropInit;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.EnumSoil;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.agriculture.genetics.EnumGenetic;
import com.denfop.api.agriculture.genetics.GeneticTraits;
import com.denfop.api.agriculture.genetics.GeneticsManager;
import com.denfop.api.agriculture.genetics.Genome;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.blocks.FluidName;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerMultiCrop;
import com.denfop.gui.GuiMultiCrop;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMultiCrop
extends TileEntityInventory {
    public final InvSlot downBlockSlot;
    public final InvSlot upBlockSlot;
    public final Fluids.InternalFluidTank fluidPestTank;
    public final Fluids.InternalFluidTank fluidWaterTank;
    public final InvSlotOutput outputSlot;
    public final InvSlot fertilizerSlot;
    private final Fluids fluids;
    public ICrop[] crop;
    public Genome[] genome;
    public int[] tickPest;
    public int[] pestUse;
    public EnumSoil[] enumSoils;
    public boolean[] place;
    public int[] tickSoil;
    public int[] maxTickSoil;
    private Radiation radLevel;
    private ChunkPos chunkPos;
    private Chunk chunk;
    private Biome biome;
    private ChunkLevel chunkLevel;

    public TileEntityMultiCrop(int col) {
        this.tickPest = new int[col];
        this.pestUse = new int[col];
        this.enumSoils = new EnumSoil[col];
        this.crop = new ICrop[col];
        this.genome = new Genome[col];
        this.place = new boolean[col];
        this.tickSoil = new int[col];
        this.maxTickSoil = new int[col];
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidWaterTank = this.fluids.addTankInsert("waterTank", 16000, Fluids.fluidPredicate(FluidRegistry.WATER));
        this.fluidPestTank = this.fluids.addTankInsert("pestTank", 16000, Fluids.fluidPredicate(FluidName.fluidweed_ex.getInstance()));
        this.outputSlot = new InvSlotOutput(this, 9);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1 * (double)col / 2.0));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1 * (double)col / 2.0));
        this.fertilizerSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() == IUItem.fertilizer;
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.FERTILIZER;
            }
        };
        this.downBlockSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, col){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return EnumSoil.contain(stack);
            }

            @Override
            public int getStackSizeLimit() {
                return 1;
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (content.func_190926_b()) {
                    TileEntityMultiCrop.this.enumSoils[index] = null;
                    TileEntityMultiCrop.this.place[index] = false;
                } else {
                    TileEntityMultiCrop.this.enumSoils[index] = EnumSoil.get(content);
                }
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.BLOCKS;
            }
        };
        this.upBlockSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, col){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof ICropItem && TileEntityMultiCrop.this.canPlace(((ICropItem)stack.func_77973_b()).getCrop(stack.func_77952_i(), stack), index);
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.CROP;
            }

            @Override
            public int getStackSizeLimit() {
                return 1;
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (content.func_190926_b()) {
                    TileEntityMultiCrop.this.crop[index] = null;
                    TileEntityMultiCrop.this.genome[index] = null;
                    TileEntityMultiCrop.this.place[index] = false;
                } else {
                    TileEntityMultiCrop.this.genome[index] = new Genome(content);
                    TileEntityMultiCrop.this.crop[index] = CropNetwork.instance.getCropFromStack(content).copy();
                    TileEntityMultiCrop.this.genome[index].loadCrop(TileEntityMultiCrop.this.crop[index]);
                    TileEntityMultiCrop.this.place[index] = true;
                }
            }
        };
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.tickSoil = (int[])DecoderHandler.decode(customPacketBuffer);
            this.maxTickSoil = (int[])DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer buffer = super.writeContainerPacket();
        try {
            EncoderHandler.encode(buffer, this.tickSoil);
            EncoderHandler.encode(buffer, this.maxTickSoil);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public ContainerMultiCrop getGuiContainer(EntityPlayer var1) {
        return new ContainerMultiCrop(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiMultiCrop(this.getGuiContainer(var1));
    }

    public boolean canPlace(ICrop crop, int index) {
        EnumSoil soil = crop.getSoil();
        return soil == this.enumSoils[index];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_74783_a("tickSoil", this.tickSoil);
        nbtTagCompound.func_74783_a("maxTickSoil", this.maxTickSoil);
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.tickSoil = nbtTagCompound.func_74759_k("tickSoil");
        if (this.tickSoil.length == 0) {
            this.tickSoil = new int[this.crop.length];
        }
        this.maxTickSoil = nbtTagCompound.func_74759_k("maxTickSoil");
        if (this.maxTickSoil.length == 0) {
            this.maxTickSoil = new int[this.crop.length];
        }
    }

    public int getTickPest(int i) {
        return this.tickPest[i];
    }

    public void setTickPest(int i) {
        this.tickPest[i] = 7000;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            for (int i = 0; i < this.crop.length; ++i) {
                if (this.downBlockSlot.get(i).func_190926_b()) {
                    this.enumSoils[i] = null;
                    this.place[i] = false;
                } else {
                    this.enumSoils[i] = EnumSoil.get(this.downBlockSlot.get(i));
                }
                ItemStack content = this.upBlockSlot.get(i);
                if (content.func_190926_b()) {
                    this.crop[i] = null;
                    this.genome[i] = null;
                    this.place[i] = false;
                    continue;
                }
                this.genome[i] = new Genome(content);
                this.crop[i] = CropNetwork.instance.getCropFromStack(content).copy();
                this.genome[i].loadCrop(this.crop[i]);
                this.crop[i].setTick(this.tickSoil[i]);
                this.place[i] = true;
            }
            this.chunkPos = new ChunkPos(this.field_174879_c);
            Radiation radiation1 = RadiationSystem.rad_system.getMap().get(this.chunkPos);
            if (radiation1 == null) {
                radiation1 = new Radiation(this.chunkPos);
                RadiationSystem.rad_system.addRadiation(radiation1);
            }
            this.radLevel = radiation1;
            ChunkLevel chunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(this.chunkPos);
            if (chunkLevel == null) {
                chunkLevel = new ChunkLevel(this.chunkPos, LevelPollution.VERY_LOW, 0.0);
                PollutionManager.pollutionManager.addChunkLevelSoil(chunkLevel);
            }
            this.chunkLevel = chunkLevel;
            this.chunk = this.func_145831_w().func_175726_f(this.field_174879_c);
            this.biome = this.func_145831_w().func_180494_b(this.field_174879_c);
        }
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().func_72820_D() % 20L == 0L) {
            for (int i = 0; i < this.downBlockSlot.size(); ++i) {
                int chanceWeed;
                ICrop crop = this.crop[i];
                if (crop == null || crop.getId() == 3) {
                    this.tickSoil[i] = 0;
                    this.maxTickSoil[i] = 0;
                }
                if (crop == null) continue;
                if (crop.getId() == 3) {
                    this.upBlockSlot.put(i, ItemStack.field_190927_a);
                    continue;
                }
                this.tickSoil[i] = crop.getTick();
                this.maxTickSoil[i] = crop.getMaxTick();
                if (!CropNetwork.instance.canMultiGrow(this.field_145850_b, this.field_174879_c, this.chunkPos, crop, this.radLevel, this.chunk, this.biome, this.chunkLevel) || !this.place[i] || !this.canUseWater(crop)) continue;
                if (this.tickPest[i] == 0 && this.fluidPestTank.getFluidAmount() > 0) {
                    this.setTickPest(i);
                    this.fluidPestTank.drain(1, true);
                }
                int n = i;
                this.tickPest[n] = this.tickPest[n] - 20;
                if (crop.getTick() < crop.getMaxTick() && this.func_145831_w().func_72820_D() % 200L == 0L && crop.getId() != 3 && this.tickPest[i] == 0 && (chanceWeed = 100 - crop.getChanceWeed() - 5 * (crop.getSizeSeed() - 1)) > 0 && this.func_145831_w().func_72820_D() % 200L == 0L && WorldBaseGen.random.nextInt(100) < chanceWeed && WorldBaseGen.random.nextInt(100) == 0) {
                    this.crop[i] = CropInit.weed_seed.copy();
                    this.pestUse[i] = 0;
                    this.upBlockSlot.put(i, CropInit.weed_seed.getStack());
                    continue;
                }
                if (this.radLevel.getLevel().ordinal() > EnumLevelRadiation.HIGH.ordinal() && crop.getId() != 3) {
                    this.canAdaptationCrop(i);
                }
                if (crop.getTick() < crop.getMaxTick()) {
                    crop.addTick((int)(20.0 * crop.getGrowthSpeed()));
                    this.useWater(crop);
                    if (this.pestUse[i] < 40 && !this.fertilizerSlot.get().func_190926_b()) {
                        int n2 = i;
                        this.pestUse[n2] = this.pestUse[n2] + 1;
                        crop.addTick((int)((double)crop.getMaxTick() * 0.2));
                        this.fertilizerSlot.get().func_190918_g(1);
                    }
                    if (crop.getTick() < crop.getMaxTick() || crop.getId() == 3) continue;
                    this.outputSlot.add(crop.getDrops());
                    if (WorldBaseGen.random.nextInt(100) < 10) {
                        this.outputSlot.add(ModUtils.setSize(this.upBlockSlot.get(i).func_77946_l(), 1));
                    }
                    this.crop[i].setGeneration(crop.getGeneration() + 1);
                    this.crop[i].setTick(0);
                    this.canAdaptationCrop(i);
                    continue;
                }
                if (crop.getId() == 3) continue;
                this.outputSlot.add(crop.getDrops());
                if (WorldBaseGen.random.nextInt(100) < 10) {
                    this.outputSlot.add(ModUtils.setSize(this.upBlockSlot.get(i).func_77946_l(), 1));
                }
                this.crop[i].setGeneration(crop.getGeneration() + 1);
                this.crop[i].setTick(0);
                this.canAdaptationCrop(i);
            }
        }
    }

    private boolean canUseWater(ICrop crop) {
        return crop.getWaterRequirement() == 0 || this.fluidWaterTank.getFluidAmount() >= crop.getWaterRequirement();
    }

    private void useWater(ICrop crop) {
        this.fluidWaterTank.drain(crop.getWaterRequirement(), true);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    private void canAdaptationCrop(int i) {
        if (WorldBaseGen.random.nextInt(100) != 0) {
            return;
        }
        Genome genome = this.genome[i];
        ICrop crop = this.crop[i];
        ItemStack cropItem = this.upBlockSlot.get(i);
        int geneticAdaptive = genome.hasGenome(EnumGenetic.GENOME_ADAPTIVE) ? genome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class) : 5;
        int geneticResistance = genome.hasGenome(EnumGenetic.GENOME_RESISTANCE) ? genome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class) : 5;
        block21: for (EnumGenetic enumGenetic : EnumGenetic.values()) {
            GeneticTraits geneticTraits;
            boolean canUpgrade;
            List<GeneticTraits> genetic = GeneticsManager.enumGeneticListMap.get((Object)enumGenetic);
            if (WorldBaseGen.random.nextInt(100) > geneticAdaptive || WorldBaseGen.random.nextInt(100) <= geneticResistance) continue;
            boolean hasGenome = genome.hasGenome(enumGenetic);
            if (!hasGenome && WorldBaseGen.random.nextInt(100) == 0) {
                GeneticTraits geneticTraits2 = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                genome.addGenome(geneticTraits2, this.upBlockSlot.get(i));
                continue;
            }
            boolean needRemove = WorldBaseGen.random.nextInt(geneticResistance) > WorldBaseGen.random.nextInt(geneticAdaptive);
            boolean bl = canUpgrade = WorldBaseGen.random.nextInt(geneticAdaptive) > WorldBaseGen.random.nextInt(geneticResistance);
            if ((needRemove || !canUpgrade) && hasGenome) {
                geneticTraits = genome.removeGenome(enumGenetic, this.upBlockSlot.get(i));
                GeneticsManager.instance.deleteGenomeCrop(crop, geneticTraits);
                continue;
            }
            if (!canUpgrade) continue;
            switch (enumGenetic) {
                case SUN: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.upBlockSlot.get(i));
                    crop.setSun(true);
                    break block21;
                }
                case BIOME: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        List<Biome> biomeList = Genome.geneticBiomes.get((Object)geneticTraits);
                        if (crop.canGrowInBiome(biomeList.get(0))) break block21;
                        biomeList.forEach(crop::addBiome);
                        genome.addGenome(geneticTraits, cropItem);
                        break block21;
                    }
                    geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                    GeneticTraits geneticTraits1 = genome.removeGenome(enumGenetic, cropItem);
                    GeneticsManager.instance.deleteGenomeCrop(crop, geneticTraits1);
                    List<Biome> biomeList = Genome.geneticBiomes.get((Object)geneticTraits);
                    biomeList.forEach(crop::addBiome);
                    genome.addGenome(geneticTraits, cropItem);
                    break block21;
                }
                case AIR: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setAirRequirements(geneticTraits.getValue(LevelPollution.class));
                        break block21;
                    }
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        GeneticTraits traits = genome.getGenome(enumGenetic);
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setAirRequirements(traits.getPrev().getValue(LevelPollution.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setAirRequirements(LevelPollution.LOW);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setAirRequirements(traits1.getValue(LevelPollution.class));
                    break block21;
                }
                case SOIL: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        LevelPollution levelPollution = geneticTraits.getValue(LevelPollution.class);
                        if (levelPollution.ordinal() < this.chunkLevel.getLevelPollution().ordinal()) break block21;
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setAirRequirements(levelPollution);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    LevelPollution levelPollution = traits.getValue(LevelPollution.class);
                    boolean bl2 = needDecrease = WorldBaseGen.random.nextBoolean() && this.chunkLevel.getLevelPollution().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setSoilRequirements(traits.getPrev().getValue(LevelPollution.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setSoilRequirements(LevelPollution.LOW);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setSoilRequirements(traits1.getValue(LevelPollution.class));
                    break block21;
                }
                case WATER: {
                    if (!hasGenome) {
                        genome.addGenome(genetic.get(0), cropItem);
                        crop.setWaterRequirement(0);
                        break block21;
                    }
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (!needDecrease) break block21;
                    genome.removeGenome(genetic.get(0), cropItem);
                    crop.setWaterRequirement(crop.getDefaultWaterRequirement());
                    break block21;
                }
                case PEST: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setPestResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setPestResistance(crop.getPestResistance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setPestResistance(crop.getPestResistance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setPestResistance(crop.getPestResistance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case WEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.addChanceWeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.addChanceWeed(-level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.addChanceWeed(-level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.addChanceWeed(-level + traits1.getValue(Integer.class));
                    break block21;
                }
                case LIGHT: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setLight(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setLight(traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setLight(crop.getDefaultLightLevel());
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setLight(traits1.getValue(Integer.class));
                    break block21;
                }
                case RADIATION: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        EnumLevelRadiation levelPollution = geneticTraits.getValue(EnumLevelRadiation.class);
                        if (levelPollution.ordinal() < this.radLevel.getLevel().ordinal()) break block21;
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setRadiationRequirements(levelPollution);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    EnumLevelRadiation levelPollution = traits.getValue(EnumLevelRadiation.class);
                    boolean bl3 = needDecrease = WorldBaseGen.random.nextBoolean() && this.radLevel.getLevel().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setRadiationRequirements(traits.getPrev().getValue(EnumLevelRadiation.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setRadiationRequirements(EnumLevelRadiation.LOW);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setRadiationRequirements(traits1.getValue(EnumLevelRadiation.class));
                    break block21;
                }
                case SEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.addSizeSeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.addSizeSeed(-level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.addSizeSeed(-level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.addSizeSeed(-level + traits1.getValue(Integer.class));
                    break block21;
                }
                case YIELD: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setYield(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setYield(crop.getYield() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setYield(crop.getYield() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setYield(crop.getYield() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case BEE: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), cropItem);
                    crop.setBeeCombine(true);
                    break block21;
                }
                case NIGHT_GROW: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), cropItem);
                    crop.setNight(true);
                    break block21;
                }
                case SOIL_BLOCK: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), cropItem);
                    crop.setIgnoreSoil(true);
                    break block21;
                }
                case CHANCE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setChance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setChance(crop.getChance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setChance(crop.getChance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setChance(crop.getChance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case GROW_SPEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        double level = geneticTraits.getValue(Double.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setGrowthSpeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    double level = traits.getValue(Double.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setGrowthSpeed(traits.getPrev().getValue(Double.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setGrowthSpeed(1.0);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setGrowthSpeed(traits1.getValue(Double.class));
                    break block21;
                }
                case WEATHER: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setWeatherResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setWeatherResistance(traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setWeatherResistance(crop.getDefaultWeatherResistance());
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setWeatherResistance(traits1.getValue(Integer.class));
                    break block21;
                }
                case GENOME_ADAPTIVE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setGenomeAdaptive(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setGenomeAdaptive(crop.getGenomeAdaptive() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setGenomeAdaptive(crop.getGenomeAdaptive() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setGenomeAdaptive(crop.getGenomeAdaptive() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case GENOME_RESISTANCE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setGenomeResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setGenomeResistance(crop.getGenomeResistance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setGenomeResistance(crop.getGenomeResistance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setGenomeResistance(crop.getGenomeResistance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                default: {
                    continue block21;
                }
            }
        }
    }
}

