/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.cyclotron;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockCyclotron;
import com.denfop.container.ContainerCyclotronController;
import com.denfop.gui.GuiCyclotronController;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.cyclotron.IBombardmentChamber;
import com.denfop.tiles.cyclotron.IController;
import com.denfop.tiles.cyclotron.ICoolant;
import com.denfop.tiles.cyclotron.ICryogen;
import com.denfop.tiles.cyclotron.IElectrostaticDeflector;
import com.denfop.tiles.cyclotron.IPositrons;
import com.denfop.tiles.cyclotron.IQuantum;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCyclotronController
extends TileMultiBlockBase
implements IController,
IHasRecipe {
    public ICoolant coolant;
    public ICryogen cryogen;
    public IElectrostaticDeflector electrostaticDeflector;
    public IPositrons positrons;
    public IQuantum quantum;
    public IBombardmentChamber bombardmentChamber;
    public boolean work = false;
    public int progress;

    public TileEntityCyclotronController() {
        super(InitMultiBlockSystem.CyclotronMultiBlock);
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.work = nbttagcompound.func_74767_n("work");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.progress);
        try {
            EncoderHandler.encode(customPacketBuffer, this.coolant.getCoolantTank());
            EncoderHandler.encode(customPacketBuffer, this.cryogen.getCryogenTank());
            EncoderHandler.encode(customPacketBuffer, this.positrons.getPositrons(), false);
            EncoderHandler.encode(customPacketBuffer, this.quantum.getQuantum(), false);
            EncoderHandler.encode(customPacketBuffer, this.bombardmentChamber.getInputSlot());
            customPacketBuffer.writeBoolean(this.bombardmentChamber.getInputSlot().isEmpty());
            EncoderHandler.encode(customPacketBuffer, this.electrostaticDeflector.getOutputSlot());
            customPacketBuffer.writeBoolean(this.electrostaticDeflector.getOutputSlot().isEmpty());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.progress = customPacketBuffer.readInt();
        try {
            FluidTank fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank2 != null) {
                this.coolant.getCoolantTank().readFromNBT(fluidTank2.writeToNBT(new NBTTagCompound()));
            }
            if ((fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer)) != null) {
                this.cryogen.getCryogenTank().readFromNBT(fluidTank2.writeToNBT(new NBTTagCompound()));
            }
            this.positrons.getPositrons().onNetworkUpdate(customPacketBuffer);
            this.quantum.getQuantum().onNetworkUpdate(customPacketBuffer);
            this.bombardmentChamber.getInputSlot().readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            boolean empty = customPacketBuffer.readBoolean();
            if (empty && !this.bombardmentChamber.getInputSlot().isEmpty()) {
                this.bombardmentChamber.getInputSlot().put(0, ItemStack.field_190927_a);
            }
            this.electrostaticDeflector.getOutputSlot().readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            empty = customPacketBuffer.readBoolean();
            if (empty && !this.electrostaticDeflector.getOutputSlot().isEmpty()) {
                this.electrostaticDeflector.getOutputSlot().put(0, ItemStack.field_190927_a);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ContainerCyclotronController getGuiContainer(EntityPlayer var1) {
        return new ContainerCyclotronController(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiCyclotronController(this.getGuiContainer(var1));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.isFull()) {
            if (this.cryogen.getCryogenTank().getFluidAmount() > 2 * this.bombardmentChamber.getCryogen() && this.quantum.getQuantum().getEnergy() > 10.0 && this.positrons.getPositrons().getEnergy() > (double)this.bombardmentChamber.getPositrons() && this.bombardmentChamber.getRecipeOutput() != null && this.bombardmentChamber.getInputSlot().continue_process(this.bombardmentChamber.getRecipeOutput()) && this.electrostaticDeflector.getOutputSlot().canAdd(this.bombardmentChamber.getRecipeOutput().getRecipe().getOutput().items)) {
                if (!this.getActive()) {
                    this.setActive(true);
                }
                ++this.progress;
                this.quantum.getQuantum().useEnergy(10.0);
                this.positrons.getPositrons().useEnergy(this.bombardmentChamber.getPositrons());
                this.cryogen.getCryogenTank().drain(2 * this.bombardmentChamber.getCryogen(), true);
                if (this.coolant.getCoolantTank().getFluidAmount() + 1 < this.coolant.getCoolantTank().getCapacity()) {
                    this.coolant.getCoolantTank().fill(new FluidStack(FluidName.fluidcoolant.getInstance(), 1), true);
                }
                if (this.progress >= 1000) {
                    this.progress = 0;
                    if (this.bombardmentChamber.getChance() == 100) {
                        this.electrostaticDeflector.getOutputSlot().add(this.bombardmentChamber.getRecipeOutput().getRecipe().getOutput().items);
                        this.bombardmentChamber.getInputSlot().consume();
                        this.bombardmentChamber.getOutput();
                    } else {
                        if (WorldBaseGen.random.nextInt(this.bombardmentChamber.getChance()) < this.bombardmentChamber.getChance()) {
                            this.electrostaticDeflector.getOutputSlot().add(this.bombardmentChamber.getRecipeOutput().getRecipe().getOutput().items);
                        }
                        this.bombardmentChamber.getInputSlot().consume();
                        this.bombardmentChamber.getOutput();
                    }
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("work", this.work);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.coolant = null;
            this.cryogen = null;
            this.electrostaticDeflector = null;
            this.positrons = null;
            this.quantum = null;
            this.bombardmentChamber = null;
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ICoolant.class);
        this.coolant = (ICoolant)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ICryogen.class);
        this.cryogen = (ICryogen)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IBombardmentChamber.class);
        this.bombardmentChamber = (IBombardmentChamber)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IPositrons.class);
        this.positrons = (IPositrons)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IQuantum.class);
        this.quantum = (IQuantum)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IElectrostaticDeflector.class);
        this.electrostaticDeflector = (IElectrostaticDeflector)this.func_145831_w().func_175625_s(pos1.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockCyclotron.cyclotron_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.cyclotron;
    }

    @Override
    public void init() {
        IInputHandler input_recipe = Recipes.inputFactory;
        NBTTagCompound nbt = ModUtils.nbt();
        nbt.func_74768_a("chance", 100);
        Recipes.recipes.addRecipe("cyclotron", new BaseMachineRecipe(new Input(input_recipe.getInput("blockPalladium")), new RecipeOutput(nbt, new ItemStack(IUItem.toriy))));
        nbt = ModUtils.nbt();
        nbt.func_74768_a("chance", 100);
        Recipes.recipes.addRecipe("cyclotron", new BaseMachineRecipe(new Input(input_recipe.getInput("blockUranium")), new RecipeOutput(nbt, new ItemStack(IUItem.radiationresources, 1, 1))));
        nbt = ModUtils.nbt();
        nbt.func_74768_a("chance", 100);
        Recipes.recipes.addRecipe("cyclotron", new BaseMachineRecipe(new Input(input_recipe.getInput(new ItemStack((Item)IUItem.nuclear_res, 1, 3))), new RecipeOutput(nbt, new ItemStack(IUItem.radiationresources, 1, 0))));
        nbt = ModUtils.nbt();
        nbt.func_74768_a("chance", 100);
        Recipes.recipes.addRecipe("cyclotron", new BaseMachineRecipe(new Input(input_recipe.getInput(new ItemStack(IUItem.radiationresources, 1, 0))), new RecipeOutput(nbt, new ItemStack(IUItem.radiationresources, 1, 2))));
        nbt = ModUtils.nbt();
        nbt.func_74768_a("chance", 75);
        Recipes.recipes.addRecipe("cyclotron", new BaseMachineRecipe(new Input(input_recipe.getInput(new ItemStack(IUItem.radiationresources, 1, 11))), new RecipeOutput(nbt, new ItemStack(IUItem.radiationresources, 1, 5))));
        nbt = ModUtils.nbt();
        nbt.func_74768_a("chance", 60);
        nbt.func_74768_a("cryogen", 2);
        Recipes.recipes.addRecipe("cyclotron", new BaseMachineRecipe(new Input(input_recipe.getInput(new ItemStack(IUItem.radiationresources, 1, 5))), new RecipeOutput(nbt, new ItemStack(IUItem.radiationresources, 1, 10))));
        nbt = ModUtils.nbt();
        nbt.func_74768_a("chance", 50);
        nbt.func_74768_a("positrons", 2);
        nbt.func_74768_a("cryogen", 2);
        Recipes.recipes.addRecipe("cyclotron", new BaseMachineRecipe(new Input(input_recipe.getInput(new ItemStack(IUItem.radiationresources, 1, 10))), new RecipeOutput(nbt, new ItemStack(IUItem.radiationresources, 1, 9))));
        nbt = ModUtils.nbt();
        nbt.func_74768_a("chance", 50);
        nbt.func_74768_a("positrons", 2);
        nbt.func_74768_a("cryogen", 1);
        Recipes.recipes.addRecipe("cyclotron", new BaseMachineRecipe(new Input(input_recipe.getInput(new ItemStack((Item)IUItem.crafting_elements, 1, 641))), new RecipeOutput(nbt, new ItemStack((Item)IUItem.crafting_elements, 1, 647))));
    }
}

