/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.gasturbine;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockGasTurbine;
import com.denfop.container.ContainerGasTurbineController;
import com.denfop.gui.GuiGasTurbine;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.gasturbine.IController;
import com.denfop.tiles.gasturbine.IRecuperator;
import com.denfop.tiles.gasturbine.ISocket;
import com.denfop.tiles.gasturbine.ITank;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.reactors.graphite.IExchangerItem;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGasTurbineController
extends TileMultiBlockBase
implements IUpdatableTileEvent,
IController,
IHasRecipe {
    public static Map<Fluid, Integer> gasMapValue = new HashMap<Fluid, Integer>();
    public ISocket energy;
    public ITank tank;
    public boolean work;
    Fluid momentGas;
    List<IRecuperator> recuperators = new ArrayList<IRecuperator>();
    int generate = 0;

    public TileEntityGasTurbineController() {
        super(InitMultiBlockSystem.GasTurbineMultiBlock);
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && this.tank.getTank().getFluid() != null && this.work) {
            FluidStack stack = this.tank.getTank().getFluid();
            if (stack.getFluid() != this.momentGas) {
                this.momentGas = stack.getFluid();
                this.generate = gasMapValue.get(stack.getFluid());
            }
            double coef = 0.0;
            boolean canWork = true;
            for (IRecuperator recuperator : this.recuperators) {
                if (recuperator.getExchanger().isEmpty()) {
                    canWork = false;
                    break;
                }
                coef += recuperator.getPower();
            }
            coef /= 4.0;
            if (canWork && this.energy.getEnergy().getFreeEnergy() >= (double)this.generate * coef) {
                this.tank.getTank().drain(1, true);
                this.energy.getEnergy().addEnergy((double)this.generate * coef);
                if (this.func_145831_w().func_72820_D() % 20L == 0L) {
                    for (IRecuperator recuperator : this.recuperators) {
                        ((IExchangerItem)recuperator.getExchanger().get().func_77973_b()).damageItem(recuperator.getExchanger().get(), -1);
                    }
                }
                this.energy.getEnergy().setSourceTier(EnergyNetGlobal.instance.getTierFromPower((double)this.generate * coef) + 1);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("work", this.work);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.work = nbttagcompound.func_74767_n("work");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeBytes((ByteBuf)this.energy.getEnergy().updateComponent());
        try {
            EncoderHandler.encode(customPacketBuffer, this.tank.getTank());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        try {
            this.energy.getEnergy().onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            FluidTank fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank != null) {
                this.tank.getTank().readFromNBT(fluidTank.writeToNBT(new NBTTagCompound()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ContainerGasTurbineController getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerGasTurbineController(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiGasTurbine(this.getGuiContainer(var1));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockGasTurbine.gas_turbine_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.gasTurbine;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISocket.class);
        this.energy = (ISocket)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IRecuperator.class);
        for (BlockPos pos : pos1) {
            this.recuperators.add((IRecuperator)this.field_145850_b.func_175625_s(pos));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ITank.class);
        this.tank = (ITank)this.func_145831_w().func_175625_s(pos1.get(0));
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.energy = null;
            this.recuperators.clear();
            this.tank = null;
        }
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public void init() {
        gasMapValue.put(FluidName.fluidgas.getInstance(), 250);
        gasMapValue.put(FluidName.fluidmethane.getInstance(), 140);
        gasMapValue.put(FluidName.fluidpropane.getInstance(), 65);
        gasMapValue.put(FluidName.fluidacetylene.getInstance(), 10);
        gasMapValue.put(FluidName.fluidethylene.getInstance(), 40);
        gasMapValue.put(FluidName.fluidethane.getInstance(), 52);
        gasMapValue.put(FluidName.fluidbenzene.getInstance(), 35);
        gasMapValue.put(FluidName.fluidcyclohexane.getInstance(), 70);
        gasMapValue.put(FluidName.fluidbiogas.getInstance(), 15);
        gasMapValue.put(FluidName.fluidpropylene.getInstance(), 70);
        gasMapValue.put(FluidName.fluidbutadiene.getInstance(), 110);
        gasMapValue.put(FluidName.fluidbutene.getInstance(), 120);
        gasMapValue.put(FluidName.fluidtertbutylmethylether.getInstance(), 250);
    }
}

