/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.gaswell;

import com.denfop.IUItem;
import com.denfop.api.gasvein.GasVein;
import com.denfop.api.gasvein.GasVeinSystem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockGasWell;
import com.denfop.container.ContainerGasWellAnalyzer;
import com.denfop.gui.GuiGasWellAnalyzer;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.gaswell.IAnalyzer;
import com.denfop.tiles.gaswell.IController;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGasWellAnalyzer
extends TileEntityMultiBlockElement
implements IAnalyzer,
IUpdatableTileEvent {
    public int progress;
    public GasVein vein;
    public int col;
    public boolean work;

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.gas_well;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockGasWell.gas_well_analyzer;
    }

    public ContainerGasWellAnalyzer getGuiContainer(EntityPlayer var1) {
        return new ContainerGasWellAnalyzer(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiGasWellAnalyzer(this.getGuiContainer(var1));
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.progress);
        customPacketBuffer.writeBoolean(this.vein != null);
        customPacketBuffer.writeBytes((ByteBuf)this.vein.writePacket());
        return customPacketBuffer;
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.progress = customPacketBuffer.readInt();
        boolean hasVein = customPacketBuffer.readBoolean();
        if (hasVein) {
            this.vein = new GasVein(customPacketBuffer);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("work", this.work);
        nbt.func_74768_a("progress", this.progress);
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.work = nbtTagCompound.func_74767_n("analyzer");
        this.progress = nbtTagCompound.func_74762_e("progress");
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145831_w().field_73011_w.getDimension() != 0) {
            this.vein = GasVeinSystem.system.getEMPTY();
        } else {
            Chunk chunk = this.func_145831_w().func_175726_f(this.field_174879_c);
            ChunkPos chunkpos = chunk.func_76632_l();
            if (!GasVeinSystem.system.getChunkPos().contains(chunkpos)) {
                GasVeinSystem.system.addVein(chunk);
            }
            this.vein = GasVeinSystem.system.getVein(chunkpos);
            if (this.vein.isFind()) {
                this.progress = 1200;
            }
            if (this.progress >= 1200) {
                this.vein.setFind(true);
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.vein == null) {
            return;
        }
        if (this.work && this.progress < 1200 && ((IController)this.getMain()).getEnergy().getEnergy() >= 5.0 && !this.vein.isFind()) {
            ++this.progress;
            ((IController)this.getMain()).getEnergy().useEnergy(5.0);
            if (this.progress >= 1200) {
                this.progress = 1200;
                this.vein.setFind(true);
            }
        } else if (this.work) {
            this.work = false;
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 == 0.0 && this.getMain() != null && !this.vein.isFind() && this.progress < 1200) {
            this.work = !this.work;
        }
    }
}

