/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.gaswell;

import com.denfop.IUItem;
import com.denfop.api.gasvein.GasVein;
import com.denfop.api.gasvein.GasVeinSystem;
import com.denfop.api.gasvein.TypeGas;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockGasWell;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerGasWellController;
import com.denfop.gui.GuiGasWellController;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.gaswell.IController;
import com.denfop.tiles.gaswell.ISocket;
import com.denfop.tiles.gaswell.ITank;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGasWellController
extends TileMultiBlockBase
implements IController,
IUpdatableTileEvent {
    public boolean work;
    public ITank tank;
    public ISocket socket;
    public GasVein vein;

    public TileEntityGasWellController() {
        super(InitMultiBlockSystem.GasWellMultiBlock);
    }

    public ContainerGasWellController getGuiContainer(EntityPlayer var1) {
        return new ContainerGasWellController(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiGasWellController(this.getGuiContainer(var1));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145831_w().field_73011_w.getDimension() != 0) {
            this.vein = GasVeinSystem.system.getEMPTY();
        } else {
            Chunk chunk = this.func_145831_w().func_175726_f(this.field_174879_c);
            ChunkPos chunkpos = chunk.func_76632_l();
            if (!GasVeinSystem.system.getChunkPos().contains(chunkpos)) {
                GasVeinSystem.system.addVein(chunk);
            }
            this.vein = GasVeinSystem.system.getVein(chunkpos);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && this.work && this.vein != null && this.vein.isFind() && this.getEnergy().canUseEnergy(2.0)) {
            int amount = this.vein.getCol();
            amount = Math.min(Math.min(1, amount), this.tank.getTank().getCapacity() - this.tank.getTank().getFluidAmount());
            Fluid fluid = null;
            if (this.vein.getType() == TypeGas.IODINE) {
                fluid = FluidName.fluidiodine.getInstance();
            }
            if (this.vein.getType() == TypeGas.BROMIDE) {
                fluid = FluidName.fluidbromine.getInstance();
            }
            if (this.vein.getType() == TypeGas.CHLORINE) {
                fluid = FluidName.fluidchlorum.getInstance();
            }
            if (this.vein.getType() == TypeGas.FLORINE) {
                fluid = FluidName.fluidfluor.getInstance();
            }
            if (fluid == null) {
                return;
            }
            this.getEnergy().useEnergy(2.0);
            this.vein.removeCol(amount);
            this.tank.getTank().fill(new FluidStack(fluid, amount), true);
        }
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.gas_well;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockGasWell.gas_well_controller;
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBytes((ByteBuf)this.socket.getEnergy().updateComponent());
        customPacketBuffer.writeBytes((ByteBuf)this.tank.getTank().writePacket());
        customPacketBuffer.writeBoolean(this.vein != null);
        customPacketBuffer.writeBytes((ByteBuf)this.vein.writePacket());
        customPacketBuffer.writeBoolean(this.work);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.socket.getEnergy().onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tank.getTank().readPacket(customPacketBuffer);
        boolean hasVein = customPacketBuffer.readBoolean();
        if (hasVein) {
            this.vein = new GasVein(customPacketBuffer);
        }
        this.work = customPacketBuffer.readBoolean();
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.socket = null;
            this.tank = null;
        }
    }

    @Override
    public Energy getEnergy() {
        return this.socket.getEnergy();
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISocket.class);
        this.socket = (ISocket)this.func_145831_w().func_175625_s(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ITank.class);
        this.tank = (ITank)this.func_145831_w().func_175625_s(pos1.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }
}

