/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.geothermalpump;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockGeothermalPump;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerGeothermalController;
import com.denfop.gui.GuiGeothermalController;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.geothermalpump.IController;
import com.denfop.tiles.geothermalpump.IExchanger;
import com.denfop.tiles.geothermalpump.IGenerator;
import com.denfop.tiles.geothermalpump.IWaste;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGeothermalController
extends TileMultiBlockBase
implements IController {
    public boolean work = false;
    List<IGenerator> generatorList = new ArrayList<IGenerator>();
    List<IWaste> wasteList = new ArrayList<IWaste>();
    IExchanger exchanger;

    public TileEntityGeothermalController() {
        super(InitMultiBlockSystem.GeoThermalPumpMultiBlock);
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.work = nbttagcompound.func_74767_n("work");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        return customPacketBuffer;
    }

    public ContainerGeothermalController getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerGeothermalController(this, entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiGeothermalController(this.getGuiContainer(var1));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.isFull()) {
            Fluids.InternalFluidTank fluidTank = this.exchanger.getFluidTank();
            for (IGenerator generator : this.generatorList) {
                ItemStack stack;
                if (fluidTank.getFluidAmount() < 3) break;
                ComponentBaseEnergy baseEnergy = generator.getEnergy();
                int canAdd = generator.getFluidTank().getCapacity() - generator.getFluidTank().getFluidAmount();
                if (!(baseEnergy.getEnergy() >= 10.0) || canAdd < 1) continue;
                generator.getFluidTank().fill(new FluidStack(FluidName.fluidneft.getInstance(), 1), true);
                baseEnergy.useEnergy(10.0);
                fluidTank.drain(3, true);
                if (IUCore.random.nextInt(100) >= 98) {
                    stack = new ItemStack((Item)IUItem.crafting_elements, 1, 457);
                    for (IWaste waste : this.wasteList) {
                        if (waste.getSlot().add(stack)) break;
                    }
                }
                if (IUCore.random.nextInt(100) == 99 && IUCore.random.nextInt(2) == 0) {
                    stack = new ItemStack((Item)IUItem.crafting_elements, 1, 461);
                    for (IWaste waste : this.wasteList) {
                        if (waste.getSlot().add(stack)) break;
                    }
                }
                if (IUCore.random.nextInt(100) == 99 && IUCore.random.nextInt(2) == 0) {
                    stack = new ItemStack((Item)IUItem.crafting_elements, 1, 462);
                    for (IWaste waste : this.wasteList) {
                        if (waste.getSlot().add(stack)) break;
                    }
                }
                if (IUCore.random.nextInt(100) != 99 || IUCore.random.nextInt(2) != 0) continue;
                stack = new ItemStack((Item)IUItem.crafting_elements, 1, 463);
                for (IWaste waste : this.wasteList) {
                    if (waste.getSlot().add(stack)) break;
                }
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("work", this.work);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.generatorList.clear();
            this.wasteList.clear();
            this.exchanger = null;
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IExchanger.class);
        this.exchanger = (IExchanger)this.func_145831_w().func_175625_s(pos1.get(0));
        List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IGenerator.class);
        for (BlockPos pos3 : pos2) {
            this.generatorList.add((IGenerator)this.func_145831_w().func_175625_s(pos3));
        }
        pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IWaste.class);
        for (BlockPos pos3 : pos2) {
            this.wasteList.add((IWaste)this.func_145831_w().func_175625_s(pos3));
        }
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockGeothermalPump.geothermal_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.geothermalpump;
    }
}

