/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.api.Recipes;
import com.denfop.api.gui.IType;
import com.denfop.api.recipe.IPatternStorage;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.Fluids;
import com.denfop.componets.TypeUpgrade;
import com.denfop.container.ContainerReplicator;
import com.denfop.gui.GuiReplicator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileBaseReplicator
extends TileElectricMachine
implements IUpgradableBlock,
IType,
IUpdatableTileEvent {
    public final InvSlotFluid fluidSlot;
    public final InvSlotOutput cellSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final FluidTank fluidTank;
    protected final Fluids fluids;
    private final double coef;
    private final ComponentUpgrade componentUpgrades;
    private final ComponentUpgradeSlots componentUpgrade;
    public double uuProcessed = 0.0;
    public RecipeInfo pattern;
    public int index;
    public int maxIndex;
    public double patternUu;
    public double patternEu;
    public Mode mode;
    Map<BlockPos, IPatternStorage> iPatternStorageMap = new HashMap<BlockPos, IPatternStorage>();
    List<IPatternStorage> iPatternStorageList = new ArrayList<IPatternStorage>();
    private double uuPerTick = 1.0E-4;
    private double euPerTick = 512.0;
    private double extraUuStored = 0.0;
    private boolean instant = false;
    private boolean stack = false;

    public TileBaseReplicator(double coef) {
        super(2000000.0, 4, 0);
        this.mode = Mode.STOPPED;
        this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.INPUT, FluidName.fluiduu_matter.getInstance());
        this.cellSlot = new InvSlotOutput(this, 1);
        this.outputSlot = new InvSlotOutput(this, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", 16000, Fluids.fluidPredicate(FluidName.fluiduu_matter.getInstance()));
        this.coef = coef;
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot){

            @Override
            public void setOverclockRates(InvSlotUpgrade invSlotUpgrade) {
                super.setOverclockRates(invSlotUpgrade);
                ((TileBaseReplicator)this.getParent()).setOverclockRates();
            }
        });
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(int base, double extra, double multiplier) {
        return Math.round(((double)base + extra) * multiplier);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.uuProcessed = (Double)DecoderHandler.decode(customPacketBuffer);
            this.pattern = (RecipeInfo)DecoderHandler.decode(customPacketBuffer);
            this.mode = Mode.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.index = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.maxIndex = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.patternUu = (Double)DecoderHandler.decode(customPacketBuffer);
            this.patternEu = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.uuProcessed);
            EncoderHandler.encode(packet, this.pattern);
            EncoderHandler.encode(packet, (Object)this.mode);
            EncoderHandler.encode(packet, this.index);
            EncoderHandler.encode(packet, this.maxIndex);
            EncoderHandler.encode(packet, this.patternUu);
            EncoderHandler.encode(packet, this.patternEu);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        IPatternStorage storage;
        super.onNeighborChange(neighbor, neighborPos);
        TileEntity tile = this.func_145831_w().func_175625_s(neighborPos);
        if (tile instanceof IPatternStorage) {
            if (!this.iPatternStorageList.contains((IPatternStorage)tile)) {
                this.iPatternStorageList.add((IPatternStorage)tile);
                this.iPatternStorageMap.put(neighborPos, (IPatternStorage)tile);
            }
        } else if (tile == null && (storage = this.iPatternStorageMap.get(neighborPos)) != null) {
            this.iPatternStorageList.remove(storage);
            this.iPatternStorageMap.remove(neighborPos, storage);
        }
        this.refreshInfo();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
            this.gainFluid();
        }
        if (this.componentUpgrades.isChange()) {
            this.instant = this.componentUpgrades.hasUpgrade(TypeUpgrade.INSTANT);
            this.stack = this.componentUpgrades.hasUpgrade(TypeUpgrade.STACK);
            this.componentUpgrades.setChange(false);
        }
        boolean newActive = false;
        double energyConsume = this.euPerTick;
        if (this.instant) {
            energyConsume *= 10.0;
        }
        if (this.mode != Mode.STOPPED && this.energy.getEnergy() >= energyConsume && this.pattern != null && this.outputSlot.canAdd(this.pattern.getStack())) {
            boolean finish;
            double uuRemaining = this.patternUu - this.uuProcessed;
            if (this.instant) {
                if (uuRemaining <= (double)this.fluidTank.getFluidAmount() * 1.0) {
                    uuRemaining = this.patternUu;
                    finish = true;
                } else if (uuRemaining <= this.uuPerTick) {
                    finish = true;
                } else {
                    uuRemaining = this.uuPerTick;
                    finish = false;
                }
            } else if (uuRemaining <= this.uuPerTick) {
                finish = true;
            } else {
                uuRemaining = this.uuPerTick;
                finish = false;
            }
            double size = 1.0;
            if (this.stack) {
                size = (double)this.fluidTank.getFluidAmount() / (this.patternUu * 1000.0);
                size = Math.min(size, (double)this.pattern.getStack().func_77976_d());
                int amount = this.outputSlot.get(0).func_190926_b() ? 64 : this.outputSlot.get(0).func_77976_d() - this.outputSlot.get(0).func_190916_E();
                size = Math.min((double)amount, size);
                if (size >= 1.0) {
                    uuRemaining = this.patternUu;
                    finish = true;
                }
            }
            if (this.consumeUu(uuRemaining * size)) {
                newActive = true;
                this.energy.useEnergy(energyConsume);
                this.uuProcessed += uuRemaining * size;
                if (finish) {
                    this.uuProcessed = 0.0;
                    if (this.mode == Mode.SINGLE) {
                        this.mode = Mode.STOPPED;
                    } else {
                        this.refreshInfo();
                    }
                    if (this.pattern != null) {
                        int i = 0;
                        while ((double)i < size) {
                            this.outputSlot.add(this.pattern.getStack());
                            ++i;
                        }
                    }
                }
            }
        }
        this.setActive(newActive);
    }

    private boolean consumeUu(double amount) {
        if (amount <= this.extraUuStored) {
            this.extraUuStored -= amount;
            return true;
        }
        int toDrain = (int)Math.ceil((amount -= this.extraUuStored) * 1000.0);
        FluidStack drained = this.fluidTank.drainInternal(toDrain, false);
        if (drained != null && drained.getFluid() == FluidName.fluiduu_matter.getInstance() && drained.amount == toDrain) {
            this.fluidTank.drainInternal(toDrain, true);
            this.extraUuStored = amount < 0.0 ? -(amount -= (double)drained.amount / 1000.0) : 0.0;
            return true;
        }
        return false;
    }

    public void refreshInfo() {
        IPatternStorage storage = this.getPatternStorage();
        RecipeInfo oldPattern = this.pattern;
        if (storage == null) {
            this.pattern = null;
        } else {
            List<RecipeInfo> patterns = storage.getPatterns();
            if (this.index < 0 || this.index >= patterns.size()) {
                this.index = 0;
            }
            this.maxIndex = patterns.size();
            if (patterns.isEmpty()) {
                this.pattern = null;
            } else {
                this.pattern = patterns.get(this.index);
                this.patternUu = this.pattern.getCol() * this.coef;
                this.patternEu = this.patternUu * 1.0E9;
                if (oldPattern == null || !ModUtils.checkItemEqualityStrict(this.pattern.getStack(), oldPattern.getStack())) {
                    this.uuProcessed = 0.0;
                    this.mode = Mode.STOPPED;
                }
            }
        }
        if (this.pattern == null) {
            this.uuProcessed = 0.0;
            this.mode = Mode.STOPPED;
        }
    }

    public IPatternStorage getPatternStorage() {
        if (this.iPatternStorageList.isEmpty()) {
            return null;
        }
        return this.iPatternStorageList.get(0);
    }

    public void setOverclockRates() {
        this.uuPerTick = 1.0E-4 / this.upgradeSlot.processTimeMultiplier;
        this.euPerTick = (512.0 + this.upgradeSlot.extraEnergyDemand) * this.upgradeSlot.energyDemandMultiplier;
        this.energy.setSinkTier(TileBaseReplicator.applyModifier(4, this.upgradeSlot.extraTier, 1.0));
        this.energy.setCapacity(TileBaseReplicator.applyModifier(2000000, this.upgradeSlot.extraEnergyStorage, this.upgradeSlot.energyStorageMultiplier));
    }

    @SideOnly(value=Side.CLIENT)
    public GuiReplicator getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiReplicator(new ContainerReplicator(player, this));
    }

    public ContainerReplicator getGuiContainer(EntityPlayer player) {
        return new ContainerReplicator(player, this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IPatternStorage storage;
                BlockPos neighborPos = this.field_174879_c.func_177972_a(facing);
                TileEntity tile = this.func_145831_w().func_175625_s(neighborPos);
                if (tile instanceof IPatternStorage) {
                    if (this.iPatternStorageList.contains((IPatternStorage)tile)) continue;
                    this.iPatternStorageList.add((IPatternStorage)tile);
                    this.iPatternStorageMap.put(neighborPos, (IPatternStorage)tile);
                    continue;
                }
                if (tile != null || (storage = this.iPatternStorageMap.get(neighborPos)) == null) continue;
                this.iPatternStorageList.remove(storage);
                this.iPatternStorageMap.remove(neighborPos, storage);
            }
            this.refreshInfo();
        }
    }

    public void gainFluid() {
        this.fluidSlot.processIntoTank((IFluidTank)this.fluidTank, this.cellSlot);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.extraUuStored = nbt.func_74769_h("extraUuStored");
        this.uuProcessed = nbt.func_74769_h("uuProcessed");
        this.index = nbt.func_74762_e("index");
        int modeIdx = nbt.func_74762_e("mode");
        this.mode = modeIdx < Mode.values().length ? Mode.values()[modeIdx] : Mode.STOPPED;
        boolean isPattern = nbt.func_74767_n("isPattern");
        if (isPattern) {
            NBTTagCompound contentTag = nbt.func_74775_l("pattern");
            ItemStack stack = new ItemStack(contentTag);
            this.pattern = new RecipeInfo(stack, Recipes.recipes.getRecipeOutput((String)"replicator", (boolean)false, (ItemStack[])new ItemStack[]{stack}).getOutput().metadata.func_74769_h("matter"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("extraUuStored", this.extraUuStored);
        nbt.func_74780_a("uuProcessed", this.uuProcessed);
        nbt.func_74768_a("index", this.index);
        nbt.func_74768_a("mode", this.mode.ordinal());
        if (this.pattern != null) {
            nbt.func_74757_a("isPattern", true);
            NBTTagCompound contentTag = new NBTTagCompound();
            this.pattern.getStack().func_77955_b(contentTag);
            nbt.func_74782_a("pattern", (NBTBase)contentTag);
        } else {
            nbt.func_74757_a("isPattern", false);
        }
        return nbt;
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        switch ((int)event) {
            case 0: 
            case 1: {
                List<RecipeInfo> patterns;
                IPatternStorage storage;
                if (this.mode == Mode.STOPPED && (storage = this.getPatternStorage()) != null && !(patterns = storage.getPatterns()).isEmpty()) {
                    this.index = event == 0.0 ? (this.index <= 0 ? patterns.size() - 1 : --this.index) : (this.index >= patterns.size() - 1 ? 0 : ++this.index);
                    this.refreshInfo();
                }
            }
            default: {
                break;
            }
            case 3: {
                if (this.mode == Mode.STOPPED) break;
                this.uuProcessed = 0.0;
                this.mode = Mode.STOPPED;
                break;
            }
            case 4: {
                if (this.pattern == null) break;
                this.mode = Mode.SINGLE;
                break;
            }
            case 5: {
                if (this.pattern == null) break;
                this.mode = Mode.CONTINUOUS;
            }
        }
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.FluidInput);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    public static enum Mode {
        STOPPED,
        SINGLE,
        CONTINUOUS;

    }
}

