/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentTimer;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerAlkalineEarthQuarry;
import com.denfop.gui.GuiAlkalineEarthQuarry;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.items.ItemMesh;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import com.denfop.world.WorldBaseGen;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityAlkalineEarthQuarry
extends TileElectricMachine
implements IUpgradableBlock,
IManufacturerBlock {
    public static ItemStack lithium;
    public static ItemStack beryllium;
    public static ItemStack boron;
    public final ComponentTimer timer;
    public final InvSlot inputSlotA;
    public final InvSlot inputSlotB;
    public final InvSlotUpgrade upgradeSlot;
    public int level;
    public int level_mesh;
    public int type_block;

    public TileEntityAlkalineEarthQuarry() {
        super(100.0, 14, 1);
        this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.addComponent(new AirPollutionComponent(this, 0.1));
        this.inputSlotA = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                Item item = stack.func_77973_b();
                if (!(item instanceof ItemBlock)) {
                    return false;
                }
                ItemBlock itemBlock = (ItemBlock)item;
                return itemBlock.func_179223_d() == Blocks.field_150346_d || itemBlock.func_179223_d() == Blocks.field_150351_n || itemBlock.func_179223_d() == Blocks.field_150354_m;
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (content.func_190926_b()) {
                    TileEntityAlkalineEarthQuarry.this.type_block = -1;
                } else {
                    Item item = content.func_77973_b();
                    ItemBlock itemBlock = (ItemBlock)item;
                    if (itemBlock.func_179223_d() == Blocks.field_150346_d) {
                        TileEntityAlkalineEarthQuarry.this.type_block = 1;
                    }
                    if (itemBlock.func_179223_d() == Blocks.field_150351_n) {
                        TileEntityAlkalineEarthQuarry.this.type_block = 2;
                    }
                    if (itemBlock.func_179223_d() == Blocks.field_150354_m) {
                        TileEntityAlkalineEarthQuarry.this.type_block = 3;
                    }
                }
            }
        };
        this.inputSlotB = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() instanceof ItemMesh;
            }

            @Override
            public void put(int index, ItemStack content) {
                super.put(index, content);
                if (content.func_190926_b()) {
                    TileEntityAlkalineEarthQuarry.this.level_mesh = -1;
                } else {
                    ItemMesh itemMesh = (ItemMesh)content.func_77973_b();
                    TileEntityAlkalineEarthQuarry.this.level_mesh = itemMesh.getLevel();
                }
            }
        };
        this.timer = this.addComponent(new ComponentTimer(this, new Timer[]{new Timer(0, 2, 0)}){

            @Override
            public int getTickFromSecond() {
                return (int)Math.max(1.0, 20.0 - (double)((TileEntityAlkalineEarthQuarry)this.parent).getLevel() * 1.1);
            }
        });
        this.upgradeSlot = new InvSlotUpgrade(this, 2);
        this.level = 0;
    }

    public static void addRecipe(int container) {
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void removeLevel(int level) {
        this.level -= level;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.level < 10) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77973_b().equals(IUItem.upgrade_speed_creation)) {
                return super.onActivated(player, hand, side, hitX, hitY, hitZ);
            }
            stack.func_190918_g(1);
            ++this.level;
            return true;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.level != 0) {
            ret.add(new ItemStack((Item)IUItem.upgrade_speed_creation, this.level));
            this.level = 0;
        }
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.level = nbttagcompound.func_74762_e("level");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("level", this.level);
        return nbttagcompound;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.alkalineearthquarry;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        lithium = new ItemStack((Block)IUItem.ore2);
        beryllium = new ItemStack((Block)IUItem.ore2, 1, 1);
        boron = new ItemStack((Block)IUItem.ore2, 1, 2);
        if (this.inputSlotB.isEmpty()) {
            this.level_mesh = -1;
        } else {
            ItemMesh itemMesh = (ItemMesh)this.inputSlotB.get().func_77973_b();
            this.level_mesh = itemMesh.getLevel();
        }
        if (this.inputSlotA.isEmpty()) {
            this.type_block = -1;
        } else {
            Item item = this.inputSlotA.get().func_77973_b();
            ItemBlock itemBlock = (ItemBlock)item;
            if (itemBlock.func_179223_d() == Blocks.field_150346_d) {
                this.type_block = 1;
            }
            if (itemBlock.func_179223_d() == Blocks.field_150351_n) {
                this.type_block = 2;
            }
            if (itemBlock.func_179223_d() == Blocks.field_150354_m) {
                this.type_block = 3;
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.inputSlotA.get().func_190926_b() && !this.inputSlotB.isEmpty() && this.energy.canUseEnergy(1.0) && this.canOperate() && this.outputSlot.canAdd(this.getItemStack())) {
            this.setActive(true);
            if (!this.timer.isCanWork()) {
                this.timer.setCanWork(true);
            }
            this.energy.useEnergy(1.0);
            if (this.timer.getTimers().get(0).getTime() <= 0) {
                this.inputSlotA.get().func_190918_g(1);
                if (this.getChance()) {
                    this.outputSlot.add(this.getItemStack());
                }
                ItemMesh itemMesh = (ItemMesh)this.inputSlotB.get().func_77973_b();
                ModUtils.nbt(this.inputSlotB.get());
                itemMesh.applyCustomDamage(this.inputSlotB.get(), -1, null);
                if (itemMesh.getMaxCustomDamage(this.inputSlotB.get()) - itemMesh.getCustomDamage(this.inputSlotB.get()) == 0) {
                    this.inputSlotB.get().func_190918_g(1);
                }
                this.timer.resetTime();
            }
        } else {
            this.timer.setCanWork(false);
            this.setActive(false);
            return;
        }
        this.upgradeSlot.tickNoMark();
    }

    private boolean getChance() {
        if (this.level_mesh == 1 && this.type_block == 3) {
            return WorldBaseGen.random.nextInt(200) == 0;
        }
        if (this.level_mesh == 2) {
            if (this.type_block == 3) {
                return WorldBaseGen.random.nextInt(200) < 5;
            }
            if (this.type_block == 1) {
                return WorldBaseGen.random.nextInt(200) == 0;
            }
            if (this.type_block == 2) {
                return WorldBaseGen.random.nextInt(200) == 0;
            }
        }
        if (this.level_mesh == 3) {
            if (this.type_block == 3) {
                return WorldBaseGen.random.nextInt(200) < 8;
            }
            if (this.type_block == 1) {
                return WorldBaseGen.random.nextInt(200) < 4;
            }
            if (this.type_block == 2) {
                return WorldBaseGen.random.nextInt(200) == 0;
            }
        }
        if (this.level_mesh == 4) {
            if (this.type_block == 3) {
                return WorldBaseGen.random.nextInt(200) < 10;
            }
            if (this.type_block == 1) {
                return WorldBaseGen.random.nextInt(200) < 6;
            }
            if (this.type_block == 2) {
                return WorldBaseGen.random.nextInt(200) < 2;
            }
        }
        if (this.level_mesh == 5) {
            if (this.type_block == 3) {
                return WorldBaseGen.random.nextInt(200) < 14;
            }
            if (this.type_block == 1) {
                return WorldBaseGen.random.nextInt(200) < 8;
            }
            if (this.type_block == 2) {
                return WorldBaseGen.random.nextInt(200) < 4;
            }
        }
        return false;
    }

    private ItemStack getItemStack() {
        switch (this.type_block) {
            case 1: {
                return beryllium;
            }
            case 2: {
                return boron;
            }
            case 3: {
                return lithium;
            }
        }
        return ItemStack.field_190927_a;
    }

    private boolean canOperate() {
        if (this.level_mesh == 1 && this.type_block == 3) {
            return true;
        }
        if (this.level_mesh == 2 && (this.type_block == 3 || this.type_block == 2 || this.type_block == 1)) {
            return true;
        }
        return this.level_mesh >= 3 && (this.type_block == 3 || this.type_block == 1 || this.type_block == 2);
    }

    public ContainerAlkalineEarthQuarry getGuiContainer(EntityPlayer var1) {
        return new ContainerAlkalineEarthQuarry(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiAlkalineEarthQuarry(this.getGuiContainer(var1));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

