/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.container.ContainerApothecaryBee;
import com.denfop.gui.GuiApothecaryBee;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.bee.TileEntityApiary;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityApothecaryBee
extends TileEntityInventory {
    private static final int RADIUS = 4;
    public final ComponentBaseEnergy energy;
    AxisAlignedBB searchArea;
    List<List<TileEntityApiary>> list;
    List<Chunk> chunks;

    public TileEntityApothecaryBee() {
        this.searchArea = new AxisAlignedBB(this.field_174879_c.func_177982_a(-4, -4, -4), this.field_174879_c.func_177982_a(4, 4, 4));
        this.list = new ArrayList<List<TileEntityApiary>>();
        this.energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.QUANTUM, this, 20000.0));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.apothecary_bee;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.apothecary_bee.info"));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            AxisAlignedBB aabb;
            this.searchArea = aabb = this.searchArea.func_186670_a(this.field_174879_c);
            int j2 = MathHelper.func_76128_c((double)((aabb.field_72340_a - 2.0) / 16.0));
            int k2 = MathHelper.func_76143_f((double)((aabb.field_72336_d + 2.0) / 16.0));
            int l2 = MathHelper.func_76128_c((double)((aabb.field_72339_c - 2.0) / 16.0));
            int i3 = MathHelper.func_76143_f((double)((aabb.field_72334_f + 2.0) / 16.0));
            this.chunks = new ArrayList<Chunk>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    Chunk chunk = this.field_145850_b.func_72964_e(j3, k3);
                    if (this.chunks.contains(chunk)) continue;
                    this.chunks.add(chunk);
                }
            }
            for (Chunk chunk : this.chunks) {
                this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.field_145850_b, chunk.func_76632_l()));
            }
        }
    }

    public ContainerApothecaryBee getGuiContainer(EntityPlayer var1) {
        return new ContainerApothecaryBee(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiApothecaryBee(this.getGuiContainer(var1));
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.func_177958_n() > this.searchArea.field_72340_a && (double)vec.func_177958_n() < this.searchArea.field_72336_d) {
            if ((double)vec.func_177956_o() > this.searchArea.field_72338_b && (double)vec.func_177956_o() < this.searchArea.field_72337_e) {
                return (double)vec.func_177952_p() > this.searchArea.field_72339_c && (double)vec.func_177952_p() < this.searchArea.field_72334_f;
            }
            return false;
        }
        return false;
    }

    private void updateBee() {
        this.list.clear();
        for (Chunk chunk : this.chunks) {
            this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.field_145850_b, chunk.func_76632_l()));
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().func_72820_D() % 100L == 0L) {
            this.updateBee();
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L && this.energy.canUseEnergy(50.0)) {
            block0: for (List<TileEntityApiary> bees : this.list) {
                for (TileEntityApiary bee : bees) {
                    if (!(this.energy.getEnergy() > 50.0) || bee.ill <= 0) break block0;
                    if (!this.contains(bee.func_174877_v())) continue;
                    bee.healBeesFromApothecary(this);
                }
            }
        }
    }
}

