/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerAutoCrafter;
import com.denfop.gui.GuiAutoCrafter;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotAutoCrafter;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.invslot.InventoryAutoCrafting;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputItemStack;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileEntityAutoCrafter
extends TileElectricMachine
implements IUpgradableBlock {
    public final InvSlotUpgrade upgradeSlot;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    private final InventoryCrafting crafingTable;
    private final InvSlot slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 18){

        @Override
        public void put(int index, ItemStack content) {
            super.put(index, content);
            ((TileEntityAutoCrafter)this.base).checkRecipe();
        }
    };
    private final InvSlotAutoCrafter autoCrafter;
    public int operationsPerTick;
    public double energyConsume;
    public ComponentProgress componentProgress;
    BaseMachineRecipe recipe;
    private boolean canRecipe = false;

    public TileEntityAutoCrafter() {
        super(1000.0, 4, 1);
        this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.addComponent(new AirPollutionComponent(this, 0.1));
        this.energyConsume = 1.0;
        this.defaultEnergyConsume = 1.0;
        this.operationsPerTick = 100;
        this.defaultOperationLength = 100;
        this.defaultTier = 4;
        this.defaultEnergyStorage = 200.0;
        this.autoCrafter = new InvSlotAutoCrafter(this, null, 9);
        this.crafingTable = new InventoryAutoCrafting(this);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, (short)this.defaultOperationLength));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.energyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.operationsPerTick);
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerAutoCrafter getGuiContainer(EntityPlayer var1) {
        return new ContainerAutoCrafter(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiAutoCrafter(this.getGuiContainer(var1));
    }

    public BaseMachineRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        boolean hasRecipe = customPacketBuffer.readBoolean();
        if (hasRecipe) {
            try {
                this.recipe = (BaseMachineRecipe)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.recipe = null;
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.recipe != null);
        if (this.recipe != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.recipe);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    private void checkRecipe() {
        if (this.recipe == null) {
            this.canRecipe = false;
        } else {
            this.canRecipe = false;
            List list = this.slot.stream().filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
            List<IInputItemStack> input = this.recipe.input.getInputs();
            for (IInputItemStack needed : input) {
                ItemStack stack;
                int totalFound = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (!needed.matches(stack = (ItemStack)iterator.next()) || (totalFound += stack.func_190916_E()) < needed.getAmount())) {
                }
                if (totalFound >= needed.getAmount()) continue;
                return;
            }
            this.canRecipe = true;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
            this.updateCraft();
            this.checkRecipe();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.recipe != null && this.energy.getEnergy() >= this.energyConsume && this.outputSlot.canAdd(this.recipe.getOutput().items) && this.canRecipe) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            this.componentProgress.addProgress(0);
            this.energy.useEnergy(this.energyConsume);
            if (this.componentProgress.getProgress() >= this.componentProgress.getMaxValue()) {
                this.operate(this.recipe);
                this.componentProgress.setProgress((short)0);
            }
        } else {
            if (this.recipe == null && this.getActive()) {
                this.componentProgress.setProgress((short)0);
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 40L == 0L) {
            this.checkRecipe();
        }
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.componentProgress.setMaxValue((short)this.upgradeSlot.getOperationLength(this.defaultOperationLength));
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        this.operationsPerTick = Math.max(1, Math.min(64, this.operationsPerTick));
    }

    public void operate(BaseMachineRecipe output) {
        for (int i = 0; i < this.operationsPerTick && this.canRecipe; ++i) {
            List<ItemStack> processResult = output.output.items;
            this.operateOnce(processResult);
            this.checkRecipe();
            if (!this.outputSlot.canAdd(this.recipe.getOutput().items)) break;
        }
    }

    private void operateOnce(List<ItemStack> processResult) {
        List<IInputItemStack> input = this.recipe.input.getInputs();
        List list = this.slot.stream().filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
        for (IInputItemStack needed : input) {
            int remaining = needed.getAmount();
            for (ItemStack stack : list) {
                if (!needed.matches(stack) || remaining <= 0) continue;
                int available = stack.func_190916_E();
                if (available >= remaining) {
                    stack.func_190918_g(remaining);
                    remaining = 0;
                    break;
                }
                stack.func_190918_g(available);
                remaining -= available;
            }
            if (remaining <= 0) continue;
            return;
        }
        this.outputSlot.add(processResult);
    }

    public InvSlotAutoCrafter getAutoCrafter() {
        return this.autoCrafter;
    }

    public InvSlot getSlot() {
        return this.slot;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.autocrafter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    public void updateCraft() {
        Collection recipes = ForgeRegistries.RECIPES.getValuesCollection();
        if (this.autoCrafter.isEmpty()) {
            this.recipe = null;
            return;
        }
        this.recipe = null;
        for (IRecipe recipe1 : recipes) {
            if (!recipe1.func_77569_a(this.crafingTable, this.field_145850_b)) continue;
            ItemStack output = recipe1.func_77572_b(this.crafingTable);
            ArrayList<IInputItemStack> list = new ArrayList<IInputItemStack>();
            for (ItemStack stack : this.autoCrafter) {
                if (stack.func_190926_b()) continue;
                boolean find = false;
                for (IInputItemStack iInputItemStack : list) {
                    if (!iInputItemStack.matches(stack)) continue;
                    find = true;
                    iInputItemStack.growAmount(stack.func_190916_E());
                }
                if (find) continue;
                IInputItemStack input = Recipes.inputFactory.getInput(stack.func_77946_l());
                list.add(input);
            }
            this.recipe = new BaseMachineRecipe(new Input(list), new RecipeOutput(null, output.func_77946_l()));
            break;
        }
        this.checkRecipe();
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

