/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerCactusFarm;
import com.denfop.gui.GuiCactusFarm;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCactusFarm
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 4;
    public final InvSlotOutput slot = new InvSlotOutput(this, 9);
    public final Energy energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 4000.0, 5));
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, 4);
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));

    public TileEntityCactusFarm() {
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract);
    }

    public ContainerCactusFarm getGuiContainer(EntityPlayer var1) {
        return new ContainerCactusFarm(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiCactusFarm(this.getGuiContainer(var1));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.cactus_farm;
    }

    private void breakCactusInRadius() {
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                BlockPos targetPos = this.field_174879_c.func_177982_a(x, 1, z);
                Block block = this.field_145850_b.func_180495_p(targetPos).func_177230_c();
                if (!(block instanceof BlockCactus) || !(this.energy.getEnergy() >= 100.0)) continue;
                this.breakCactus(targetPos);
                this.energy.useEnergy(100.0);
                return;
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.sapling_gardener.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    private void breakCactus(BlockPos startPos) {
        IBlockState state;
        BlockPos currentPos = startPos;
        while (!this.field_145850_b.func_175623_d(currentPos) && (state = this.field_145850_b.func_180495_p(currentPos)).func_177230_c() instanceof BlockCactus) {
            List drops = state.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, currentPos, state, 0);
            for (ItemStack drop : drops) {
                this.slot.add(drop);
            }
            this.field_145850_b.func_175698_g(currentPos);
            currentPos = currentPos.func_177984_a();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().field_73011_w.getWorldTime() % 40L == 0L) {
            this.breakCactusInRadius();
        }
    }
}

