/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityChargepadExperience
extends TileEntityInventory {
    private final ComponentBaseEnergy energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.EXPERIENCE, this, 2.0E9, 14));
    private EntityPlayer player;

    public TileEntityChargepadExperience() {
        this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
    }

    @Override
    public void onEntityCollision(Entity entity) {
        super.onEntityCollision(entity);
        if (!this.func_145831_w().field_72995_K && entity instanceof EntityPlayer && this.canEntityDestroy(entity)) {
            this.updatePlayer((EntityPlayer)entity);
        }
    }

    protected void getItems(EntityPlayer player) {
        if (!this.canEntityDestroy((Entity)player)) {
            IUCore.proxy.messagePlayer(player, Localization.translate("iu.error"), new Object[0]);
            return;
        }
        this.chargeitems(player);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.exp_chargepad;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.player != null && this.energy.getEnergy() >= 1.0) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            this.getItems(this.player);
            this.player = null;
        } else if (this.getActive()) {
            this.setActive(false);
        }
        this.updatePlayer(null);
    }

    protected void updatePlayer(EntityPlayer entity) {
        this.player = entity;
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0));
    }

    protected void chargeitems(EntityPlayer player) {
        double value = Math.min(this.energy.getEnergy(), 1.0);
        this.energy.storage -= value - (double)ExperienceUtils.addPlayerXP1(player, (int)value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            World world = this.func_145831_w();
            Random rnd = world.field_73012_v;
            int n = 4;
            boolean green = true;
            boolean blue = false;
            for (int i = 0; i < 4; ++i) {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)this.field_174879_c.func_177958_n() + rnd.nextFloat()), (double)((float)(this.field_174879_c.func_177956_o() + 1) + rnd.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + rnd.nextFloat()), -1.0, 1.0, (double)blue, new int[0]);
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)this.field_174879_c.func_177958_n() + rnd.nextFloat()), (double)((float)(this.field_174879_c.func_177956_o() + 2) + rnd.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + rnd.nextFloat()), -1.0, 1.0, (double)blue, new int[0]);
            }
        }
    }
}

