/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerCollectorProductBee;
import com.denfop.gui.GuiCollectorProductBee;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.bee.TileEntityApiary;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityCollectorProductBee
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 8;
    public final Energy energy;
    public final InvSlotFluidByList fluidSlot;
    public final InvSlotFluidByList fluidSlot1;
    public final Fluids.InternalFluidTank tank;
    public final Fluids.InternalFluidTank tank1;
    public final InvSlotOutput outputSlot;
    public final InvSlotOutput outputSlot1;
    public final InvSlotUpgrade upgradeSlot;
    public final ComponentUpgradeSlots componentUpgrade;
    private final Fluids fluids;
    AxisAlignedBB searchArea;
    List<List<TileEntityApiary>> list;
    List<Chunk> chunks;

    public TileEntityCollectorProductBee() {
        this.searchArea = new AxisAlignedBB(this.field_174879_c.func_177982_a(-8, -8, -8), this.field_174879_c.func_177982_a(8, 8, 8));
        this.list = new ArrayList<List<TileEntityApiary>>();
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 10000.0, 1));
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankExtract("tank", 10000, Fluids.fluidPredicate(FluidName.fluidhoney.getInstance()));
        this.tank1 = this.fluids.addTankExtract("tank1", 10000, Fluids.fluidPredicate(FluidName.fluidroyaljelly.getInstance()));
        this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, 1, FluidName.fluidhoney.getInstance());
        this.fluidSlot.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.fluidSlot1 = new InvSlotFluidByList((TileEntityInventory)this, 1, FluidName.fluidroyaljelly.getInstance());
        this.fluidSlot1.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.outputSlot = new InvSlotOutput(this, 2);
        this.outputSlot1 = new InvSlotOutput(this, 16);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.collector_product_bee;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.collector_product_bee.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            AxisAlignedBB aabb;
            this.searchArea = aabb = this.searchArea.func_186670_a(this.field_174879_c);
            int j2 = MathHelper.func_76128_c((double)((aabb.field_72340_a - 2.0) / 16.0));
            int k2 = MathHelper.func_76143_f((double)((aabb.field_72336_d + 2.0) / 16.0));
            int l2 = MathHelper.func_76128_c((double)((aabb.field_72339_c - 2.0) / 16.0));
            int i3 = MathHelper.func_76143_f((double)((aabb.field_72334_f + 2.0) / 16.0));
            this.chunks = new ArrayList<Chunk>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    Chunk chunk = this.field_145850_b.func_72964_e(j3, k3);
                    if (this.chunks.contains(chunk)) continue;
                    this.chunks.add(chunk);
                }
            }
            for (Chunk chunk : this.chunks) {
                this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.field_145850_b, chunk.func_76632_l()));
            }
        }
    }

    public ContainerCollectorProductBee getGuiContainer(EntityPlayer var1) {
        return new ContainerCollectorProductBee(this, var1);
    }

    private void updateBee() {
        this.list.clear();
        for (Chunk chunk : this.chunks) {
            this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.field_145850_b, chunk.func_76632_l()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiCollectorProductBee(this.getGuiContainer(var1));
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.func_177958_n() > this.searchArea.field_72340_a && (double)vec.func_177958_n() < this.searchArea.field_72336_d) {
            if ((double)vec.func_177956_o() > this.searchArea.field_72338_b && (double)vec.func_177956_o() < this.searchArea.field_72337_e) {
                return (double)vec.func_177952_p() > this.searchArea.field_72339_c && (double)vec.func_177952_p() < this.searchArea.field_72334_f;
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.func_145831_w().func_72820_D() % 100L == 0L) {
            this.updateBee();
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L && this.energy.canUseEnergy(20.0)) {
            block0: for (List<TileEntityApiary> bees : this.list) {
                for (TileEntityApiary bee : bees) {
                    if (!(this.energy.getEnergy() >= 20.0)) break block0;
                    if (!this.contains(bee.func_174877_v())) continue;
                    if (bee.food > 750.0 && bee.getTickDrainFood() == 20 && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity() && this.energy.getEnergy() >= 20.0) {
                        bee.food -= 750.0;
                        this.tank.fill(new FluidStack(FluidName.fluidhoney.getInstance(), 1000), true);
                        this.energy.useEnergy(20.0);
                        bee.setTickDrainFood((byte)0);
                    }
                    if (bee.royalJelly > 50.0 && bee.getTickDrainJelly() == 20 && this.tank1.getFluidAmount() + 1000 <= this.tank1.getCapacity() && this.energy.getEnergy() >= 20.0) {
                        bee.royalJelly -= 50.0;
                        this.tank1.fill(new FluidStack(FluidName.fluidroyaljelly.getInstance(), 1000), true);
                        this.energy.useEnergy(20.0);
                        bee.setTickDrainJelly((byte)0);
                    }
                    if (bee.invSlotProduct.isEmpty() || !(this.energy.getEnergy() >= 20.0)) continue;
                    for (ItemStack stack : bee.invSlotProduct) {
                        if (!this.outputSlot1.add(stack)) continue;
                        stack.func_190918_g(stack.func_190916_E());
                    }
                    this.energy.useEnergy(20.0);
                }
            }
        }
        MutableObject output1 = new MutableObject();
        if (this.tank.getFluidAmount() - 1000 >= 0 && this.fluidSlot.transferFromTank((IFluidTank)this.tank, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot.transferFromTank((IFluidTank)this.tank, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
        }
        if (this.tank1.getFluidAmount() - 1000 >= 0 && this.fluidSlot1.transferFromTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot1.transferFromTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 20L == 0L) {
            this.upgradeSlot.tickNoMark();
        }
    }
}

