/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockDryer;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerOilPurifier;
import com.denfop.gui.GuiOilPurifier;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDryer
extends TileEntityInventory
implements IUpgradableBlock,
IHasRecipe {
    public final FluidHandlerRecipe fluid_handler;
    public final Fluids.InternalFluidTank fluidTank1;
    public InvSlotOutput outputSlot;
    public short progress = 0;
    public Map<UUID, Double> data = PrimitiveHandler.getPlayersData(EnumPrimitive.DRYER);

    public TileEntityDryer() {
        Fluids fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = fluids.addTank("fluidTank1", 5000);
        this.outputSlot = new InvSlotOutput(this, 1);
        this.fluid_handler = new FluidHandlerRecipe("dryer", fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(0)));
        Recipes.recipes.getRecipeFluid().addInitRecipes(this);
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.6, 1.0));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 4; ++i) {
            tooltip.add(Localization.translate("dryer.info" + i));
        }
    }

    @Override
    public void init() {
        Recipes.recipes.getRecipeFluid().addRecipe("dryer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack(FluidName.fluidrawlatex.getInstance(), 100)), new RecipeOutput(null, IUItem.latex)));
        Recipes.recipes.getRecipeFluid().addRecipe("dryer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack(FluidName.fluidhoney.getInstance(), 500)), new RecipeOutput(null, new ItemStack((Item)IUItem.honeycomb))));
        Recipes.recipes.getRecipeFluid().addRecipe("dryer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack(FluidName.fluidbeeswax.getInstance(), 500)), new RecipeOutput(null, new ItemStack((Item)IUItem.beeswax))));
        Recipes.recipes.getRecipeFluid().addRecipe("dryer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack(FluidName.fluidplantmixture.getInstance(), 500)), new RecipeOutput(null, new ItemStack((Item)IUItem.plant_mixture))));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.DRYER);
        if (IUCore.proxy.isSimulating()) {
            this.fluid_handler.load();
            new PacketUpdateFieldTile(this, "slot", this.outputSlot);
            new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (!this.func_145831_w().field_72995_K && player.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && this.fluidTank1.getFluidAmount() + 1000 <= this.fluidTank1.getCapacity()) {
            ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.getComp(Fluids.class).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side));
            if (!this.field_145850_b.field_72995_K) {
                new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
            }
            return true;
        }
        if (!this.outputSlot.isEmpty()) {
            if (!this.field_145850_b.field_72995_K) {
                ModUtils.dropAsEntity(this.field_145850_b, this.field_174879_c, this.outputSlot.get(), player);
            }
            this.outputSlot.put(0, ItemStack.field_190927_a);
            if (!this.field_145850_b.field_72995_K) {
                new PacketUpdateFieldTile(this, "slot3", false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new NBTTagCompound()));
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new NBTTagCompound()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluid_handler.output() == null && this.fluidTank1.getFluidAmount() >= 1) {
            this.fluid_handler.getOutput();
        } else if (this.fluid_handler.output() != null && !this.fluid_handler.checkFluids()) {
            this.fluid_handler.setOutput(null);
        }
        if (this.fluid_handler.output() != null && this.outputSlot.canAdd(this.fluid_handler.output().getOutput().items) && this.fluid_handler.canOperate()) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            this.progress = (short)((double)(this.progress + 1) + this.data.getOrDefault(this.getComponentPrivate().getPlayersUUID().get(0), 0.0) / 20.0);
            double k = this.progress;
            if (this.progress >= 100) {
                this.operate();
                if (!this.func_145831_w().field_72995_K) {
                    PrimitiveHandler.addExperience(EnumPrimitive.DRYER, 0.25, this.getComponentPrivate().getPlayersUUID().get(0));
                }
                this.progress = 0;
            }
        } else {
            if (this.fluid_handler.output() == null) {
                this.progress = 0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new NBTTagCompound()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank1.readFromNBT(fluidTank1.writeToNBT(new NBTTagCompound()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.outputSlot.put(0, ItemStack.field_190927_a);
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.fluid_handler.checkOutput();
            if (this.fluid_handler.output() == null) break;
        }
    }

    public void operateOnce() {
        this.fluid_handler.consume();
        this.outputSlot.add(this.fluid_handler.output().getOutput().items);
        new PacketUpdateFieldTile(this, "slot", this.outputSlot);
        new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockDryer.dryer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.dryer;
    }

    public ContainerOilPurifier getGuiContainer(EntityPlayer entityPlayer) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiOilPurifier getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return null;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, new UpgradableProperty[]{UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidExtract, UpgradableProperty.FluidInput, UpgradableProperty.ItemExtract});
    }
}

