/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerGenomeExtractor;
import com.denfop.gui.GuiGenomeExtractor;
import com.denfop.invslot.InvSlot;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGenomeExtractor
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final InvSlotOutput slot = new InvSlotOutput(this, 1);
    public final ComponentBaseEnergy energy;
    public final InvSlot input = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return stack.func_77973_b() instanceof ICropItem || stack.func_77973_b() instanceof ItemJarBees;
        }

        @Override
        public void put(int index, ItemStack content) {
            super.put(index, content);
            if (content.func_190926_b()) {
                TileEntityGenomeExtractor.this.genBee = null;
                TileEntityGenomeExtractor.this.genCrop = null;
            } else if (content.func_77973_b() instanceof ICropItem) {
                TileEntityGenomeExtractor.this.genCrop = new com.denfop.api.agriculture.genetics.Genome(content);
                TileEntityGenomeExtractor.this.genBee = null;
            } else {
                TileEntityGenomeExtractor.this.genBee = new Genome(content);
                TileEntityGenomeExtractor.this.genCrop = null;
            }
        }
    };
    public com.denfop.api.agriculture.genetics.Genome genCrop;
    public Genome genBee;
    int meta = -1;
    private boolean work;

    public TileEntityGenomeExtractor() {
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
        this.energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.QUANTUM, this, 1000.0));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        ItemStack stack;
        super.readContainerPacket(customPacketBuffer);
        boolean hasGenCrop = customPacketBuffer.readBoolean();
        boolean hasGenBee = customPacketBuffer.readBoolean();
        if (hasGenCrop) {
            try {
                stack = customPacketBuffer.func_150791_c();
                this.genCrop = new com.denfop.api.agriculture.genetics.Genome(stack);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.genCrop = null;
        }
        if (hasGenBee) {
            try {
                stack = customPacketBuffer.func_150791_c();
                this.genBee = new Genome(stack);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.genBee = null;
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.genCrop != null);
        customPacketBuffer.writeBoolean(this.genBee != null);
        if (this.genCrop != null) {
            customPacketBuffer.func_150788_a(this.genCrop.getStack());
        }
        if (this.genBee != null) {
            customPacketBuffer.func_150788_a(this.genBee.getStack());
        }
        return customPacketBuffer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.genome_extractor;
    }

    public ContainerGenomeExtractor getGuiContainer(EntityPlayer var1) {
        return new ContainerGenomeExtractor(this, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return new GuiGenomeExtractor(this.getGuiContainer(var1));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && !this.input.get().func_190926_b() && this.slot.isEmpty() && this.meta != -1) {
            if (this.energy.getEnergy() >= 50.0) {
                this.energy.useEnergy(50.0);
                this.work = false;
                if (this.genCrop != null) {
                    this.genCrop.removeGenome(com.denfop.api.agriculture.genetics.GeneticTraits.values()[this.meta], this.input.get());
                    this.slot.add(new ItemStack((Item)IUItem.genome_crop, 1, this.meta));
                } else if (this.genBee != null) {
                    this.genBee.removeGenome(GeneticTraits.values()[this.meta], this.input.get());
                    this.slot.add(new ItemStack((Item)IUItem.genome_bee, 1, this.meta));
                }
            }
            this.meta = -1;
        } else {
            this.work = false;
            if (this.input.get().func_190926_b()) {
                this.genCrop = null;
                this.genBee = null;
            }
        }
    }

    @Override
    public void updateTileServer(EntityPlayer var1, double var2) {
        if (var2 == -1.0) {
            this.work = true;
        } else {
            this.meta = (int)var2;
        }
    }
}

