/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.events.client.SolarSystemRenderer;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHologramSpace
extends TileEntityBlock {
    public List<IFakeBody> fakeBodyList = new ArrayList<IFakeBody>();
    @SideOnly(value=Side.CLIENT)
    SolarSystemRenderer solarSystemRenderer;
    private UUID uuid;

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.func_145831_w().field_72995_K) {
            this.solarSystemRenderer = new SolarSystemRenderer();
            GlobalRenderManager.addRender(this.field_145850_b, this.field_174879_c, this.createFunction(this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Function createFunction(TileEntityHologramSpace te) {
        Function<Object, Object> function = o -> {
            this.solarSystemRenderer.render(te);
            return 0;
        };
        return function;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.uuid = nbtTagCompound.func_186857_a("player");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(nbt);
        nbtTagCompound.func_186854_a("player", this.uuid);
        return nbtTagCompound;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof EntityPlayer) {
            this.uuid = placer.func_110124_au();
        }
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.func_145831_w().field_72995_K) {
            GlobalRenderManager.removeRender(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        this.fakeBodyList = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(this.uuid);
        if (this.fakeBodyList != null) {
            CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
            packetBuffer.writeInt(this.fakeBodyList.size());
            for (IFakeBody fakeBody : this.fakeBodyList) {
                if (fakeBody instanceof IFakePlanet) {
                    packetBuffer.writeByte(0);
                }
                if (fakeBody instanceof IFakeSatellite) {
                    packetBuffer.writeByte(1);
                }
                if (fakeBody instanceof IFakeAsteroid) {
                    packetBuffer.writeByte(2);
                }
                if (fakeBody == null) continue;
                try {
                    EncoderHandler.encode(packetBuffer, fakeBody.writeNBTTagCompound(new NBTTagCompound()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return packetBuffer;
        }
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeInt(0);
        return packetBuffer;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer is) {
        super.readUpdatePacket(is);
        int size = is.readInt();
        this.fakeBodyList.clear();
        for (int i = 0; i < size; ++i) {
            byte id = is.readByte();
            try {
                IFakeBody fakePlanet;
                NBTTagCompound nbt;
                if (id == 0) {
                    nbt = (NBTTagCompound)DecoderHandler.decode(is);
                    fakePlanet = new FakePlanet(nbt);
                    this.fakeBodyList.add(fakePlanet);
                }
                if (id == 1) {
                    nbt = (NBTTagCompound)DecoderHandler.decode(is);
                    fakePlanet = new FakeSatellite(nbt);
                    this.fakeBodyList.add(fakePlanet);
                }
                if (id != 2) continue;
                nbt = (NBTTagCompound)DecoderHandler.decode(is);
                fakePlanet = new FakeAsteroid(nbt);
                this.fakeBodyList.add(fakePlanet);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("fakebody")) {
            int size = is.readInt();
            this.fakeBodyList.clear();
            for (int i = 0; i < size; ++i) {
                byte id = is.readByte();
                try {
                    IFakeBody fakePlanet;
                    NBTTagCompound nbt;
                    if (id == 0) {
                        nbt = (NBTTagCompound)DecoderHandler.decode(is);
                        fakePlanet = new FakePlanet(nbt);
                        this.fakeBodyList.add(fakePlanet);
                    }
                    if (id == 1) {
                        nbt = (NBTTagCompound)DecoderHandler.decode(is);
                        fakePlanet = new FakeSatellite(nbt);
                        this.fakeBodyList.add(fakePlanet);
                    }
                    if (id != 2) continue;
                    nbt = (NBTTagCompound)DecoderHandler.decode(is);
                    fakePlanet = new FakeAsteroid(nbt);
                    this.fakeBodyList.add(fakePlanet);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.hologram_space;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }
}

