/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.bee.genetics.IGenomeItem;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerInoculator;
import com.denfop.gui.GuiInoculator;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityInoculator
extends TileElectricMachine
implements IHasRecipe,
IAudioFixer,
IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent {
    public final InvSlotRecipes inputSlotA;
    public final InvSlotUpgrade upgradeSlot;
    public ComponentUpgradeSlots componentUpgrade;
    public ComponentProgress componentProgress;
    public ComponentProcess componentProcess;
    public MachineRecipe output;

    public TileEntityInoculator() {
        super(300.0, 1, 1);
        Recipes.recipes.addInitRecipes(this);
        this.inputSlotA = new InvSlotRecipes(this, "inoculator", this){

            @Override
            public boolean accepts(ItemStack itemStack, int index) {
                return itemStack.func_77973_b() instanceof ICropItem || itemStack.func_77973_b() instanceof IGenomeItem || itemStack.func_77973_b() instanceof com.denfop.api.agriculture.genetics.IGenomeItem || itemStack.func_77973_b() == IUItem.jarBees;
            }
        };
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot){

            @Override
            public void onLoaded() {
                super.onLoaded();
                this.componentProcess = ((TileEntityInoculator)this.getParent()).componentProcess;
            }
        });
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 300));
        this.componentProcess = this.addComponent(new ComponentProcess(this, 300, 1.0){

            @Override
            public void operateWithMax(MachineRecipe output, int size) {
                this.operateWithMax(output);
            }

            @Override
            public boolean checkRecipe() {
                ItemStack genome;
                if (TileEntityInoculator.this.output == null) {
                    return false;
                }
                ItemStack stack1 = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(0) : this.invSlotRecipes.get(1);
                ItemStack itemStack = genome = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(1) : this.invSlotRecipes.get(0);
                if (this.isCrop(stack1)) {
                    com.denfop.api.agriculture.genetics.Genome genome1 = new com.denfop.api.agriculture.genetics.Genome(stack1);
                    com.denfop.api.agriculture.genetics.IGenomeItem genomeItem = (com.denfop.api.agriculture.genetics.IGenomeItem)genome.func_77973_b();
                    com.denfop.api.agriculture.genetics.GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    return !genome1.hasGenome(genomeTraits.getGenetic());
                }
                if (this.isBee(stack1)) {
                    Genome genome1 = new Genome(stack1);
                    IGenomeItem genomeItem = (IGenomeItem)genome.func_77973_b();
                    GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    return !genome1.hasGenome(genomeTraits.getGenetic());
                }
                return false;
            }

            public boolean isCrop(ItemStack stack) {
                return stack.func_77973_b() instanceof ICropItem;
            }

            public boolean isBee(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemJarBees;
            }

            @Override
            public void operateWithMax(MachineRecipe output) {
                ItemStack genome;
                ItemStack stack1 = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(0) : this.invSlotRecipes.get(1);
                ItemStack itemStack = genome = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(1) : this.invSlotRecipes.get(0);
                if (this.isCrop(stack1)) {
                    com.denfop.api.agriculture.genetics.IGenomeItem genomeItem = (com.denfop.api.agriculture.genetics.IGenomeItem)genome.func_77973_b();
                    com.denfop.api.agriculture.genetics.Genome genome1 = new com.denfop.api.agriculture.genetics.Genome(stack1);
                    com.denfop.api.agriculture.genetics.GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    genome1.addGenome(genomeTraits, stack1);
                    ItemStack outputStack = genome1.getStack().func_77946_l();
                    this.invSlotRecipes.consume();
                    this.outputSlot.add(outputStack);
                } else if (this.isBee(stack1)) {
                    IGenomeItem genomeItem = (IGenomeItem)genome.func_77973_b();
                    Genome genome1 = new Genome(stack1);
                    GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    genome1.addGenome(genomeTraits);
                    ItemStack outputStack = genome1.getStack().func_77946_l();
                    this.invSlotRecipes.consume();
                    this.outputSlot.add(outputStack);
                }
            }
        });
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
    }

    public static void addRecipe(ItemStack container, ItemStack output) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("inoculator", new BaseMachineRecipe(new Input(input.getInput(container), input.getInput(output)), new RecipeOutput(null, container)));
    }

    @Override
    public void init() {
        ItemStack input;
        int i;
        for (i = 0; i < 82; ++i) {
            if (i == 3) continue;
            input = new ItemStack((Item)IUItem.crops);
            NBTTagCompound nbt = ModUtils.nbt(input);
            nbt.func_74768_a("crop_id", i);
            com.denfop.api.agriculture.genetics.GeneticTraits[] geneticTraitsArray = com.denfop.api.agriculture.genetics.GeneticTraits.values();
            int n = geneticTraitsArray.length;
            for (int j = 0; j < n; ++j) {
                com.denfop.api.agriculture.genetics.GeneticTraits traits = geneticTraitsArray[j];
                TileEntityInoculator.addRecipe(input, new ItemStack((Item)IUItem.genome_crop, 1, traits.ordinal()));
            }
        }
        for (i = 1; i < 6; ++i) {
            input = IUItem.jarBees.getStackFromId(i);
            for (GeneticTraits traits : GeneticTraits.values()) {
                TileEntityInoculator.addRecipe(input, new ItemStack((Item)IUItem.genome_bee, 1, traits.ordinal()));
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.inoculator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiInoculator(this.getGuiContainer(entityPlayer));
    }

    public ContainerInoculator getGuiContainer(EntityPlayer var1) {
        return new ContainerInoculator(var1, this);
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

